/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.internal;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.mita.base.types.GeneratedElement;
import org.eclipse.mita.base.types.GeneratedType;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.program.GeneratedFunctionDefinition;
import org.eclipse.mita.program.generator.AbstractFunctionGenerator;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.AbstractTypeGenerator;
import org.eclipse.mita.program.generator.IGenerator;
import org.eclipse.mita.program.resource.PluginResourceLoader;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Singleton
public class GeneratorRegistry {
    @Inject
    protected PluginResourceLoader loader;
    private final LoadingCache<GeneratedElement, Optional<IGenerator>> generatorCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<GeneratedElement, Optional<IGenerator>>(){

        public Optional<IGenerator> load(GeneratedElement elem) {
            Object _loadFromPlugin = GeneratorRegistry.this.loader.loadFromPlugin(elem.eResource(), elem.getGenerator());
            IGenerator result = (IGenerator)_loadFromPlugin;
            if (result == null) {
                return Optional.absent();
            }
            return Optional.of((Object)result);
        }
    });

    public AbstractSystemResourceGenerator getGenerator(AbstractSystemResource resource) {
        try {
            IGenerator _orNull = (IGenerator)((Optional)this.generatorCache.get((Object)resource)).orNull();
            return (AbstractSystemResourceGenerator)_orNull;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public AbstractTypeGenerator getGenerator(GeneratedType type) {
        try {
            IGenerator _orNull = (IGenerator)((Optional)this.generatorCache.get((Object)type)).orNull();
            return (AbstractTypeGenerator)_orNull;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public AbstractFunctionGenerator getGenerator(GeneratedFunctionDefinition function) {
        try {
            IGenerator _orNull = (IGenerator)((Optional)this.generatorCache.get((Object)function)).orNull();
            return (AbstractFunctionGenerator)_orNull;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

