/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.transformation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.program.AbstractStatement;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.ProgramBlock;
import org.eclipse.mita.program.generator.transformation.AbstractTransformationStage;
import org.eclipse.mita.program.generator.transformation.UnravelModalityAccessStage;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class GroupModalityAccessStage
extends AbstractTransformationStage {
    @Override
    public int getOrder() {
        return GroupModalityAccessStage.afterwards(UnravelModalityAccessStage.ORDER);
    }

    public static int afterwards(int x) {
        return x + 10;
    }

    protected void _doTransform(final ProgramBlock obj) {
        this.transformChildren(obj);
        HashMap<String, ModalityAccessPreparation> preparationCollapseMap = new HashMap<String, ModalityAccessPreparation>();
        EList<AbstractStatement> _content = obj.getContent();
        for (final AbstractStatement statement : _content) {
            if (statement instanceof ModalityAccessPreparation) {
                boolean readAlreadyPrepared;
                String systemResourceName = ((ModalityAccessPreparation)statement).getSystemResource().getName();
                boolean resourceAlradyPrepared = preparationCollapseMap.containsKey(systemResourceName);
                boolean bl = readAlreadyPrepared = resourceAlradyPrepared && this.containsAnyModality((ModalityAccessPreparation)preparationCollapseMap.get(systemResourceName), ((ModalityAccessPreparation)statement).getModalities());
                if (resourceAlradyPrepared && !readAlreadyPrepared) {
                    ModalityAccessPreparation colapseTarget = (ModalityAccessPreparation)preparationCollapseMap.get(systemResourceName);
                    colapseTarget.getModalities().addAll(((ModalityAccessPreparation)statement).getModalities());
                    final ModalityAccessPreparation newObj = colapseTarget;
                    Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                        public void apply(EObject it) {
                            GroupModalityAccessStage.this.replaceAllReferencesWith(statement, newObj, obj);
                        }
                    };
                    this.addPostTransformation((Procedures.Procedure1<? super EObject>)_function);
                    Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                        public void apply(EObject it) {
                            GroupModalityAccessStage.this.removeFromParent(statement);
                        }
                    };
                    this.addPostTransformation((Procedures.Procedure1<? super EObject>)_function_1);
                    continue;
                }
                if (resourceAlradyPrepared && readAlreadyPrepared) {
                    preparationCollapseMap.put(systemResourceName, (ModalityAccessPreparation)statement);
                    continue;
                }
                preparationCollapseMap.put(systemResourceName, (ModalityAccessPreparation)statement);
                continue;
            }
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)statement.eContents(), ProgramBlock.class));
            if (_isEmpty) continue;
            preparationCollapseMap.clear();
        }
    }

    public boolean containsAnyModality(ModalityAccessPreparation preparation, EList<Modality> list) {
        Functions.Function1<Modality, String> _function = new Functions.Function1<Modality, String>(){

            public String apply(Modality it) {
                return it.getName();
            }
        };
        List _map = ListExtensions.map(preparation.getModalities(), (Functions.Function1)_function);
        final HashSet presentModalityNames = new HashSet(_map);
        Functions.Function1<Modality, Boolean> _function_1 = new Functions.Function1<Modality, Boolean>(){

            public Boolean apply(Modality it) {
                return presentModalityNames.contains(it.getName());
            }
        };
        return IterableExtensions.exists(list, (Functions.Function1)_function_1);
    }

    public void removeFromParent(EObject obj) {
        EObject parent = obj.eContainer();
        boolean _isMany = obj.eContainingFeature().isMany();
        if (_isMany) {
            Object _eGet = parent.eGet(obj.eContainingFeature());
            ((List)_eGet).remove(obj);
        } else {
            parent.eSet(obj.eContainingFeature(), null);
        }
    }

    public void replaceAllReferencesWith(final EObject oldObj, final EObject newObj, EObject context) {
        Functions.Function1<ElementReferenceExpression, Boolean> _function = new Functions.Function1<ElementReferenceExpression, Boolean>(){

            public Boolean apply(ElementReferenceExpression it) {
                EObject _reference = it.getReference();
                return Objects.equal((Object)_reference, (Object)oldObj);
            }
        };
        Procedures.Procedure1<ElementReferenceExpression> _function_1 = new Procedures.Procedure1<ElementReferenceExpression>(){

            public void apply(ElementReferenceExpression it) {
                it.setReference(newObj);
            }
        };
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)context.eAllContents(), ElementReferenceExpression.class), (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
        Functions.Function1<FeatureCall, Boolean> _function_2 = new Functions.Function1<FeatureCall, Boolean>(){

            public Boolean apply(FeatureCall it) {
                EObject _feature = it.getFeature();
                return Objects.equal((Object)_feature, (Object)oldObj);
            }
        };
        Procedures.Procedure1<FeatureCall> _function_3 = new Procedures.Procedure1<FeatureCall>(){

            public void apply(FeatureCall it) {
                it.setFeature(newObj);
            }
        };
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)context.eAllContents(), FeatureCall.class), (Functions.Function1)_function_2), (Procedures.Procedure1)_function_3);
        Functions.Function1<ModalityAccess, Boolean> _function_4 = new Functions.Function1<ModalityAccess, Boolean>(){

            public Boolean apply(ModalityAccess it) {
                ModalityAccessPreparation _preparation = it.getPreparation();
                return Objects.equal((Object)_preparation, (Object)oldObj);
            }
        };
        Procedures.Procedure1<ModalityAccess> _function_5 = new Procedures.Procedure1<ModalityAccess>(){

            public void apply(ModalityAccess it) {
                it.setPreparation((ModalityAccessPreparation)newObj);
            }
        };
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)context.eAllContents(), ModalityAccess.class), (Functions.Function1)_function_4), (Procedures.Procedure1)_function_5);
    }

    @Override
    protected void doTransform(EObject obj) {
        if (obj instanceof ProgramBlock) {
            this._doTransform((ProgramBlock)obj);
            return;
        }
        if (obj != null) {
            this._doTransform(obj);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(obj).toString());
    }
}

