/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.transformation;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.generator.transformation.AbstractTransformationStage;
import org.eclipse.mita.program.generator.transformation.AbstractUnravelingStage;
import org.eclipse.mita.program.generator.transformation.AddExceptionVariableStage;
import org.eclipse.mita.program.generator.transformation.EnforceOperatorPrecedenceStage;
import org.eclipse.mita.program.generator.transformation.EscapeWhitespaceInStringStage;
import org.eclipse.mita.program.generator.transformation.GroupModalityAccessStage;
import org.eclipse.mita.program.generator.transformation.ITransformationPipelineInfoProvider;
import org.eclipse.mita.program.generator.transformation.PrepareArrayRuntimeChecksStage;
import org.eclipse.mita.program.generator.transformation.PrepareLoopForFunctionUnvravelingStage;
import org.eclipse.mita.program.generator.transformation.ResolveEnumValuesStage;
import org.eclipse.mita.program.generator.transformation.ResolveExtensionMethodsStage;
import org.eclipse.mita.program.generator.transformation.ResolveGeneratedTypeConstructorStage;
import org.eclipse.mita.program.generator.transformation.UnravelFunctionCallsStage;
import org.eclipse.mita.program.generator.transformation.UnravelInterpolatedStringsStage;
import org.eclipse.mita.program.generator.transformation.UnravelLiteralArraysStage;
import org.eclipse.mita.program.generator.transformation.UnravelModalityAccessStage;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ProgramGenerationTransformationPipeline
implements ITransformationPipelineInfoProvider {
    @Inject
    private AddExceptionVariableStage addExceptionVariableStage;
    @Inject
    private EscapeWhitespaceInStringStage escapeWhitespaceInStringStage;
    @Inject
    private UnravelModalityAccessStage unravelModalityAccessStage;
    @Inject
    private GroupModalityAccessStage groupModalityAccessStage;
    @Inject
    private ResolveExtensionMethodsStage resolveExtensionMethodsStage;
    @Inject
    private ResolveGeneratedTypeConstructorStage resolveGeneratedTypeConstructorStage;
    @Inject
    private UnravelFunctionCallsStage unravelFunctionCallsStage;
    @Inject
    private UnravelInterpolatedStringsStage unravelInterpolatedStringsStage;
    @Inject
    private ResolveEnumValuesStage resolveEnumValuesStage;
    @Inject
    private PrepareLoopForFunctionUnvravelingStage prepareLoopForFunctionUnvravelingStage;
    @Inject
    private PrepareArrayRuntimeChecksStage prepareArrayRuntimeChecksStage;
    @Inject
    private UnravelLiteralArraysStage unravelLiteralArrayReturnStage;
    @Inject
    private EnforceOperatorPrecedenceStage enforceOperatorPrecedenceStage;

    public Program transform(Program program) {
        List<? extends AbstractTransformationStage> stages = this.getOrderedStages();
        Program result = program;
        for (AbstractTransformationStage abstractTransformationStage : stages) {
            result = abstractTransformationStage.transform(this, result);
        }
        return result;
    }

    @Override
    public boolean willBeUnraveled(EObject obj) {
        if (obj instanceof Expression) {
            List<? extends AbstractTransformationStage> _orderedStages = this.getOrderedStages();
            for (AbstractTransformationStage abstractTransformationStage : _orderedStages) {
                boolean _needsUnraveling;
                if (!(abstractTransformationStage instanceof AbstractUnravelingStage) || !(_needsUnraveling = ((AbstractUnravelingStage)abstractTransformationStage).needsUnraveling((Expression)obj))) continue;
                return true;
            }
        }
        return false;
    }

    protected List<? extends AbstractTransformationStage> getOrderedStages() {
        Functions.Function1<AbstractTransformationStage, Integer> _function = new Functions.Function1<AbstractTransformationStage, Integer>(){

            public Integer apply(AbstractTransformationStage x) {
                return x.getOrder();
            }
        };
        return IterableExtensions.sortBy(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new AbstractTransformationStage[]{this.addExceptionVariableStage, this.escapeWhitespaceInStringStage, this.unravelModalityAccessStage, this.groupModalityAccessStage, this.resolveExtensionMethodsStage, this.resolveGeneratedTypeConstructorStage, this.unravelFunctionCallsStage, this.unravelInterpolatedStringsStage, this.resolveEnumValuesStage, this.prepareLoopForFunctionUnvravelingStage, this.prepareArrayRuntimeChecksStage, this.unravelLiteralArrayReturnStage, this.enforceOperatorPrecedenceStage})), (Functions.Function1)_function);
    }
}

