/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mita.base.expressions.Argument;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.AssignmentExpression;
import org.eclipse.mita.base.expressions.AssignmentOperator;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.ExpressionsPackage;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.expressions.Literal;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.GeneratedType;
import org.eclipse.mita.base.types.NamedElement;
import org.eclipse.mita.base.types.NamedProductType;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.Property;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.mita.base.types.validation.TypeValidator;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.platform.Platform;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.ArrayLiteral;
import org.eclipse.mita.program.DereferenceExpression;
import org.eclipse.mita.program.DoWhileStatement;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.FunctionParameterDeclaration;
import org.eclipse.mita.program.GeneratedFunctionDefinition;
import org.eclipse.mita.program.IfStatement;
import org.eclipse.mita.program.NewInstanceExpression;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramBlock;
import org.eclipse.mita.program.ProgramPackage;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.ValueRange;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.WhileStatement;
import org.eclipse.mita.program.inferrer.ElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ElementSizeInferrer;
import org.eclipse.mita.program.inferrer.InvalidElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ProgramDslTypeInferrer;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.inferrer.ValidElementSizeInferenceResult;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.resource.PluginResourceLoader;
import org.eclipse.mita.program.scoping.ExtensionMethodHelper;
import org.eclipse.mita.program.validation.AbstractProgramDslValidator;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.mita.program.validation.ProgramImportValidator;
import org.eclipse.mita.program.validation.ProgramNamesAreUniqueValidator;
import org.eclipse.mita.program.validation.ProgramSetupValidator;
import org.eclipse.mita.program.validation.ReferenceTypesValidator;
import org.eclipse.mita.program.validation.SumTypesValidator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@ComposedChecks(validators={ProgramNamesAreUniqueValidator.class, ProgramImportValidator.class, ProgramSetupValidator.class, SumTypesValidator.class, ReferenceTypesValidator.class})
public class ProgramDslValidator
extends AbstractProgramDslValidator {
    public static final String WRONG_NR_OF_ARGS_CODE = "wrong_nr_of_args";
    public static final String WRONG_NR_OF_ARGS_MSG = "Wrong number of arguments, expected %s.";
    public static final String MIXED_PARAMS_CODE = "mixed_parameter";
    public static final String MIXED_PARAMS_MSG = "Positional and named parameters must not be mixed.";
    public static final String MISSING_CONNECTIVITY_CODE = "missing_connectivity";
    public static final String VOID_OP_CANNOT_RETURN_VALUE_MSG = "Void operations cannot return a value.";
    public static final String VOID_OP_CANNOT_RETURN_VALUE_CODE = "void_op_cannot_return_value";
    public static final String VOID_VARIABLE_TYPE = "Void is an invalid type for variables";
    public static final String MISSING_RETURN_VALUE_MSG = "The operation must return a value of type %s.";
    public static final String MISSING_RETURN_VALUE_CODE = "missing_return_value";
    public static final String INCOMPATIBLE_RETURN_TYPE_MSG = "The return type '%s' is not compatible with the operation's type '%s'.";
    public static final String INCOMPATIBLE_RETURN_TYPE_CODE = "incompatible_return_type";
    public static final String FUNCTION_RETURN_TYPE_NOT_PRIMITIVE_MSG = "Returning non-primitive values from functions is experimental and might result in invalid C code.";
    public static final String FUNCTION_RETURN_TYPE_NOT_PRIMITIVE_CODE = "function_return_type_not_primitive";
    public static final String EVENT_RETURNS_VALUE_MSG = "Events may not return values.";
    public static final String EVENT_RETURNS_VALUE_CODE = "event_return_value_not_nothing";
    public static final String VARIABLE_NOT_UNIQUE_MSG = "Cannot redeclare variable '%s'.";
    public static final String VARIABLE_NOT_UNIQUE_CODE = "variable_not_unique";
    public static final String NO_PLATFORM_SELECTED_MSG = "No platform selected. Please import one of the available platforms: \"%s.\"";
    public static final String NO_PLATFORM_SELECTED_CODE = "no_platform_selected";
    public static final String FUNCTIONS_CAN_NOT_BE_REFERENCED_MSG = "Functions can not be used as values. Please add parentheses.";
    public static final String FUNCTIONS_CAN_NOT_BE_REFERENCED_CODE = "no_function_references";
    public static final String OPTIONAL_PARAMETERS_NOT_IMPLEMENTED_MSG = "Default values for function parameters are not allowed.";
    public static final String OPTIONAL_PARAMETERS_NOT_IMPLEMENTED_CODE = "optional_parameters_not_implemented";
    public static final String INCOMPATIBLE_TYPES_MSG = "Incompatible types: '%s' can't be converted to '%s'.";
    public static final String ARRAY_LITERALS_CANT_BE_EMPTY = "Array literals can not be empty.";
    public static final String ARRAY_LITERAL_IS_NOT_HOMOGENOUS = "Array literal is not homogenous.";
    public static final String ARRAY_RANGE_INVALID = "Array range is invalid: %s";
    public static final String ARRAY_RANGE_ONLY_ON_ARRAY = "Array ranges are only supported on array types.";
    public static final String NESTED_ARRAY_LITERALS_NOT_SUPPORTED = "Nested array literals are not supported yet.";
    public static final String ARRAY_SLICES_ARE_NOT_SUPPORTED_TOP_LEVEL = "Array slices are not supported in global scope.";
    public static final String ARRAY_INDEX_OUT_OF_BOUNDS = "Array index out of bounds: length = %d";
    public static final String ARRAY_INDEX_MUST_BE_INTEGER = "Array index must be integer.";
    public static final String NESTED_GENERATED_TYPES_ARE_NOT_SUPPORTED = "Nested generated types are not supported yet.";
    public static final String IMPLICIT_TO_OPTIONAL_IS_NOT_SUPPORTED = "Implicit construction of optionals in %s is not yet supported. Please use 'optional.some' instead.";
    public static final String SIZE_INFERENCE_FAILED_FOR_RETURN = "Could not infer the size of the function's return.";
    public static final String MUST_BE_USED_IMMEDIATELY_MSG = "%s must be used immediately. %s";
    public static final String MUST_BE_USED_IMMEDIATELY_CODE = "must_be_used_immediately";
    public static final String SIGINST_MODALITY_CANT_BE_FUNC_PARAM_MSG = "Signal instances and modalities cannot be passed as parameters.";
    @Inject
    @Extension
    private ExtensionMethodHelper _extensionMethodHelper;
    @Inject
    @Extension
    private ProgramDslTypeInferrer inferrer;
    @Inject
    private ITypeSystem typeSystem;
    @Inject
    private TypeValidator validator;
    @Inject
    private PluginResourceLoader loader;
    @Inject
    private ElementSizeInferrer elementSizeInferrer;
    @Inject
    private ModelUtils modelUtils;

    @Check(value=CheckType.NORMAL)
    public void checkElementSizeInference(VariableDeclaration variable) {
        boolean _tripleNotEquals;
        SystemResourceSetup _containerOfType = (SystemResourceSetup)EcoreUtil2.getContainerOfType((EObject)variable, SystemResourceSetup.class);
        boolean bl = _tripleNotEquals = _containerOfType != null;
        if (_tripleNotEquals) {
            return;
        }
        ElementSizeInferenceResult sizeInferenceResult = this.elementSizeInferrer.infer(variable);
        Iterable<InvalidElementSizeInferenceResult> invalidElements = sizeInferenceResult.getInvalidSelfOrChildren();
        for (InvalidElementSizeInferenceResult invalidElement : invalidElements) {
            Resource _eResource_1;
            boolean _equals;
            if (invalidElement.getTypeOf() != null && Objects.equal((Object)invalidElement.getTypeOf().getType().getName(), (Object)"array")) continue;
            VariableDeclaration _xifexpression = null;
            EObject _root = invalidElement.getRoot();
            Resource _eResource = null;
            if (_root != null) {
                _eResource = _root.eResource();
            }
            _xifexpression = (_equals = Objects.equal((Object)_eResource, (Object)(_eResource_1 = variable.eResource()))) ? invalidElement.getRoot() : variable;
            VariableDeclaration invalidObj = _xifexpression;
            String _message = invalidElement.getMessage();
            String _plus = "Cannot determine size of element: " + _message;
            EClass _eClass = null;
            if (invalidObj != null) {
                _eClass = invalidObj.eClass();
            }
            EList _eAllAttributes = null;
            if (_eClass != null) {
                _eAllAttributes = _eClass.getEAllAttributes();
            }
            EAttribute _head = null;
            if (_eAllAttributes != null) {
                _head = (EAttribute)IterableExtensions.head((Iterable)_eAllAttributes);
            }
            this.error(_plus, invalidObj, (EStructuralFeature)_head);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkSiginstOrModalityIsUsedImediately(FeatureCall featureCall) {
        EObject _reference;
        EObject operation;
        EObject _feature_2;
        EObject _feature = featureCall.getFeature();
        boolean isSiginst = _feature instanceof SignalInstance;
        EObject _feature_1 = featureCall.getFeature();
        boolean isModality = _feature_1 instanceof Modality;
        if (!isSiginst && !isModality) {
            return;
        }
        EObject container = featureCall.eContainer();
        if (container instanceof FeatureCall ? (_feature_2 = ((FeatureCall)container).getFeature()) instanceof GeneratedFunctionDefinition : container instanceof Argument && (operation = ((Argument)container).eContainer()) instanceof ElementReferenceExpression && (_reference = ((ElementReferenceExpression)operation).getReference()) instanceof GeneratedFunctionDefinition) {
            return;
        }
        EObject _feature_3 = featureCall.getFeature();
        String featureName = ((NamedElement)_feature_3).getName();
        String _xifexpression = null;
        if (isModality) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Add .read() after ");
            _builder.append(featureName);
            _xifexpression = String.format(MUST_BE_USED_IMMEDIATELY_MSG, "Modalities", _builder);
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Add .read() or .write() after ");
            _builder_1.append(featureName);
            _xifexpression = String.format(MUST_BE_USED_IMMEDIATELY_MSG, "Signal instances", _builder_1);
        }
        String msg = _xifexpression;
        this.error(msg, (EObject)featureCall, (EStructuralFeature)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE, MUST_BE_USED_IMMEDIATELY_CODE, new String[0]);
    }

    @Check(value=CheckType.NORMAL)
    public void checkSetup_platformValidator(SystemResourceSetup setup) {
        AbstractSystemResource _xifexpression = null;
        AbstractSystemResource _type = setup.getType();
        if (_type instanceof AbstractSystemResource) {
            AbstractSystemResource _type_1;
            _xifexpression = _type_1 = setup.getType();
        }
        AbstractSystemResource systemResource = _xifexpression;
        EObject _eContainer = setup.eContainer();
        this.runLibraryValidator((Program)_eContainer, setup, systemResource.eResource(), systemResource.getValidator());
    }

    @Check(value=CheckType.NORMAL)
    public Object checkProgram_platformValidator(Program program) {
        Object _xblockexpression = null;
        Platform platform = this.modelUtils.getPlatform(program);
        Object _xifexpression = null;
        if (platform == null) {
            _xifexpression = null;
        } else {
            this.runLibraryValidator(program, (EObject)platform, platform.eResource(), platform.getValidator());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Check(value=CheckType.NORMAL)
    public void checkVariableDeclaration_hasValidType(VariableDeclaration variable) {
        TypeSpecifier explicitType = variable.getTypeSpecifier();
        if (explicitType == null) {
            return;
        }
        Expression initialization = variable.getInitialization();
        if (initialization == null) {
            return;
        }
        ITypeSystemInferrer.InferenceResult explicitTypeInfered = this.inferrer.infer((EObject)explicitType);
        ITypeSystemInferrer.InferenceResult initializationTypeInfered = this.inferrer.infer((EObject)initialization);
        Type _type = null;
        if (explicitTypeInfered != null) {
            _type = explicitTypeInfered.getType();
        }
        Type _type_1 = null;
        if (initializationTypeInfered != null) {
            _type_1 = initializationTypeInfered.getType();
        }
        this.validator.assertAssignable(explicitTypeInfered, initializationTypeInfered, String.format("Assignment operator '%s' may only be applied on compatible types, not on %s and %s.", AssignmentOperator.ASSIGN, _type, _type_1), (IValidationIssueAcceptor)this);
    }

    @Check(value=CheckType.FAST)
    public void checkVariableDeclaration_isUniqueInProgramBlock(final VariableDeclaration variable) {
        Functions.Function1<VariableDeclaration, Boolean> _function;
        ProgramBlock parentBlock = (ProgramBlock)EcoreUtil2.getContainerOfType((EObject)variable, ProgramBlock.class);
        if (parentBlock == null) {
            return;
        }
        Iterable variablesInBlock = Iterables.filter(parentBlock.getContent(), VariableDeclaration.class);
        VariableDeclaration conflictingVariable = (VariableDeclaration)IterableExtensions.findFirst((Iterable)variablesInBlock, (Functions.Function1)(_function = new Functions.Function1<VariableDeclaration, Boolean>(){

            public Boolean apply(VariableDeclaration x) {
                return !Objects.equal((Object)x, (Object)variable) && Objects.equal((Object)x.getName(), (Object)variable.getName());
            }
        }));
        if (conflictingVariable != null) {
            this.error(String.format(VARIABLE_NOT_UNIQUE_MSG, variable.getName()), variable, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME, VARIABLE_NOT_UNIQUE_CODE, new String[0]);
        }
    }

    public void runLibraryValidator(Program program, EObject context, Resource validatorOrigin, String validatorClassName) {
        if (validatorClassName != null) {
            try {
                Object _loadFromPlugin = this.loader.loadFromPlugin(validatorOrigin, validatorClassName);
                IResourceValidator validator = (IResourceValidator)_loadFromPlugin;
                validator.validate(program, context, (ValidationMessageAcceptor)this);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkOperationArguments_FeatureCall(FeatureCall call) {
        EObject feature = call.getFeature();
        if (feature instanceof Operation) {
            boolean _tripleNotEquals;
            boolean _not;
            boolean _isOperationCall = call.isOperationCall();
            boolean bl = _not = !_isOperationCall;
            if (_not) {
                this.error(FUNCTIONS_CAN_NOT_BE_REFERENCED_MSG, (EObject)call, (EStructuralFeature)ExpressionsPackage.eINSTANCE.getFeatureCall_Feature(), FUNCTIONS_CAN_NOT_BE_REFERENCED_CODE, new String[0]);
            }
            boolean _and = false;
            Expression _owner = call.getOwner();
            boolean bl2 = _tripleNotEquals = _owner != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _isExtensionMethodOn;
                ITypeSystemInferrer.InferenceResult _infer = this.inferrer.infer((EObject)call.getOwner(), (IValidationIssueAcceptor)this);
                Type _type = null;
                if (_infer != null) {
                    _type = _infer.getType();
                }
                _and = _isExtensionMethodOn = this._extensionMethodHelper.isExtensionMethodOn((Operation)feature, _type);
            }
            if (_and) {
                this.assertOperationArguments((Operation)feature, this._extensionMethodHelper.combine(call.getOwner(), (List<Expression>)call.getExpressions()));
            } else {
                this.assertOperationArguments((Operation)feature, (List<Expression>)call.getExpressions());
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkMixedNamedParameters(ArgumentExpression it) {
        boolean _not;
        boolean bl = _not = !IterableExtensions.forall((Iterable)it.getArguments(), (Functions.Function1)new Functions.Function1<Argument, Boolean>(){

            public Boolean apply(Argument argument) {
                Parameter _parameter = argument.getParameter();
                return _parameter != null;
            }
        }) && !IterableExtensions.forall((Iterable)it.getArguments(), (Functions.Function1)new Functions.Function1<Argument, Boolean>(){

            public Boolean apply(Argument argument) {
                Parameter _parameter = argument.getParameter();
                return _parameter == null;
            }
        });
        if (_not) {
            this.error(MIXED_PARAMS_MSG, null, MIXED_PARAMS_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkNewInstanceExpression(NewInstanceExpression npe) {
        Type type;
        TypeSpecifier _type = npe.getType();
        Type _type_1 = null;
        if (_type != null) {
            _type_1 = _type.getType();
        }
        if (!((type = _type_1) instanceof GeneratedType)) {
            this.error("Can only instantiate generated types", (EObject)npe, (EStructuralFeature)ProgramPackage.eINSTANCE.getNewInstanceExpression_Type());
        }
    }

    public void assertOperationArguments(Operation op, List<Expression> args) {
        EList parameters = op.getParameters();
        if (args.size() < IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)parameters, (Functions.Function1)new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                boolean _isOptional = it.isOptional();
                return !_isOptional;
            }
        })) || args.size() > parameters.size()) {
            Functions.Function1<Parameter, Type> _function = new Functions.Function1<Parameter, Type>(){

                public Type apply(Parameter it) {
                    return it.getType();
                }
            };
            this.error(String.format(WRONG_NR_OF_ARGS_MSG, ListExtensions.map((List)parameters, (Functions.Function1)_function)), null, WRONG_NR_OF_ARGS_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkNoReturnValueForVoidOperation(FunctionDefinition op) {
        boolean _isSame = this.typeSystem.isSame(op.getType(), this.typeSystem.getType("void"));
        if (_isSame) {
            Functions.Function1<ReturnStatement, Boolean> _function = new Functions.Function1<ReturnStatement, Boolean>(){

                public Boolean apply(ReturnStatement x) {
                    Expression _value = x.getValue();
                    return _value != null;
                }
            };
            Consumer<ReturnStatement> _function_1 = new Consumer<ReturnStatement>(){

                @Override
                public void accept(ReturnStatement it) {
                    ProgramDslValidator.this.error(ProgramDslValidator.VOID_OP_CANNOT_RETURN_VALUE_MSG, it, null);
                }
            };
            IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)op.getBody(), ReturnStatement.class), (Functions.Function1)_function).forEach(_function_1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkNoModalityOrSiginstParameters(FunctionDefinition op) {
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                return Objects.equal((Object)it.getType().getName(), (Object)"modality") || Objects.equal((Object)it.getType().getName(), (Object)"siginst");
            }
        };
        Parameter hasModalityOrSiginstParam = (Parameter)IterableExtensions.findFirst((Iterable)op.getParameters(), (Functions.Function1)_function);
        if (hasModalityOrSiginstParam != null) {
            this.error(SIGINST_MODALITY_CANT_BE_FUNC_PARAM_MSG, (EObject)hasModalityOrSiginstParam, (EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE_SPECIFIER);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkNoReturnValueForEventHandler(EventHandlerDeclaration op) {
        Functions.Function1<ReturnStatement, Boolean> _function = new Functions.Function1<ReturnStatement, Boolean>(){

            public Boolean apply(ReturnStatement x) {
                Expression _value = x.getValue();
                return _value != null;
            }
        };
        Consumer<ReturnStatement> _function_1 = new Consumer<ReturnStatement>(){

            @Override
            public void accept(ReturnStatement it) {
                ProgramDslValidator.this.error(ProgramDslValidator.VOID_OP_CANNOT_RETURN_VALUE_MSG, it, null);
            }
        };
        IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)op.getBlock(), ReturnStatement.class), (Functions.Function1)_function).forEach(_function_1);
    }

    @Check(value=CheckType.NORMAL)
    public void checkReturnStatementsAreCompatibleToReturnType(FunctionDefinition op) {
        ITypeSystemInferrer.InferenceResult operationType = this.inferrer.infer((EObject)op, (IValidationIssueAcceptor)this);
        boolean _isSuperType = this.typeSystem.isSuperType(operationType.getType(), this.typeSystem.getType("void"));
        if (_isSuperType) {
            return;
        }
        boolean _isEmpty = op.getBody().getContent().isEmpty();
        if (_isEmpty) {
            this.error(String.format(MISSING_RETURN_VALUE_MSG, operationType), (EObject)op, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
            return;
        }
        List returnStatements = EcoreUtil2.getAllContentsOfType((EObject)op.getBody(), ReturnStatement.class);
        for (final ReturnStatement rs : returnStatements) {
            ITypeSystemInferrer.InferenceResult rsType = this.inferrer.infer(rs, (IValidationIssueAcceptor)this);
            if (rsType == null) {
                this.error(String.format(INCOMPATIBLE_RETURN_TYPE_MSG, "void", operationType), rs, (EStructuralFeature)ProgramPackage.eINSTANCE.getReturnStatement_Value());
                continue;
            }
            IValidationIssueAcceptor _function = new IValidationIssueAcceptor(){

                public void accept(IValidationIssueAcceptor.ValidationIssue issue) {
                    ProgramDslValidator.this.error(issue.getMessage(), rs, (EStructuralFeature)ProgramPackage.eINSTANCE.getReturnStatement_Value());
                }
            };
            this.validator.assertAssignable(operationType, rsType, String.format(INCOMPATIBLE_RETURN_TYPE_MSG, rsType, operationType), _function);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkFunctionReturnTypeIsPrimitive(FunctionDefinition op) {
        boolean _isPrimitiveType;
        boolean _not;
        TypeSpecifier operationType = ModelUtils.toSpecifier(this.inferrer.infer((EObject)op, (IValidationIssueAcceptor)this));
        boolean _or = false;
        boolean _and = false;
        boolean bl = _not = !(op instanceof GeneratedFunctionDefinition);
        if (!_not) {
            _and = false;
        } else {
            boolean _isSame;
            Type _type = null;
            if (operationType != null) {
                _type = operationType.getType();
            }
            _and = _isSame = this.typeSystem.isSame(_type, this.typeSystem.getType("void"));
        }
        _or = _and ? true : (_isPrimitiveType = ModelUtils.isPrimitiveType(operationType));
        if (_or) {
            return;
        }
        ElementSizeInferenceResult opSize = this.elementSizeInferrer.infer((EObject)op);
        if (!(opSize instanceof ValidElementSizeInferenceResult)) {
            this.error(SIZE_INFERENCE_FAILED_FOR_RETURN, (EObject)op, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
            return;
        }
        this.warning(FUNCTION_RETURN_TYPE_NOT_PRIMITIVE_MSG, (EObject)op, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
    }

    @Check(value=CheckType.NORMAL)
    public void checkIfCondition(IfStatement it) {
        this.assertIsBoolean(it.getCondition());
    }

    @Check(value=CheckType.NORMAL)
    public void checkWhileStatement(WhileStatement it) {
        this.assertIsBoolean(it.getCondition());
    }

    @Check(value=CheckType.NORMAL)
    public void checkDoWhileCondition(DoWhileStatement it) {
        this.assertIsBoolean(it.getCondition());
    }

    @Check(value=CheckType.NORMAL)
    public void checkVariableDeclaration(VariableDeclaration it) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferrer.infer(it);
        ITypeSystemInferrer.InferenceResult result2 = this.inferrer.infer((EObject)this.typeSystem.getType("void"));
        boolean _equals = result1.getType().equals(result2.getType());
        if (_equals) {
            this.error(VOID_VARIABLE_TYPE, it, null);
        }
    }

    protected void assertIsBoolean(final Expression exp) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferrer.infer((EObject)exp);
        ITypeSystemInferrer.InferenceResult result2 = this.inferrer.infer((EObject)this.typeSystem.getType("bool"));
        IValidationIssueAcceptor _function = new IValidationIssueAcceptor(){

            public void accept(IValidationIssueAcceptor.ValidationIssue issue) {
                ProgramDslValidator.this.error(issue.getMessage(), (EObject)exp, null);
            }
        };
        this.validator.assertCompatible(result1, result2, null, _function);
    }

    protected void assertIsInteger(final Expression exp, final String outerMessage) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferrer.infer((EObject)exp);
        ITypeSystemInferrer.InferenceResult result2 = this.inferrer.infer((EObject)this.typeSystem.getType("integer"));
        IValidationIssueAcceptor _function = new IValidationIssueAcceptor(){

            public void accept(IValidationIssueAcceptor.ValidationIssue issue) {
                String _elvis = null;
                _elvis = outerMessage != null ? outerMessage : "%s";
                ProgramDslValidator.this.error(String.format(_elvis, issue.getMessage()), (EObject)exp, null);
            }
        };
        this.validator.assertCompatible(result1, result2, null, _function);
    }

    @Check(value=CheckType.NORMAL)
    public void checkStructLiteralsHaveCorrectNumberOfArgumentsAndTheirTypesMatch(ElementReferenceExpression exp) {
        boolean _isOperationCall;
        EObject ref = exp.getReference();
        if (ref instanceof StructureType && (_isOperationCall = exp.isOperationCall())) {
            int _length_1;
            boolean _notEquals;
            int _length = ((Object[])Conversions.unwrapArray((Object)((StructureType)ref).getParameters(), Object.class)).length;
            boolean bl = _notEquals = _length != (_length_1 = ((Object[])Conversions.unwrapArray((Object)exp.getArguments(), Object.class)).length);
            if (_notEquals) {
                Functions.Function1<Parameter, Type> _function = new Functions.Function1<Parameter, Type>(){

                    public Type apply(Parameter it) {
                        return it.getType();
                    }
                };
                this.error(String.format(WRONG_NR_OF_ARGS_MSG, ListExtensions.map((List)((StructureType)ref).getParameters(), (Functions.Function1)_function).toString()), (EObject)exp, null);
                return;
            }
            TreeMap<Parameter, Argument> parmsToArgs = ModelUtils.getSortedArgumentsAsMap((Iterable<Parameter>)((StructureType)ref).getParameters(), (Iterable<Argument>)exp.getArguments());
            Consumer<Map.Entry<Parameter, Argument>> _function_1 = new Consumer<Map.Entry<Parameter, Argument>>(){

                @Override
                public void accept(Map.Entry<Parameter, Argument> parm_arg) {
                    Parameter sField = parm_arg.getKey();
                    final Expression sArg = parm_arg.getValue().getValue();
                    ITypeSystemInferrer.InferenceResult t1 = ProgramDslValidator.this.inferrer.infer((EObject)sField, (IValidationIssueAcceptor)ProgramDslValidator.this);
                    ITypeSystemInferrer.InferenceResult t2 = ProgramDslValidator.this.inferrer.infer((EObject)sArg, (IValidationIssueAcceptor)ProgramDslValidator.this);
                    IValidationIssueAcceptor _function = new IValidationIssueAcceptor(){

                        public void accept(IValidationIssueAcceptor.ValidationIssue issue) {
                            ProgramDslValidator.this.error(issue.getMessage(), (EObject)sArg, null);
                        }
                    };
                    ProgramDslValidator.this.validator.assertAssignable(t1, t2, String.format(ProgramDslValidator.INCOMPATIBLE_TYPES_MSG, t2, t1), _function);
                }
            };
            parmsToArgs.entrySet().forEach(_function_1);
        }
    }

    public void checkLeftHandAssignment(AssignmentExpression expression) {
        Expression varRef;
        Expression innerExpr = varRef = expression.getVarRef();
        boolean nested = true;
        while (nested) {
            if (innerExpr instanceof FeatureCall) {
                boolean _not;
                boolean _isOperationCall = ((FeatureCall)innerExpr).isOperationCall();
                boolean bl = _not = !_isOperationCall;
                if (_not) {
                    innerExpr = ((FeatureCall)innerExpr).getFeature();
                    continue;
                }
                nested = false;
                continue;
            }
            if (innerExpr instanceof ElementReferenceExpression) {
                innerExpr = ((ElementReferenceExpression)innerExpr).getReference();
                continue;
            }
            if (innerExpr instanceof DereferenceExpression) {
                innerExpr = ((DereferenceExpression)innerExpr).getInnerReference();
                continue;
            }
            if (innerExpr instanceof ArrayAccessExpression) {
                Expression _arraySelector = ((ArrayAccessExpression)innerExpr).getArraySelector();
                if (_arraySelector instanceof ValueRange) {
                    nested = false;
                    continue;
                }
                innerExpr = ((ArrayAccessExpression)innerExpr).getOwner();
                continue;
            }
            nested = false;
        }
        if (innerExpr instanceof VariableDeclaration || innerExpr instanceof FunctionParameterDeclaration || innerExpr instanceof Parameter || innerExpr instanceof Property) {
            return;
        }
        super.checkLeftHandAssignment(expression);
    }

    @Check(value=CheckType.FAST)
    public void checkOptionalParametersInFunctionDeclarations(FunctionParameterDeclaration parameter) {
        boolean _isOptional = parameter.isOptional();
        if (_isOptional) {
            this.error(OPTIONAL_PARAMETERS_NOT_IMPLEMENTED_MSG, (EObject)parameter, (EStructuralFeature)ProgramPackage.Literals.FUNCTION_PARAMETER_DECLARATION__VALUE, OPTIONAL_PARAMETERS_NOT_IMPLEMENTED_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void arrayLiteralsCantBeEmpty(ArrayLiteral lit) {
        boolean _isEmpty = lit.getValues().isEmpty();
        if (_isEmpty) {
            this.error(ARRAY_LITERALS_CANT_BE_EMPTY, (EObject)lit, null);
        } else {
            this.arrayLiteralsMustBeHomogenous(lit);
        }
    }

    public void arrayLiteralsMustBeHomogenous(ArrayLiteral lit) {
        boolean _greaterThan;
        Functions.Function1<TypeSpecifier, String> _function_1;
        Functions.Function1<Literal, TypeSpecifier> _function = new Functions.Function1<Literal, TypeSpecifier>(){

            public TypeSpecifier apply(Literal it) {
                return ModelUtils.toSpecifier(ProgramDslValidator.this.inferrer.infer((EObject)it, (IValidationIssueAcceptor)ProgramDslValidator.this));
            }
        };
        List typesInArray = ListExtensions.map(lit.getValues(), (Functions.Function1)_function);
        Map typesInArrayGrouped = IterableExtensions.groupBy((Iterable)typesInArray, (Functions.Function1)(_function_1 = new Functions.Function1<TypeSpecifier, String>(){

            public String apply(TypeSpecifier it) {
                return ModelUtils.typeSpecifierIdentifier(it);
            }
        }));
        int _size = typesInArrayGrouped.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            this.error(ARRAY_LITERAL_IS_NOT_HOMOGENOUS, (EObject)lit, null);
        } else {
            boolean _tripleEquals;
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)lit.eAllContents()), ArrayLiteral.class));
            boolean bl2 = _tripleEquals = Boolean.valueOf(_isEmpty) == Boolean.valueOf(false);
            if (_tripleEquals) {
                this.error(NESTED_ARRAY_LITERALS_NOT_SUPPORTED, (EObject)lit, null);
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkTypesAreNotNestedGeneratedTypes(VariableDeclaration declaration) {
        boolean _tripleNotEquals;
        SystemResourceSetup _containerOfType = (SystemResourceSetup)EcoreUtil2.getContainerOfType((EObject)declaration, SystemResourceSetup.class);
        boolean bl = _tripleNotEquals = _containerOfType != null;
        if (_tripleNotEquals) {
            return;
        }
        this.checkTypesAreNotNestedGeneratedTypes(declaration, this.inferrer.infer(declaration));
    }

    @Check(value=CheckType.NORMAL)
    public void checkTypesAreNotNestedGeneratedTypes(FunctionDefinition fd) {
        ITypeSystemInferrer.InferenceResult infType = this.inferrer.infer((EObject)fd);
        this.checkTypesAreNotNestedGeneratedTypes((EObject)fd, infType);
    }

    @Check(value=CheckType.NORMAL)
    public void checkTypesAreNotNestedGeneratedTypes(TypeSpecifier ts) {
        ITypeSystemInferrer.InferenceResult infType = this.inferrer.infer((EObject)ts);
        this.checkTypesAreNotNestedGeneratedTypes((EObject)ts, infType);
    }

    protected void checkTypesAreNotNestedGeneratedTypes(EObject obj, ITypeSystemInferrer.InferenceResult ir) {
        this.checkTypesAreNotNestedGeneratedTypes(obj, ir, false, false);
    }

    protected void checkTypesAreNotNestedGeneratedTypes(final EObject obj, ITypeSystemInferrer.InferenceResult ir, Boolean hasGeneratedType, Boolean containsReferenceTypes) {
        if (ir == null) {
            return;
        }
        Boolean hasGeneratedTypeNext = hasGeneratedType;
        Boolean containsReferenceTypesNext = containsReferenceTypes;
        Type type = ir.getType();
        List _xifexpression = null;
        if (type instanceof GeneratedType) {
            List _xblockexpression = null;
            String _name = ((GeneratedType)type).getName();
            boolean _equals = Objects.equal((Object)_name, (Object)"reference");
            if (_equals) {
                if (hasGeneratedTypeNext.booleanValue()) {
                    this.error(NESTED_GENERATED_TYPES_ARE_NOT_SUPPORTED, obj, null);
                    return;
                }
                containsReferenceTypesNext = true;
            } else {
                if (hasGeneratedTypeNext.booleanValue() || containsReferenceTypesNext.booleanValue()) {
                    this.error(NESTED_GENERATED_TYPES_ARE_NOT_SUPPORTED, obj, null);
                    return;
                }
                hasGeneratedTypeNext = true;
            }
            _xblockexpression = ir.getBindings();
            _xifexpression = _xblockexpression;
        } else {
            ArrayList _xifexpression_1 = null;
            if (type instanceof ComplexType) {
                List _xifexpression_2 = null;
                if (type instanceof StructureType) {
                    Functions.Function1<Parameter, ITypeSystemInferrer.InferenceResult> _function = new Functions.Function1<Parameter, ITypeSystemInferrer.InferenceResult>(){

                        public ITypeSystemInferrer.InferenceResult apply(Parameter it) {
                            return ProgramDslValidator.this.inferrer.infer((EObject)it.getTypeSpecifier());
                        }
                    };
                    _xifexpression_2 = ListExtensions.map((List)((StructureType)type).getParameters(), (Functions.Function1)_function);
                } else {
                    Iterable _xifexpression_3 = null;
                    if (type instanceof SumType) {
                        Functions.Function1<SumAlternative, List<ITypeSystemInferrer.InferenceResult>> _function_1 = new Functions.Function1<SumAlternative, List<ITypeSystemInferrer.InferenceResult>>(){

                            public List<ITypeSystemInferrer.InferenceResult> apply(SumAlternative alt) {
                                List _xifexpression = null;
                                if (alt instanceof NamedProductType) {
                                    Functions.Function1<Parameter, ITypeSystemInferrer.InferenceResult> _function = new Functions.Function1<Parameter, ITypeSystemInferrer.InferenceResult>(){

                                        public ITypeSystemInferrer.InferenceResult apply(Parameter it) {
                                            return ProgramDslValidator.this.inferrer.infer((EObject)it.getTypeSpecifier());
                                        }
                                    };
                                    _xifexpression = ListExtensions.map((List)((NamedProductType)alt).getParameters(), (Functions.Function1)_function);
                                } else {
                                    List _xifexpression_1 = null;
                                    if (alt instanceof AnonymousProductType) {
                                        Functions.Function1<TypeSpecifier, ITypeSystemInferrer.InferenceResult> _function_1 = new Functions.Function1<TypeSpecifier, ITypeSystemInferrer.InferenceResult>(){

                                            public ITypeSystemInferrer.InferenceResult apply(TypeSpecifier it) {
                                                return ProgramDslValidator.this.inferrer.infer((EObject)it);
                                            }
                                        };
                                        _xifexpression_1 = ListExtensions.map((List)((AnonymousProductType)alt).getTypeSpecifiers(), (Functions.Function1)_function_1);
                                    } else {
                                        _xifexpression_1 = Collections.unmodifiableList(CollectionLiterals.newArrayList());
                                    }
                                    _xifexpression = _xifexpression_1;
                                }
                                return _xifexpression;
                            }
                        };
                        _xifexpression_3 = IterableExtensions.flatMap((Iterable)((SumType)type).getAlternatives(), (Functions.Function1)_function_1);
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            } else {
                _xifexpression_1 = CollectionLiterals.newArrayList();
            }
            _xifexpression = _xifexpression_1;
        }
        ArrayList subTypes = _xifexpression;
        if (subTypes == null) {
            return;
        }
        final Boolean hasGeneratedTypeNextFinal = hasGeneratedTypeNext;
        final Boolean containsReferenceTypesNextFinal = containsReferenceTypesNext;
        Consumer<ITypeSystemInferrer.InferenceResult> _function_2 = new Consumer<ITypeSystemInferrer.InferenceResult>(){

            @Override
            public void accept(final ITypeSystemInferrer.InferenceResult it) {
                Functions.Function0<Object> _function = new Functions.Function0<Object>(){

                    public Object apply() {
                        ProgramDslValidator.this.checkTypesAreNotNestedGeneratedTypes(obj, it, hasGeneratedTypeNextFinal, containsReferenceTypesNextFinal);
                        return null;
                    }
                };
                ModelUtils.preventRecursion((EObject)it.getType(), _function);
            }
        };
        IterableExtensions.filterNull((Iterable)subTypes).forEach(_function_2);
    }

    @Check(value=CheckType.FAST)
    public void arrayLiteralsCantBeUsedInGlobalScope(ValueRange lit) {
        Object _elvis = null;
        FunctionDefinition _containerOfType = (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)lit, FunctionDefinition.class);
        if (_containerOfType != null) {
            _elvis = _containerOfType;
        } else {
            EventHandlerDeclaration _containerOfType_1 = (EventHandlerDeclaration)EcoreUtil2.getContainerOfType((EObject)lit, EventHandlerDeclaration.class);
            _elvis = _containerOfType_1;
        }
        FunctionDefinition fun = _elvis;
        if (fun == null) {
            this.error(ARRAY_SLICES_ARE_NOT_SUPPORTED_TOP_LEVEL, (EObject)lit, null);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void arrayElementAccessIndexCheck(ArrayAccessExpression expr) {
        boolean isInferred;
        Expression _arraySelector_1;
        boolean _not;
        Expression item = expr.getOwner();
        ElementSizeInferenceResult sizeInfRes = this.elementSizeInferrer.infer((EObject)item);
        Expression _arraySelector = expr.getArraySelector();
        boolean bl = _not = !(_arraySelector instanceof ValueRange);
        if (_not && (_arraySelector_1 = expr.getArraySelector()) != null) {
            this.assertIsInteger(_arraySelector_1, ARRAY_INDEX_MUST_BE_INTEGER);
        }
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject x) {
            }
        };
        Object staticVal = StaticValueInferrer.infer((EObject)expr.getArraySelector(), (Procedures.Procedure1<? super EObject>)_function);
        boolean bl2 = isInferred = sizeInfRes instanceof ValidElementSizeInferenceResult && staticVal instanceof Integer;
        if (isInferred) {
            Integer idx = (Integer)staticVal;
            int len = ((ValidElementSizeInferenceResult)sizeInfRes).getElementCount();
            if (idx < 0 || len <= idx) {
                this.error(String.format(ARRAY_INDEX_OUT_OF_BOUNDS, len), (EObject)expr, (EStructuralFeature)ProgramPackage.Literals.ARRAY_ACCESS_EXPRESSION__ARRAY_SELECTOR);
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void arrayRangeChecks(final ValueRange range) {
        ElementSizeInferenceResult size;
        boolean _isValid;
        Expression _upperBound;
        Expression _lowerBound;
        boolean _notEquals;
        Procedures.Procedure1<String> _function_1;
        Procedures.Procedure1<String> _function;
        Procedures.Procedure1<String> errorFun1 = _function = new Procedures.Procedure1<String>(){

            public void apply(String s) {
                ProgramDslValidator.this.error(s, (EObject)range, null);
            }
        };
        Procedures.Procedure1<String> errorFun2 = _function_1 = new Procedures.Procedure1<String>(){

            public void apply(String s) {
                ProgramDslValidator.this.error(String.format(ProgramDslValidator.ARRAY_RANGE_INVALID, s), (EObject)range, null);
            }
        };
        EObject _eContainer = range.eContainer();
        Expression expr = ((ArrayAccessExpression)_eContainer).getOwner();
        ITypeSystemInferrer.InferenceResult typ = this.inferrer.infer((EObject)expr, (IValidationIssueAcceptor)this);
        String _name = typ.getType().getName();
        boolean bl = _notEquals = !Objects.equal((Object)_name, (Object)"array");
        if (_notEquals) {
            errorFun1.apply((Object)ARRAY_RANGE_ONLY_ON_ARRAY);
        }
        if ((_lowerBound = range.getLowerBound()) != null) {
            this.assertIsInteger(_lowerBound, ARRAY_RANGE_INVALID);
        }
        if ((_upperBound = range.getUpperBound()) != null) {
            this.assertIsInteger(_upperBound, ARRAY_RANGE_INVALID);
        }
        ElementSizeInferenceResult lengthOfArrayIR = this.elementSizeInferrer.infer((EObject)expr);
        int _xifexpression = 0;
        if (lengthOfArrayIR instanceof ValidElementSizeInferenceResult) {
            _xifexpression = ((ValidElementSizeInferenceResult)lengthOfArrayIR).getElementCount();
        }
        int lengthOfArray = _xifexpression;
        Object _elvis = null;
        Procedures.Procedure1<EObject> _function_2 = new Procedures.Procedure1<EObject>(){

            public void apply(EObject x) {
            }
        };
        Object _infer = StaticValueInferrer.infer((EObject)range.getLowerBound(), (Procedures.Procedure1<? super EObject>)_function_2);
        _elvis = _infer != null ? _infer : Integer.valueOf(0);
        Object lowerBound = _elvis;
        Object _elvis_1 = null;
        Procedures.Procedure1<EObject> _function_3 = new Procedures.Procedure1<EObject>(){

            public void apply(EObject x) {
            }
        };
        Object _infer_1 = StaticValueInferrer.infer((EObject)range.getUpperBound(), (Procedures.Procedure1<? super EObject>)_function_3);
        _elvis_1 = _infer_1 != null ? _infer_1 : Integer.valueOf(lengthOfArray);
        Object upperBound = _elvis_1;
        if ((Integer)lowerBound < 0) {
            errorFun2.apply((Object)"Lower bound must be positive or zero");
        }
        if (upperBound != null && (_isValid = (size = this.elementSizeInferrer.infer((EObject)expr)).isValid())) {
            boolean _greaterThan;
            int _elementCount = ((ValidElementSizeInferenceResult)size).getElementCount();
            boolean bl2 = _greaterThan = (Integer)upperBound > _elementCount;
            if (_greaterThan) {
                errorFun2.apply((Object)String.format("Upper bound must be less than or equal to array size (%s)", ((ValidElementSizeInferenceResult)size).getElementCount()));
            } else if ((Integer)upperBound <= 0) {
                errorFun2.apply((Object)"Upper bound must be strictly positive");
            }
        }
        if (lowerBound != null && upperBound != null) {
            boolean _greaterEqualsThan;
            boolean bl3 = _greaterEqualsThan = ((Integer)lowerBound).compareTo((Integer)upperBound) >= 0;
            if (_greaterEqualsThan) {
                errorFun2.apply((Object)"Lower bound must be smaller than upper bound");
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void noUpcastingToOptionalsInFunctionArguments(ElementReferenceExpression eref) {
        Iterable<Pair<TypeSpecifier, Argument>> typesAndArgs = ModelUtils.getFunctionCallArguments((EObject)eref);
        if (typesAndArgs == null) {
            return;
        }
        Consumer<Pair<TypeSpecifier, Argument>> _function = new Consumer<Pair<TypeSpecifier, Argument>>(){

            @Override
            public void accept(Pair<TypeSpecifier, Argument> ts_arg) {
                TypeSpecifier ts = (TypeSpecifier)ts_arg.getKey();
                if (ts.getType() instanceof GeneratedType && Objects.equal((Object)ts.getType().getName(), (Object)"optional")) {
                    Argument arg = (Argument)ts_arg.getValue();
                    TypeSpecifier argType = ModelUtils.toSpecifier(ProgramDslValidator.this.inferrer.infer((EObject)arg.getValue()));
                    Functions.Function2<Type, Type, Boolean> _function = new Functions.Function2<Type, Type, Boolean>(){

                        public Boolean apply(Type t1, Type t2) {
                            return ProgramDslValidator.this.typeSystem.haveCommonType(t1, t2);
                        }
                    };
                    boolean _typeSpecifierEqualsWith = ModelUtils.typeSpecifierEqualsWith((Functions.Function2<? super Type, ? super Type, ? extends Boolean>)_function, (TypeSpecifier)IterableExtensions.head((Iterable)ts.getTypeArguments()), argType);
                    if (_typeSpecifierEqualsWith) {
                        ProgramDslValidator.this.error(String.format(ProgramDslValidator.IMPLICIT_TO_OPTIONAL_IS_NOT_SUPPORTED, "function calls"), (EObject)arg, null);
                    }
                }
            }
        };
        typesAndArgs.forEach(_function);
    }

    @Check(value=CheckType.NORMAL)
    public void noUpcastingToOptionalsInReturns(ReturnStatement stmt) {
        FunctionDefinition funDef = (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)stmt, FunctionDefinition.class);
        if (funDef == null) {
            return;
        }
        ITypeSystemInferrer.InferenceResult retType = this.inferrer.infer((EObject)funDef);
        if (retType.getType() instanceof GeneratedType && Objects.equal((Object)retType.getType().getName(), (Object)"optional")) {
            ITypeSystemInferrer.InferenceResult returnedValueType = this.inferrer.infer((EObject)stmt.getValue());
            Expression _value = stmt.getValue();
            if (_value instanceof PrimitiveValueExpression) {
                this.error(String.format(IMPLICIT_TO_OPTIONAL_IS_NOT_SUPPORTED, "returns"), stmt, null);
            }
        }
    }
}

