/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.validation;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mita.base.types.ImportStatement;
import org.eclipse.mita.base.types.PackageAssociation;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.library.extension.LibraryExtensions;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.model.ImportHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ProgramImportValidator
extends AbstractDeclarativeValidator {
    @Inject
    @Extension
    private ImportHelper _importHelper;
    public static final String MISSING_TARGET_PLATFORM_MSG = "Missing target platform import.";
    public static final String MISSING_TARGET_PLATFORM_CODE = "MissingPlatform";

    @Check(value=CheckType.NORMAL)
    public void checkPackageImportsAreUnique(Program program) {
        HashSet<String> pkgsSeen = new HashSet<String>();
        EList<ImportStatement> _imports = program.getImports();
        for (ImportStatement i : _imports) {
            String pkgName = i.getImportedNamespace();
            if (pkgName != null && pkgsSeen.contains(pkgName)) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Re-importing the \"");
                _builder.append(pkgName);
                _builder.append("\" package.");
                this.error(_builder.toString(), (EObject)i, (EStructuralFeature)TypesPackage.eINSTANCE.getImportStatement_ImportedNamespace());
            }
            pkgsSeen.add(pkgName);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkPackageImportExists(Program program) {
        final List<String> availablePackages = this._importHelper.getVisiblePackages(program.eResource());
        Consumer<ImportStatement> _function = new Consumer<ImportStatement>(){

            @Override
            public void accept(ImportStatement it) {
                boolean _not;
                boolean _contains = availablePackages.contains(it.getImportedNamespace());
                boolean bl = _not = !_contains;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Package '");
                    String _importedNamespace = it.getImportedNamespace();
                    _builder.append(_importedNamespace);
                    _builder.append("' does not exist.");
                    ProgramImportValidator.this.error(_builder.toString(), (EObject)it, (EStructuralFeature)TypesPackage.eINSTANCE.getImportStatement_ImportedNamespace());
                }
            }
        };
        program.getImports().forEach((Consumer)_function);
    }

    @Check(value=CheckType.NORMAL)
    public void checkPlatformImportIsPresent(Program program) {
        boolean needsPlatformImport;
        Functions.Function1<LibraryExtensions.LibraryDescriptor, String> _function = new Functions.Function1<LibraryExtensions.LibraryDescriptor, String>(){

            public String apply(LibraryExtensions.LibraryDescriptor it) {
                return it.getId();
            }
        };
        final Set availablePackages = IterableExtensions.toSet((Iterable)ListExtensions.map((List)LibraryExtensions.getAvailablePlatforms(), (Functions.Function1)_function));
        Functions.Function1<ImportStatement, Boolean> _function_1 = new Functions.Function1<ImportStatement, Boolean>(){

            public Boolean apply(ImportStatement it) {
                return availablePackages.contains(it.getImportedNamespace());
            }
        };
        Iterable importedPlatforms = IterableExtensions.filter(program.getImports(), (Functions.Function1)_function_1);
        boolean _startsWith = program.getName().startsWith("stdlib");
        boolean bl = needsPlatformImport = !_startsWith;
        if (needsPlatformImport && IterableExtensions.isNullOrEmpty((Iterable)importedPlatforms)) {
            this.error(MISSING_TARGET_PLATFORM_MSG, (EObject)program, (EStructuralFeature)TypesPackage.Literals.PACKAGE_ASSOCIATION__NAME, MISSING_TARGET_PLATFORM_CODE, new String[0]);
        } else {
            boolean _greaterThan;
            int _size = IterableExtensions.size((Iterable)importedPlatforms);
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Only one target platform must be imported.");
                this.error(_builder.toString(), (EObject)program, (EStructuralFeature)TypesPackage.Literals.PACKAGE_ASSOCIATION__NAME);
            }
        }
    }

    public void checkForUnsuedImports(Program program) {
        Set imports = IterableExtensions.toSet(program.getImports());
        Functions.Function1<EObject, PackageAssociation> _function = new Functions.Function1<EObject, PackageAssociation>(){

            public PackageAssociation apply(EObject it) {
                return (PackageAssociation)EcoreUtil2.getContainerOfType((EObject)it, PackageAssociation.class);
            }
        };
        Set requiredImports = IterableExtensions.toSet((Iterable)IterableExtensions.map(EcoreUtil.CrossReferencer.find(Collections.singletonList(program)).keySet(), (Functions.Function1)_function));
        Functions.Function1<PackageAssociation, String> _function_1 = new Functions.Function1<PackageAssociation, String>(){

            public String apply(PackageAssociation it) {
                return it.getName();
            }
        };
        final Set requiredImportNames = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)requiredImports, (Functions.Function1)_function_1));
        Consumer<ImportStatement> _function_2 = new Consumer<ImportStatement>(){

            @Override
            public void accept(ImportStatement it) {
                boolean _not;
                boolean _contains = requiredImportNames.contains(it.getImportedNamespace());
                boolean bl = _not = !_contains;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("The import ");
                    String _importedNamespace = it.getImportedNamespace();
                    _builder.append(_importedNamespace);
                    _builder.append("' is never used.");
                    ProgramImportValidator.this.warning(_builder.toString(), (EObject)it, (EStructuralFeature)TypesPackage.eINSTANCE.getImportStatement_ImportedNamespace());
                }
            }
        };
        imports.forEach(_function_2);
    }

    @Inject
    public void register(EValidatorRegistrar registrar) {
    }
}

