/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.RecordingDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextileLanguageDefinitionListTest {
    private MarkupParser parser;
    private TextileLanguage markupLanguage;

    @Before
    public void initParser() throws IOException {
        this.parser = new MarkupParser();
        this.markupLanguage = new TextileLanguage();
        this.parser.setMarkupLanguage((MarkupLanguage)this.markupLanguage);
    }

    private String parseToHtml(String markup) {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setEmitAsDocument(false);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse(markup);
        return out.toString();
    }

    @Test
    public void simple() {
        String html = this.parseToHtml("- one := two");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two</dd></dl>", (Object)html);
    }

    @Test
    public void withSpans() {
        String html = this.parseToHtml("- one := *two* and _three_ %{color:red;}laskdf as d%");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd><strong>two</strong> and <em>three</em> <span style=\"color:red;\">laskdf as d</span></dd></dl>", (Object)html);
    }

    @Test
    public void multipleItems() {
        String html = this.parseToHtml("- one := two\n- three := four");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two</dd><dt>three</dt><dd>four</dd></dl>", (Object)html);
    }

    @Test
    public void terminatedSameLine() {
        String html = this.parseToHtml("- one := two three =:");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two three</dd></dl>", (Object)html);
    }

    @Test
    public void terminatedSameLineParaStartNoBlankLine() {
        String html = this.parseToHtml("- one := two three =:\npara start");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two three</dd></dl><p>para start</p>", (Object)html);
    }

    @Test
    public void terminatedMultiLineNoTermination() {
        String html = this.parseToHtml("- one := two three\n\tfour\nfive six");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two three<br/>\tfour<br/>five six</dd></dl>", (Object)html);
    }

    @Test
    public void terminatedMultiLineImproperTermination() {
        String html = this.parseToHtml("- one := two three\n\nfour");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two three</dd></dl><p>four</p>", (Object)html);
    }

    @Test
    public void terminatedMultiLine() {
        String html = this.parseToHtml("- one := two three\n\tfour\nfive six =:");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two three<br/>\tfour<br/>five six</dd></dl>", (Object)html);
    }

    @Test
    public void multiLineNotTerminatedWithBulletedList() {
        String html = this.parseToHtml("- one := two three\n* one =:");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two three<br/>* one</dd></dl>", (Object)html);
    }

    @Test
    public void terminatedMultiLineTerminatorLineEmpty() {
        String html = this.parseToHtml("- one := two three\n\tfour\n   =:\ntest");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two three<br/>\tfour</dd></dl><p>test</p>", (Object)html);
    }

    @Test
    public void terminatedMultiLineTerminatorLineEmpty2() {
        String html = this.parseToHtml("- one := two three\n\tfour\n=:\ntest");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two three<br/>\tfour</dd></dl><p>test</p>", (Object)html);
    }

    @Test
    public void semicolon() {
        String html = this.parseToHtml("; one");
        Assert.assertEquals((Object)"<dl><dt>one</dt></dl>", (Object)html);
    }

    @Test
    public void semicolonWithDefinition() {
        String html = this.parseToHtml("; one\n: two");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two</dd></dl>", (Object)html);
    }

    @Test
    public void semicolonWithMultipleDefinitions() {
        String html = this.parseToHtml("; one\n: two\n: three four");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two</dd><dd>three four</dd></dl>", (Object)html);
    }

    @Test
    public void semicolonWithMultipleItemsAndDefinitions() {
        String html = this.parseToHtml("; one\n: two\n: three four\n; five\n: six");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd>two</dd><dd>three four</dd><dt>five</dt><dd>six</dd></dl>", (Object)html);
    }

    @Test
    public void semicolonWithDefinitionAndSpans() {
        String html = this.parseToHtml("; one\n: *two* _three_ -four five-");
        Assert.assertEquals((Object)"<dl><dt>one</dt><dd><strong>two</strong> <em>three</em> <del>four five</del></dd></dl>", (Object)html);
    }

    @Test
    public void definitionListInterruptsParagraph() {
        String html = this.parseToHtml("one\n- two := three four");
        Assert.assertEquals((Object)"<p>one</p><dl><dt>two</dt><dd>three four</dd></dl>", (Object)html);
    }

    @Test
    public void offsets() {
        RecordingDocumentBuilder builder = new RecordingDocumentBuilder();
        MarkupParser markupParser = new MarkupParser((MarkupLanguage)this.markupLanguage);
        markupParser.setBuilder((DocumentBuilder)builder);
        markupParser.parse("- one := two");
        RecordingDocumentBuilder.Event event = this.findEvent(builder.getEvents(), DocumentBuilder.BlockType.DEFINITION_TERM);
        Assert.assertEquals((long)1L, (long)event.locator.getLineNumber());
        Assert.assertEquals((long)0L, (long)event.locator.getLineCharacterOffset());
        Assert.assertEquals((long)6L, (long)event.locator.getLineSegmentEndOffset());
        RecordingDocumentBuilder.Event itemEvent = this.findEvent(builder.getEvents(), DocumentBuilder.BlockType.DEFINITION_ITEM);
        Assert.assertEquals((long)1L, (long)itemEvent.locator.getLineNumber());
        Assert.assertEquals((long)6L, (long)itemEvent.locator.getLineCharacterOffset());
    }

    private RecordingDocumentBuilder.Event findEvent(List<RecordingDocumentBuilder.Event> events, DocumentBuilder.BlockType blockType) {
        for (RecordingDocumentBuilder.Event event : events) {
            if (event.blockType != blockType) continue;
            return event;
        }
        Assert.fail((String)String.format("Expected block %s but found %s", blockType, events));
        throw new IllegalStateException();
    }
}

