/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki.core;

import java.io.IOException;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.tracwiki.core.TracWikiLanguage;

public class TracWikiLanguageTest
extends TestCase {
    private MarkupParser parser;
    private TracWikiLanguage markupLanguage;

    public void setUp() {
        this.markupLanguage = new TracWikiLanguage();
        this.parser = new MarkupParser((MarkupLanguage)this.markupLanguage);
    }

    public void testIsDetectingRawHyperlinks() {
        TracWikiLanguageTest.assertTrue((boolean)this.parser.getMarkupLanguage().isDetectingRawHyperlinks());
    }

    public void testMacroNotRecognised() throws IOException {
        String html = this.parser.parseToHtml("there is [[NoSuchMacro]] a macro [[NoSuchMacro()]] in the [[NoSuchMacro(params, go=here)]] page");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>there is  a macro  in the  page</p></body>").matcher(html).find());
    }

    public void testImageMacroIncorrectParams() throws IOException {
        String html = this.parser.parseToHtml("there is a macro [[Image]] in the [[Image()]] page");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>there is a macro  in the  page</p></body>").matcher(html).find());
    }

    public void testImageMacroBasic() throws IOException {
        String html = this.parser.parseToHtml("there is a macro [[Image(local_attachment.png)]] in the [[Image(http://www.example.com/external.png)]] page");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>there is a macro <img border=\"0\" src=\"local_attachment.png\"/> in the <img border=\"0\" src=\"http://www.example.com/external.png\"/> page</p></body>").matcher(html).find());
    }

    public void testImageMacroOptions() throws IOException {
        String html = this.parser.parseToHtml("there is a macro [[Image(local_attachment.png, alt=Alt Text, title=Title Text, border=5)]] in the page");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>there is a macro <img alt=\"Alt Text\" title=\"Title Text\" border=\"5\" src=\"local_attachment.png\"/> in the page</p></body>").matcher(html).find());
    }

    public void testImageMacroSizes() throws IOException {
        String html = this.parser.parseToHtml("there is a macro [[Image(local_attachment.png, 100px, height=10%)]] in the page");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>there is a macro <img height=\"10%\" width=\"100\" border=\"0\" src=\"local_attachment.png\"/> in the page</p></body>").matcher(html).find());
    }

    public void testImageMacroFloatAlign() throws IOException {
        String html = this.parser.parseToHtml("there is a macro [[Image(local_attachment.png, right)]] in the [[Image(local_attachment.png, align=left)]] page");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>there is a macro <img style=\"float:right;\" border=\"0\" src=\"local_attachment.png\"/> in the <img style=\"float:left;\" border=\"0\" src=\"local_attachment.png\"/> page</p></body>").matcher(html).find());
    }

    public void testImageMacroInvalidOptions() throws IOException {
        String html = this.parser.parseToHtml("there is a macro [[Image(local_attachment.png, beans, align=beans, border=b, width=10ee)]] in the page");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>there is a macro <img border=\"0\" src=\"local_attachment.png\"/> in the page</p></body>").matcher(html).find());
    }

    public void testParagraphs() throws IOException {
        String html = this.parser.parseToHtml("first para\nnew line\n\nsecond para\n\n\n\n");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>first para\\s*new line</p><p>second para</p></body>", 8).matcher(html).find());
    }

    public void testBoldItalic() {
        String html = this.parser.parseToHtml("normal '''''bold italic text''''' normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <b><i>bold italic text</i></b> normal</p></body>").matcher(html).find());
    }

    public void testBold() {
        String html = this.parser.parseToHtml("normal '''bold text''' normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <b>bold text</b> normal</p></body>").matcher(html).find());
    }

    public void testBoldEscaped() {
        String html = this.parser.parseToHtml("normal '''!'''bold text''' normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <b>'''bold text</b> normal</p></body>").matcher(html).find());
    }

    public void testItalic() {
        String html = this.parser.parseToHtml("normal ''italic text'' normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <i>italic text</i> normal</p></body>").matcher(html).find());
    }

    public void testItalic2() {
        String html = this.parser.parseToHtml("normal ''italic''-''italic'' normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal <i>italic</i>-<i>italic</i> normal</p></body>"));
    }

    public void testDeleted() {
        String html = this.parser.parseToHtml("normal ~~test text~~ normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <del>test text</del> normal</p></body>").matcher(html).find());
    }

    public void testDeleted2() {
        String html = this.parser.parseToHtml("normal ~~~test text~~ normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <del>~test text</del> normal</p></body>").matcher(html).find());
    }

    public void testDeleted3() {
        String html = this.parser.parseToHtml("normal ~~test text~~~ normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <del>test text</del>~ normal</p></body>").matcher(html).find());
    }

    public void testDeleted_AtStartOfLine() {
        String html = this.parser.parseToHtml("~~test text~~ normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p><del>test text</del> normal</p></body>"));
    }

    public void testDeleted_AtEndOfLine() {
        String html = this.parser.parseToHtml("normal ~~test text~~");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>normal <del>test text</del></p></body>"));
    }

    public void testUnderlined() {
        String html = this.parser.parseToHtml("normal __test text__ normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <u>test text</u> normal</p></body>").matcher(html).find());
    }

    public void testSuperscript() {
        String html = this.parser.parseToHtml("normal ^test text^ normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <sup>test text</sup> normal</p></body>").matcher(html).find());
    }

    public void testSubscript() {
        String html = this.parser.parseToHtml("normal ,,test text,, normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <sub>test text</sub> normal</p></body>").matcher(html).find());
    }

    public void testEscapedWithBacktick() {
        String html = this.parser.parseToHtml("normal `test text` normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <tt>test text</tt> normal</p></body>").matcher(html).find());
    }

    public void testEscapedWithCurlys() {
        String html = this.parser.parseToHtml("normal {{test text}} normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal <tt>test text</tt> normal</p></body>").matcher(html).find());
    }

    public void testHeadings() {
        int x = 1;
        while (x <= 6) {
            String delimiter = this.repeat(x, "=");
            String html = this.parser.parseToHtml(String.valueOf(delimiter) + "heading text" + delimiter + "\nfirst para\nfirst para line2\n\nsecond para\n\nthird para");
            TestUtil.println(html);
            TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><h" + x + " id=\"headingtext\">heading text</h" + x + "><p>first para\\s*first para line2</p><p>second para</p><p>third para</p></body>", 8).matcher(html).find());
            html = this.parser.parseToHtml(String.valueOf(delimiter) + "heading text" + delimiter + " #with-id-" + x + "\nfirst para\nfirst para line2\n\nsecond para\n\nthird para");
            TestUtil.println(html);
            TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><h" + x + " id=\"with-id-" + x + "\">heading text</h" + x + "><p>first para\\s*first para line2</p><p>second para</p><p>third para</p></body>", 8).matcher(html).find());
            html = this.parser.parseToHtml(String.valueOf(delimiter) + "heading text" + delimiter + "    \n" + "first para\nfirst para line2\n\nsecond para\n\nthird para");
            TestUtil.println(html);
            TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><h" + x + " id=\"headingtext\">heading text</h" + x + "><p>first para\\s*first para line2</p><p>second para</p><p>third para</p></body>", 8).matcher(html).find());
            ++x;
        }
    }

    public void testHeadingBreakingPara() {
        String html = this.parser.parseToHtml("=\n== heading ==\npara");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>=</p><h2 id=\"heading\">heading</h2><p>para</p></body>"));
    }

    private String repeat(int i, String string) {
        StringBuilder buf = new StringBuilder(string.length() * i);
        int x = 0;
        while (x < i) {
            buf.append(string);
            ++x;
        }
        return buf.toString();
    }

    public void testLineBreak() {
        String html = this.parser.parseToHtml("normal text[[BR]]normal");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal text<br/>\\s*normal</p></body>").matcher(html).find());
    }

    public void testListUnordered() throws IOException {
        String html = this.parser.parseToHtml(" * a list\n * with two lines");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ul><li>a list</li><li>with two lines</li></ul></body>"));
    }

    public void testListUnorderedWithoutSpacePrefix() throws Exception {
        String html = this.parser.parseToHtml("* a list\n* with two lines");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ul><li>a list</li><li>with two lines</li></ul></body>"));
    }

    public void testListUnorderedBigSpacePrefix() throws Exception {
        String html = this.parser.parseToHtml("   * a list\n   * with two lines");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ul><li>a list</li><li>with two lines</li></ul></body>"));
    }

    public void testListUnorderedWithHyphens() throws IOException {
        String html = this.parser.parseToHtml(" - a list\n - with two lines");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ul><li>a list</li><li>with two lines</li></ul></body>"));
    }

    public void testListOrdered() throws IOException {
        String html = this.parser.parseToHtml(" 1. a list\n 2. with two lines");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<ol>"));
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<li>a list</li>"));
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<li>with two lines</li>"));
        TracWikiLanguageTest.assertTrue((boolean)html.contains("</ol>"));
    }

    public void testListOrderedWithoutSpacePrefix() throws Exception {
        String html = this.parser.parseToHtml("1. a list\n1. with two lines");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ol><li>a list</li><li>with two lines</li></ol></body>"));
    }

    public void testListOrderedStartAt2() throws IOException {
        String html = this.parser.parseToHtml(" 2. with two lines\n 3. three");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ol start=\"2\"><li>with two lines</li><li>three</li></ol></body>"));
    }

    public void testListOrderedBug265015() throws IOException {
        String html = this.parser.parseToHtml(" 1. first\n\n 2. second");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ol><li>first</li></ol><ol start=\"2\"><li>second</li></ol></body>"));
    }

    public void testListNested() throws IOException {
        String html = this.parser.parseToHtml(" 1. a list\n  1. nested\n  1. nested2\n 1. level1\n\npara");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<ol>"));
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<li>a list"));
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<li>nested"));
        TracWikiLanguageTest.assertTrue((boolean)html.contains("</ol>"));
    }

    public void testListNestedUnordered() throws Exception {
        String html = this.parser.parseToHtml("* Apples\n  * Sauce\n  * Juice\n* Oranges\n* Grapes");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<ul><li>Apples<ul><li>Sauce</li><li>Juice</li></ul></li><li>Oranges</li><li>Grapes</li></ul>"));
    }

    public void testListNestedMixed() throws IOException {
        String html = this.parser.parseToHtml(" 1. a list\n  * nested\n  * nested2\n 1. level1\n\npara");
        TestUtil.println("HTML: \n" + html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<ol><li>a list<ul><li>nested</li><li>nested2</li></ul></li><li>level1</li></ol>"));
    }

    public void testListNumericWithBulleted() {
        String html = this.parser.parseToHtml("   1. one\n   * two");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ol><li>one</li></ol><ul><li>two</li></ul></body>"));
    }

    public void testListMultipleLines() throws Exception {
        String html = this.parser.parseToHtml(" * an item\n   with 2 lines\n * other\n second line\n * ok?\nAnd a new paragraph");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ul><li>an item with 2 lines</li><li>other second line</li><li>ok?</li></ul><p>And a new paragraph</p></body>"));
    }

    public void testListMultipleLinesWithoutSpacePrefix() throws Exception {
        String html = this.parser.parseToHtml("- an item\ncreate paragraph\n- try\n this\n again\n- it\n  is working\n- ok?");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ul><li>an item</li></ul><p>create paragraph</p><ul><li>try this again</li><li>it is working</li><li>ok?</li></ul></body>"));
    }

    public void testListMultipleLinesBigSpacePrefix() throws Exception {
        String html = this.parser.parseToHtml("    1. item1\n       more\n       lines\n    1. item2");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><ol><li>item1 more lines</li><li>item2</li></ol></body>"));
    }

    public void testListMultipleLinesQuote() throws Exception {
        String html = this.parser.parseToHtml("1. item1\n    wrong: create a quote\n1. item2");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><ol><li>item1</li></ol><blockquote><p>\\s*wrong: create a quote</p></blockquote><ol><li>item2</li></ol></body>", 8).matcher(html).find());
    }

    public void testPreformatted() throws IOException {
        String html = this.parser.parseToHtml("first para\n\n{{{\n\tpreformatted text\n\nspanning multilple lines\n}}}\nsecond para");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>first para</p><pre>\\s*?\tpreformatted text\\s*spanning multilple lines\\s*</pre><p>second para</p></body>", 8).matcher(html).find());
    }

    public void testPreformattedNextToPara() throws IOException {
        String html = this.parser.parseToHtml("first para\n{{{\n\tpreformatted text\n\nspanning multilple lines\n}}}\nsecond para");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>first para</p><pre>\\s*?\tpreformatted text\\s*spanning multilple lines\\s*</pre><p>second para</p></body>", 8).matcher(html).find());
    }

    public void testPreformattedInline() throws IOException {
        String html = this.parser.parseToHtml("first para {{{ preformatted text }}} more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>first para <tt> preformatted text </tt> more text</p></body>"));
    }

    public void testPreformattedInline2() throws IOException {
        String html = this.parser.parseToHtml("first para {{{ preformatted text }}} and {{{ more code }}} more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>first para <tt> preformatted text </tt> and <tt> more code </tt> more text</p></body>"));
    }

    public void testPreformattedInline3() throws IOException {
        String html = this.parser.parseToHtml("{{{ preformatted text }}}");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p><tt> preformatted text </tt></p></body>"));
    }

    public void testQuoteBlock() throws IOException {
        String html = this.parser.parseToHtml(">> second level\n>> second level line 2\n> first level\nnew para\n");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><blockquote><blockquote><p>second level<br/>\\s*second level line 2</p></blockquote><p>first level</p></blockquote><p>new para</p></body>", 8).matcher(html).find());
    }

    public void testQuoteBlockFollowingPara() throws IOException {
        String html = this.parser.parseToHtml("normal para\n> quoted\nnew para\n");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal para</p><blockquote><p>quoted</p></blockquote><p>new para</p></body>", 8).matcher(html).find());
    }

    public void testQuoteBlockWithSpaces() throws IOException {
        String html = this.parser.parseToHtml("normal para\n  quoted\n  first level\nnew para\n");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal para</p><blockquote><p>quoted<br/>\\s*first level</p></blockquote><p>new para</p></body>", 8).matcher(html).find());
    }

    public void testTableBlock() {
        String html = this.parser.parseToHtml("normal para\n||a table||row with three||columns||\n||another||row||||\nnew para\n");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>normal para</p><table><tr><td>a table</td><td>row with three</td><td>columns</td></tr><tr><td>another</td><td>row</td><td></td></tr></table><p>new para</p></body>", 8).matcher(html).find());
    }

    public void testHyperlink() {
        String html = this.parser.parseToHtml("a normal para http://www.example.com with a hyperlink");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>a normal para <a href=\"http://www.example.com\">http://www.example.com</a> with a hyperlink</p></body>", 8).matcher(html).find());
    }

    public void testHyperlinkWithTitle() {
        String html = this.parser.parseToHtml("a normal para [http://www.example.com Example ] with a hyperlink");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>a normal para <a href=\"http://www.example.com\">Example</a> with a hyperlink</p></body>", 8).matcher(html).find());
    }

    public void testHyperlinkWithoutTitle() {
        String html = this.parser.parseToHtml("a normal para [http://www.example.com] with a hyperlink");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>a normal para <a href=\"http://www.example.com\">http://www.example.com</a> with a hyperlink</p></body>", 8).matcher(html).find());
    }

    public void testInternalHyperlinkWithTitle() {
        String html = this.parser.parseToHtml("a normal para [wiki:ISO9000 ISO 9000] with a hyperlink");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a normal para <a href=\"ISO9000\">ISO 9000</a> with a hyperlink</p></body>"));
    }

    public void testInternalHyperlinkWithoutTitle() {
        String html = this.parser.parseToHtml("a normal para [wiki:ISO9000] with a hyperlink");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a normal para <a href=\"ISO9000\">ISO9000</a> with a hyperlink</p></body>"));
    }

    public void testWikiWord() {
        this.markupLanguage.setInternalLinkPattern("https://foo.bar/wiki/{0}");
        String html = this.parser.parseToHtml("A WikiWord points somewhere");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A <a href=\"https://foo.bar/wiki/WikiWord\">WikiWord</a> points somewhere</p></body>"));
    }

    public void testWikiWordDisabled() {
        MarkupLanguageConfiguration configuration = new MarkupLanguageConfiguration();
        configuration.setWikiWordLinking(Boolean.valueOf(false));
        this.markupLanguage.configure(configuration);
        this.markupLanguage.setInternalLinkPattern("https://foo.bar/wiki/{0}");
        String html = this.parser.parseToHtml("A WikiWord points somewhere");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A WikiWord points somewhere</p></body>"));
    }

    public void testWikiColon() {
        this.markupLanguage.setInternalLinkPattern("https://foo.bar/wiki/{0}");
        String html = this.parser.parseToHtml("A wiki:word points somewhere");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A <a href=\"https://foo.bar/wiki/word\">word</a> points somewhere</p></body>"));
    }

    public void testWikiWordNegativeMatch() {
        this.testWikiWordNegativeMatch("A noWikiWord points somewhere");
        this.testWikiWordNegativeMatch("A noAWikiWord points somewhere");
        this.testWikiWordNegativeMatch("A aBBaB points somewhere");
        this.testWikiWordNegativeMatch("A XML HTML or PDF points NOT somewhere");
        this.testWikiWordNegativeMatch("not a WikiWOrd");
        this.testWikiWordNegativeMatch("not a 1WikiWord");
        this.testWikiWordNegativeMatch("1WikiWord WIkiWord O2WikiWord");
        this.testWikiWordNegativeMatch("Wiki-Word Wi-kiWord");
        this.testWikiWordNegativeMatch("not a WikiWord", "not a !WikiWord");
    }

    private void testWikiWordNegativeMatch(String toTest) {
        this.testWikiWordNegativeMatch(toTest, toTest);
    }

    private void testWikiWordNegativeMatch(String expected, String toTest) {
        this.markupLanguage.setInternalLinkPattern("https://foo.bar/wiki/{0}");
        String html = this.parser.parseToHtml(toTest);
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>" + expected + "</p></body>"));
    }

    public void testWikiWordAtLineStart() {
        this.markupLanguage.setInternalLinkPattern("https://foo.bar/wiki/{0}");
        String html = this.parser.parseToHtml("WikiWord points somewhere");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p><a href=\"https://foo.bar/wiki/WikiWord\">WikiWord</a> points somewhere</p></body>"));
    }

    public void testWikiWordAtLineEnd() {
        this.markupLanguage.setInternalLinkPattern("https://foo.bar/wiki/{0}");
        String html = this.parser.parseToHtml("a WikiWord");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"https://foo.bar/wiki/WikiWord\">WikiWord</a></p></body>"));
    }

    public void testWikiWordNoAutolink() {
        this.markupLanguage.setAutoLinking(false);
        String html = this.parser.parseToHtml("A WikiWord points somewhere but not this one!");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A WikiWord points somewhere but not this one!</p></body>"));
    }

    public void testWikiWordEscaped() {
        String html = this.parser.parseToHtml("A !WikiWord points somewhere");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A WikiWord points somewhere</p></body>"));
    }

    public void testTicketLink() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A ticket #1 or ticket:1 to somewhere");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A ticket <a href=\"http://trac.edgewall.org/ticket/1\">#1</a> or <a href=\"http://trac.edgewall.org/ticket/1\">ticket:1</a> to somewhere</p></body>"));
    }

    public void testTicketLinkNegativeMatch() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A ticket a#1 or aticket:1 to somewhere");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A ticket a#1 or aticket:1 to somewhere</p></body>"));
    }

    public void testTicketLinkWithComment() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A ticket comment:1:ticket:2 to somewhere");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A ticket <a href=\"http://trac.edgewall.org/ticket/2#comment:1\">comment:1:ticket:2</a> to somewhere</p></body>"));
    }

    public void testTicketLinkWithCommentNegativeMatch() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A ticket acomment:1:ticket:2 to somewhere");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A ticket acomment:1:<a href=\"http://trac.edgewall.org/ticket/2\">ticket:2</a> to somewhere</p></body>"));
    }

    public void testReportLink() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A report:1 about something");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A <a href=\"http://trac.edgewall.org/report/1\">report:1</a> about something</p></body>"));
    }

    public void testReportLinkNegativeMatch() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A areport:1 about something");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A areport:1 about something</p></body>"));
    }

    public void testChangesetLink() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A changeset r1 or [1] or [1/trunk] or changeset:1 or changeset:1/trunk more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A changeset <a href=\"http://trac.edgewall.org/changeset/1\">r1</a> or <a href=\"http://trac.edgewall.org/changeset/1\">[1]</a> or <a href=\"http://trac.edgewall.org/changeset/1/trunk\">[1/trunk]</a> or <a href=\"http://trac.edgewall.org/changeset/1\">changeset:1</a> or <a href=\"http://trac.edgewall.org/changeset/1/trunk\">changeset:1/trunk</a> more text</p></body>"));
    }

    public void testChangesetLinkNegativeMatch() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A changeset ar1 or a[1] or a[1/trunk] or achangeset:1 or achangeset:1/trunk more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A changeset ar1 or a[1] or a[1/trunk] or achangeset:1 or achangeset:1/trunk more text</p></body>"));
    }

    public void testRevisionLogLink() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A revision log r1:3, [1:3] or log:@1:3, log:trunk@1:3, [2:5/trunk] more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A revision log <a href=\"http://trac.edgewall.org/log/?revs=1-3\">r1:3</a>, <a href=\"http://trac.edgewall.org/log/?revs=1-3\">[1:3]</a> or <a href=\"http://trac.edgewall.org/log/?revs=1-3\">log:@1:3</a>, <a href=\"http://trac.edgewall.org/log/trunk?revs=1-3\">log:trunk@1:3</a>, <a href=\"http://trac.edgewall.org/log/trunk?revs=2-5\">[2:5/trunk]</a> more text</p></body>"));
    }

    public void testRevisionLogLinkNegativeMatch() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A revision log ar1:3, a[1:3] or alog:@1:3, alog:trunk@1:3, a[2:5/trunk] more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A revision log ar1:3, a[1:3] or alog:@1:3, alog:trunk@1:3, a[2:5/trunk] more text</p></body>"));
    }

    public void testMilestoneLink() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A milestone:1.0 more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A <a href=\"http://trac.edgewall.org/milestone/1.0\">milestone:1.0</a> more text</p></body>"));
    }

    public void testMilestoneLinkNegativeMatch() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A amilestone:1.0 more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A amilestone:1.0 more text</p></body>"));
    }

    public void testTicketAttachmentLink() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A attachment:foobar.txt:ticket:12345 more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A <a href=\"http://trac.edgewall.org/ticket/12345/foobar.txt\">attachment:foobar.txt:ticket:12345</a> more text</p></body>"));
    }

    public void testTicketAttachmentLinkNegativeMatch() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A Aattachment:foobar.txt:ticket:12345 more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A Aattachment:foobar.txt:<a href=\"http://trac.edgewall.org/ticket/12345\">ticket:12345</a> more text</p></body>"));
    }

    public void testSourceLink() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A source:/trunk/COPYING or source:/trunk/COPYING@200 or source:/trunk/COPYING@200#L26 more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A <a href=\"http://trac.edgewall.org/browser/trunk/COPYING\">source:/trunk/COPYING</a> or <a href=\"http://trac.edgewall.org/browser/trunk/COPYING?rev=200\">source:/trunk/COPYING@200</a> or <a href=\"http://trac.edgewall.org/browser/trunk/COPYING?rev=200#L26\">source:/trunk/COPYING@200#L26</a> more text</p></body>"));
    }

    public void testSourceLinkNegativeMatch() {
        this.markupLanguage.setServerUrl("http://trac.edgewall.org");
        String html = this.parser.parseToHtml("A Asource:/trunk/COPYING or Asource:/trunk/COPYING@200 or Asource:/trunk/COPYING@200#L26 more text");
        TestUtil.println(html);
        TracWikiLanguageTest.assertTrue((boolean)html.contains("<body><p>A Asource:/trunk/COPYING or Asource:/trunk/COPYING@200 or Asource:/trunk/COPYING@200#L26 more text</p></body>"));
    }
}

