/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.views;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsImages;
import org.eclipse.mylyn.internal.reviews.ui.providers.ReviewsLabelProvider;
import org.eclipse.mylyn.internal.reviews.ui.providers.TableStyledLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.spi.ReviewsClient;
import org.eclipse.mylyn.reviews.core.spi.ReviewsConnector;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.eclipse.mylyn.reviews.core.spi.remote.review.IReviewRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewTaskEditorPage;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class ReviewExplorer
extends CommonNavigator {
    public static final String SHOW_VIEW_LIST = "showViewList";
    public static final String FILTER_FOR_COMMENTS = "filterForComments";
    private static final String TREE_ACTION_GROUP = "tree";
    private static final String FILTER_ACTION_GROUP = "filters";
    private static final String REFRESH_ACTION_GROUP = "refresh";
    private RefreshReviewsAction refreshAction;
    private boolean showList;
    private boolean filterForComments;
    private IReview review = null;
    private TaskEditor currentPart;
    private ReviewsLabelProvider treeLabelProvider;
    private ReviewsLabelProvider flatLabelProvider;
    private TableStyledLabelProvider currentProvider;
    private RemoteEmfConsumer<IRepository, IReview, String, ?, ?, Date> reviewConsumer;
    private final RemoteEmfObserver<IRepository, IReview, String, Date> reviewObserver = new RemoteEmfObserver<IRepository, IReview, String, Date>(){

        public void updated(boolean modified) {
            if (modified) {
                ReviewExplorer.this.updatePatchSetObservers();
                ReviewExplorer.this.updatePerservingSelection();
            }
        }
    };
    private final Map<IReviewItemSet, RemoteItemSetContentObserver> patchSetObservers = new HashMap<IReviewItemSet, RemoteItemSetContentObserver>();
    private final IPartListener editorPartListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == ReviewExplorer.this.currentPart) {
                ReviewExplorer.this.currentPart = null;
                ReviewExplorer.this.setReview(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            TaskEditor editor;
            IFormPage page;
            if (part instanceof TaskEditor && ReviewExplorer.this.currentPart != part && (page = (editor = (TaskEditor)part).getActivePageInstance()) instanceof AbstractReviewTaskEditorPage) {
                ReviewExplorer.this.currentPart = (TaskEditor)part;
                AbstractReviewTaskEditorPage reviewPage = (AbstractReviewTaskEditorPage)page;
                ReviewExplorer.this.setReview(reviewPage.getReview());
                ReviewExplorer.this.updateContentDescription();
            }
        }
    };
    private final IPageListener pageListener = new IPageListener(){
        private IWorkbenchPage activePage;

        public void pageOpened(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
            this.pageActivated(null);
        }

        public void pageActivated(IWorkbenchPage page) {
            if (page != this.activePage) {
                if (this.activePage != null) {
                    this.activePage.removePartListener(ReviewExplorer.this.editorPartListener);
                }
                if (page != null) {
                    page.addPartListener(ReviewExplorer.this.editorPartListener);
                    ReviewExplorer.this.editorPartListener.partActivated((IWorkbenchPart)page.getActiveEditor());
                }
                this.activePage = page;
            }
        }
    };
    private IReviewRemoteFactoryProvider factoryProvider;

    protected CommonViewer createCommonViewer(Composite parent) {
        this.flatLabelProvider = new ReviewsLabelProvider.Flat();
        this.treeLabelProvider = new ReviewsLabelProvider.Tree();
        CommonViewer viewer = super.createCommonViewer(parent);
        this.updateTreeViewer(viewer);
        viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                IReviewItemSet set;
                if (event.getElement() instanceof IReviewItemSet && (set = (IReviewItemSet)event.getElement()).getItems().size() == 0) {
                    RemoteItemSetContentObserver observer = (RemoteItemSetContentObserver)((Object)ReviewExplorer.this.patchSetObservers.get(set));
                    observer.getConsumer().retrieve(false);
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        return viewer;
    }

    void updateTreeViewer(CommonViewer viewer) {
        TreeColumn[] treeColumnArray = viewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.dispose();
            ++n2;
        }
        if (this.isShowColumns()) {
            Tree treeTable = viewer.getTree();
            treeTable.setHeaderVisible(true);
            treeTable.setLinesVisible(false);
            treeTable.setLayoutData((Object)new GridData(1808));
            this.currentProvider = null;
            this.currentProvider = this.isFlat() ? this.flatLabelProvider : this.treeLabelProvider;
            if (viewer.getLabelProvider() != this.currentProvider) {
                viewer.setLabelProvider((IBaseLabelProvider)this.currentProvider);
            }
            this.updateTable((TreeViewer)viewer);
        }
    }

    void updateTable(TreeViewer viewer) {
        TableLayout layout = new TableLayout();
        viewer.getTree().setLayout((Layout)layout);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        TableStyledLabelProvider.TableColumnProvider[] tableColumnProviderArray = this.currentProvider.getColumnProviders();
        int n = tableColumnProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableStyledLabelProvider.TableColumnProvider columnProvider = tableColumnProviderArray[n2];
            this.updateColumn(viewer, columnProvider);
            ++n2;
        }
    }

    void updateColumn(TreeViewer viewer, final TableStyledLabelProvider.TableColumnProvider provider) {
        TreeColumn column = null;
        TreeViewerColumn viewerColumn = new TreeViewerColumn(viewer, 0);
        DelegatingStyledCellLabelProvider styledLabelProvider = new DelegatingStyledCellLabelProvider(provider){

            public String getToolTipText(Object element) {
                return provider.getToolTipText(element);
            }
        };
        viewerColumn.setLabelProvider((CellLabelProvider)styledLabelProvider);
        column = viewerColumn.getColumn();
        column.setText(provider.getTitle());
        if (!provider.isFillAvailable()) {
            column.setWidth(provider.getMinimumSize());
        } else {
            int width = viewer.getTree().getClientArea().width;
            if (!viewer.getTree().getVerticalBar().isVisible()) {
                width -= viewer.getTree().getVerticalBar().getSize().x;
            }
            int allWidths = 0;
            TableStyledLabelProvider.TableColumnProvider[] tableColumnProviderArray = this.currentProvider.getColumnProviders();
            int n = tableColumnProviderArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableStyledLabelProvider.TableColumnProvider provider2 = tableColumnProviderArray[n2];
                if (provider2 != provider) {
                    allWidths += provider2.getMinimumSize();
                }
                ++n2;
            }
            column.setWidth(width - allWidths);
        }
        TableLayout layout = (TableLayout)viewer.getTree().getLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(provider.getWeight(), provider.getMinimumSize()));
    }

    protected CommonViewer createCommonViewerObject(Composite parent) {
        return new CommonViewer(this.getViewId(), parent, 770);
    }

    private Collection<Object> matchingElements(ITreeContentProvider provider, Object parent, Collection<Object> toMatch, boolean prune) {
        HashSet<String> matchingLabels = new HashSet<String>();
        for (Object object : toMatch) {
            String label = ((ILabelProvider)this.getCommonViewer().getLabelProvider()).getText(object);
            matchingLabels.add(label);
        }
        return this.matchingLabelElements(provider, parent, matchingLabels, prune);
    }

    private Collection<Object> matchingLabelElements(ITreeContentProvider provider, Object parent, Collection<String> toMatch, boolean prune) {
        Object[] children;
        HashSet<Object> matches = new HashSet<Object>();
        String parentLabel = ((ILabelProvider)this.getCommonViewer().getLabelProvider()).getText(parent);
        if (toMatch.contains(parentLabel)) {
            matches.add(parent);
        }
        Object[] objectArray = children = provider.getElements(parent);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            String childLabel = ((ILabelProvider)this.getCommonViewer().getLabelProvider()).getText(object);
            if (!prune || toMatch.contains(childLabel)) {
                matches.addAll(this.matchingLabelElements(provider, object, toMatch, prune));
            }
            ++n2;
        }
        return matches;
    }

    public void createPartControl(Composite aParent) {
        Boolean value;
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager manager = actionBars.getToolBarManager();
        if (this.isSupportsListTree()) {
            this.showList = false;
            if (this.getMemento() != null && (value = this.getMemento().getBoolean(SHOW_VIEW_LIST)) != null) {
                this.showList = value;
            }
            ShowTreeAction showTreeAction = new ShowTreeAction();
            showTreeAction.setChecked(!this.showList);
            ShowListAction showListAction = new ShowListAction();
            showListAction.setChecked(this.showList);
            manager.add((IContributionItem)new Separator(TREE_ACTION_GROUP));
            manager.add((IContributionItem)new Separator("presentation"));
            manager.appendToGroup("presentation", (IAction)showTreeAction);
            manager.appendToGroup("presentation", (IAction)showListAction);
        }
        this.filterForComments = false;
        if (this.getMemento() != null && (value = this.getMemento().getBoolean(FILTER_FOR_COMMENTS)) != null) {
            this.filterForComments = value;
        }
        manager.add((IContributionItem)new Separator(FILTER_ACTION_GROUP));
        manager.appendToGroup(FILTER_ACTION_GROUP, (IAction)new FilterNonCommentsReviewsAction());
        manager.add((IContributionItem)new Separator("Separator"));
        super.createPartControl(aParent);
        manager.add((IContributionItem)new Separator(REFRESH_ACTION_GROUP));
        this.refreshAction = new RefreshReviewsAction();
        this.refreshAction.setEnabled(false);
        manager.appendToGroup(REFRESH_ACTION_GROUP, (IAction)this.refreshAction);
        this.updateActivations();
        this.pageListener.pageActivated(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
        this.update();
    }

    protected void updateContentDescription() {
        String title = "(No Selection)";
        if (this.currentPart != null && this.currentPart.getTaskEditorInput() != null) {
            ITask task = this.currentPart.getTaskEditorInput().getTask();
            title = "Change " + task.getTaskId() + ": " + task.getSummary();
        }
        this.setContentDescription(title);
    }

    protected void update() {
        this.updateContentDescription();
        if (!this.getCommonViewer().getControl().isDisposed()) {
            this.refreshAction.setEnabled(this.review != null);
            this.getCommonViewer().setInput((Object)this.review);
            this.getCommonViewer().refresh();
        }
    }

    protected void refresh() {
        if (this.reviewConsumer != null) {
            this.reviewConsumer.retrieve(true);
            for (RemoteItemSetContentObserver observer : this.patchSetObservers.values()) {
                observer.getConsumer().retrieve(true);
            }
        }
    }

    protected void updatePerservingSelection() {
        if (!this.getCommonViewer().getControl().isDisposed()) {
            Object[] priorExpanded = this.getCommonViewer().getExpandedElements();
            Object[] priorSelection = new Object[]{};
            if (this.getCommonViewer().getSelection() instanceof IStructuredSelection) {
                priorSelection = ((IStructuredSelection)this.getCommonViewer().getSelection()).toArray();
            }
            this.getCommonViewer().getControl().setRedraw(false);
            this.update();
            Collection<Object> newExpanded = this.matchingElements((ITreeContentProvider)this.getCommonViewer().getContentProvider(), this.review, new HashSet<Object>(Arrays.asList(priorExpanded)), true);
            Collection<Object> newSelection = this.matchingElements((ITreeContentProvider)this.getCommonViewer().getContentProvider(), this.review, new HashSet<Object>(Arrays.asList(priorSelection)), false);
            this.getCommonViewer().setExpandedElements(newExpanded.toArray());
            this.getCommonViewer().setSelection((ISelection)new StructuredSelection(newSelection.toArray()), true);
            this.getCommonViewer().getControl().setRedraw(true);
            this.getCommonViewer().getControl().redraw();
        }
    }

    public void setReview(IReview review) {
        if (this.review != review) {
            this.review = review;
            for (RemoteEmfObserver remoteEmfObserver : this.patchSetObservers.values()) {
                remoteEmfObserver.dispose();
            }
            this.patchSetObservers.clear();
            if (this.reviewConsumer != null) {
                this.reviewConsumer.removeObserver(this.reviewObserver);
            }
            if (review != null) {
                ReviewsConnector reviewsConnector = (ReviewsConnector)TasksUiPlugin.getConnector((String)review.getRepository().getTaskConnectorKind());
                ReviewsClient reviewsClient = reviewsConnector.getReviewClient(review.getRepository().getTaskRepository());
                this.factoryProvider = (IReviewRemoteFactoryProvider)reviewsClient.getFactoryProvider();
                this.reviewConsumer = this.factoryProvider.getReviewFactory().getConsumerForModel((EObject)this.factoryProvider.getRoot(), (Object)review);
                this.reviewConsumer.addObserver(this.reviewObserver);
                this.updatePatchSetObservers();
            }
            this.update();
        }
    }

    public void saveState(IMemento aMemento) {
        super.saveState(aMemento);
        if (this.isSupportsListTree()) {
            aMemento.putBoolean(SHOW_VIEW_LIST, this.showList);
            aMemento.putBoolean(FILTER_ACTION_GROUP, this.filterForComments);
        }
    }

    public void updatePatchSetObservers() {
        for (IReviewItemSet set : this.review.getSets()) {
            RemoteItemSetContentObserver client = this.patchSetObservers.get(set);
            if (client != null) continue;
            RemoteItemSetContentObserver patchSetObserver = new RemoteItemSetContentObserver();
            RemoteEmfConsumer consumer = this.factoryProvider.getReviewItemSetContentFactory().getConsumerForLocalKey((EObject)set, (Object)set.getId());
            patchSetObserver.setConsumer(consumer);
            this.patchSetObservers.put(set, patchSetObserver);
        }
    }

    public void dispose() {
        super.dispose();
        this.flatLabelProvider.doDispose();
        this.treeLabelProvider.doDispose();
        this.currentPart = null;
        this.setReview(null);
        this.pageListener.pageActivated(null);
    }

    public boolean isFlat() {
        return this.isSupportsListTree() && this.showList;
    }

    protected String getTreeContentId() {
        return "org.eclipse.mylyn.reviews.ui.ReviewContent";
    }

    protected String getListContentId() {
        return "org.eclipse.mylyn.reviews.ui.ReviewFlatContent";
    }

    protected String getViewId() {
        return "org.eclipse.mylyn.reviews.Explorer";
    }

    protected final boolean isSupportsListTree() {
        return this.getListContentId() != null;
    }

    protected boolean isShowColumns() {
        return true;
    }

    public boolean isFilterForComments() {
        return this.filterForComments;
    }

    protected void updateActivations() {
        INavigatorActivationService activationService = this.getCommonViewer().getNavigatorContentService().getActivationService();
        if (!this.isSupportsListTree()) {
            activationService.activateExtensions(new String[]{this.getTreeContentId()}, false);
        } else if (this.isFlat()) {
            activationService.deactivateExtensions(new String[]{this.getTreeContentId()}, false);
            activationService.activateExtensions(new String[]{this.getListContentId()}, false);
        } else {
            activationService.deactivateExtensions(new String[]{this.getListContentId()}, false);
            activationService.activateExtensions(new String[]{this.getTreeContentId()}, false);
        }
        INavigatorFilterService filterService = this.getCommonViewer().getNavigatorContentService().getFilterService();
        ICommonFilterDescriptor[] visibleDescriptors = filterService.getVisibleFilterDescriptors();
        boolean commentFilterActive = false;
        ICommonFilterDescriptor[] iCommonFilterDescriptorArray = visibleDescriptors;
        int n = visibleDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ICommonFilterDescriptor descriptor = iCommonFilterDescriptorArray[n2];
            if (descriptor.getId().equals("org.eclipse.mylyn.reviews.ui.CommonFilter") && filterService.isActive(descriptor.getId())) {
                commentFilterActive = true;
                break;
            }
            ++n2;
        }
        boolean filtersModified = false;
        if (this.isFilterForComments() && !commentFilterActive) {
            filterService.setActiveFilterIds(new String[]{"org.eclipse.mylyn.reviews.ui.CommonFilter"});
            filtersModified = true;
        } else if (!this.isFilterForComments() && commentFilterActive) {
            filterService.setActiveFilterIds(new String[0]);
            filtersModified = true;
        }
        if (filtersModified) {
            filterService.persistFilterActivationState();
            ViewerFilter[] visibleFilters = filterService.getVisibleFilters(true);
            this.getCommonViewer().setFilters(visibleFilters);
        }
        this.updateTreeViewer(this.getCommonViewer());
        this.getCommonViewer().refresh();
    }

    public IWorkbenchPart getCurrentPart() {
        return this.currentPart;
    }

    class FilterNonCommentsReviewsAction
    extends Action {
        public FilterNonCommentsReviewsAction() {
            super("", 2);
            this.setText("Filter for Comments");
            this.setDescription("Filter items for comments.");
            this.setToolTipText("Hide items that don't have comments");
            this.setImageDescriptor(ReviewsImages.REVIEW_QUOTE);
        }

        public void run() {
            ReviewExplorer.this.filterForComments = this.isChecked();
            if (ReviewExplorer.this.memento != null) {
                ReviewExplorer.this.memento.putBoolean(ReviewExplorer.FILTER_FOR_COMMENTS, ReviewExplorer.this.filterForComments);
            }
            ReviewExplorer.this.updateActivations();
        }
    }

    class RefreshReviewsAction
    extends Action {
        public RefreshReviewsAction() {
            super("", 1);
            this.setText("Refresh");
            this.setDescription("Refresh Review Items");
            this.setToolTipText("Refresh Review Items");
            this.setImageDescriptor(ReviewsImages.REFRESH);
        }

        public void run() {
            ReviewExplorer.this.refresh();
        }
    }

    private class RemoteItemSetContentObserver
    extends RemoteEmfObserver<IReviewItemSet, List<IFileItem>, String, Long> {
        private RemoteItemSetContentObserver() {
        }

        public void updated(boolean modified) {
            if (ReviewExplorer.this.showList) {
                ReviewExplorer.this.getCommonViewer().refresh(true);
            } else {
                TreeItem[] rootItems = ReviewExplorer.this.getCommonViewer().getTree().getItems();
                boolean parentDisplayed = false;
                TreeItem[] treeItemArray = rootItems;
                int n = rootItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    Object data = treeItem.getData();
                    if (data == this.getConsumer().getParentObject()) {
                        parentDisplayed = true;
                        break;
                    }
                    ++n2;
                }
                if (parentDisplayed) {
                    ReviewExplorer.this.getCommonViewer().refresh((Object)this.getConsumer().getParentObject(), true);
                } else {
                    ReviewExplorer.this.getCommonViewer().refresh(true);
                }
            }
        }
    }

    class ShowListAction
    extends Action {
        public ShowListAction() {
            super("", 8);
            this.setText("Show List");
            this.setDescription("Show comments in a flat list");
            this.setToolTipText("Show all comments in a flat list (Hide files and patch sets)");
            this.setImageDescriptor(ReviewsImages.FLAT_LAYOUT);
        }

        public void run() {
            if (this.isChecked()) {
                if (ReviewExplorer.this.getMemento() != null) {
                    ReviewExplorer.this.getMemento().putBoolean(ReviewExplorer.SHOW_VIEW_LIST, true);
                }
                ReviewExplorer.this.showList = true;
                ReviewExplorer.this.updateActivations();
            }
        }
    }

    class ShowTreeAction
    extends Action {
        public ShowTreeAction() {
            super("", 8);
            this.setText("Show Tree");
            this.setDescription("Show all items in a tree");
            this.setToolTipText("Show artifacts, files and global comments in a tree");
            this.setImageDescriptor(ReviewsImages.HIERARCHICAL_LAYOUT);
        }

        public void run() {
            if (this.isChecked()) {
                if (ReviewExplorer.this.getMemento() != null) {
                    ReviewExplorer.this.getMemento().putBoolean(ReviewExplorer.SHOW_VIEW_LIST, false);
                }
                ReviewExplorer.this.showList = false;
                ReviewExplorer.this.updateActivations();
            }
        }
    }
}

