/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import com.google.gerrit.reviewdb.PatchSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.mylyn.internal.gerrit.ui.egit.EGitUiUtil;

public class FetchPatchSetJob
extends Job {
    private final Repository repository;
    private final RemoteConfig remote;
    private final PatchSet patchSet;
    private RepositoryCommit commit;

    public FetchPatchSetJob(String name, Repository repository, RemoteConfig remote, PatchSet patchSet) {
        super(name);
        this.repository = repository;
        this.remote = remote;
        this.patchSet = patchSet;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            RevCommit revCommit = EGitUiUtil.fetchPatchSet((IProgressMonitor)subMonitor, this.repository, this.remote, this.patchSet);
            this.commit = new RepositoryCommit(this.repository, revCommit);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.mylyn.gerrit.ui", "Patch set retrieval failed", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public RepositoryCommit getCommit() {
        return this.commit;
    }
}

