/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.factories;

import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.PatchSet;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.gerrit.core.client.PatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.remote.PatchSetContentCompareRemoteFactory;
import org.eclipse.mylyn.internal.gerrit.ui.GerritReviewBehavior;
import org.eclipse.mylyn.internal.gerrit.ui.factories.AbstractPatchSetUiFactory;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewItemSetCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.reviews.ui.spi.factories.IUiContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.statushandlers.StatusManager;

public class CompareWithUiFactory
extends AbstractPatchSetUiFactory {
    private final RemoteEmfObserver<IReviewItemSet, List<IFileItem>, String, Long> itemListClient = new RemoteEmfObserver<IReviewItemSet, List<IFileItem>, String, Long>(){

        public void updated(boolean modified) {
            IStatus status = CompareWithUiFactory.this.itemListClient.getConsumer().getStatus();
            if (status.isOK()) {
                CompareConfiguration configuration = new CompareConfiguration();
                CompareUI.openCompareEditor((CompareEditorInput)new ReviewItemSetCompareEditorInput(configuration, CompareWithUiFactory.this.compareSet, null, (ReviewBehavior)new GerritReviewBehavior(CompareWithUiFactory.this.getTask(), CompareWithUiFactory.this.resolveGitRepository())));
                this.dispose();
            } else {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.ui", "Couldn't load content for compare editor", status.getException()), 3);
            }
        }
    };
    private IReviewItemSet baseSet;
    private IReviewItemSet targetSet;
    private IReviewItemSet compareSet;

    public CompareWithUiFactory(IUiContext context, IReviewItemSet set) {
        super("Compare With...", context, set);
    }

    public Control createControl(IUiContext context, Composite parent, FormToolkit toolkit) {
        if (this.isExecutable()) {
            final Composite compareComposite = toolkit.createComposite(parent);
            GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(compareComposite);
            Button compareButton = toolkit.createButton(compareComposite, "Compare With Base", 8);
            compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CompareWithUiFactory.this.baseSet = null;
                    CompareWithUiFactory.this.targetSet = (IReviewItemSet)CompareWithUiFactory.this.getModelObject();
                    CompareWithUiFactory.this.execute();
                }
            });
            if (((IReviewItemSet)this.getModelObject()).getReview().getSets().size() > 1) {
                Button compareWithButton = toolkit.createButton(compareComposite, "", 8);
                GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)compareWithButton);
                compareWithButton.setImage(WorkbenchImages.getImage((String)"IMG_LCL_BUTTON_MENU"));
                compareWithButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.showCompareMenu(compareComposite);
                    }

                    private void showCompareMenu(Composite compareComposite2) {
                        Menu menu = new Menu((Control)compareComposite2);
                        Point p = compareComposite2.getLocation();
                        p.y += compareComposite2.getSize().y;
                        p = compareComposite2.getParent().toDisplay(p);
                        for (final IReviewItemSet otherSet : ((IReviewItemSet)CompareWithUiFactory.this.getModelObject()).getReview().getSets()) {
                            if (otherSet == CompareWithUiFactory.this.getModelObject()) continue;
                            MenuItem item = new MenuItem(menu, 0);
                            item.setText(NLS.bind((String)"Compare with {0}", (Object)otherSet.getName()));
                            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    CompareWithUiFactory.this.baseSet = otherSet;
                                    CompareWithUiFactory.this.targetSet = (IReviewItemSet)CompareWithUiFactory.this.getModelObject();
                                    CompareWithUiFactory.this.execute();
                                }
                            });
                        }
                        menu.setLocation(p);
                        menu.setVisible(true);
                    }
                });
            }
            return compareComposite;
        }
        return null;
    }

    public void execute() {
        PatchSetDetail targetSetDetail;
        PatchSet basePatch = null;
        if (this.baseSet != null) {
            PatchSetDetail baseSetDetail = this.getPatchSetDetail(this.baseSet);
            if (baseSetDetail == null) {
                this.handleExecutionStateError();
                return;
            }
            basePatch = baseSetDetail.getPatchSet();
        }
        if ((targetSetDetail = this.getPatchSetDetail(this.targetSet)) == null) {
            this.handleExecutionStateError();
            return;
        }
        PatchSetContent content = new PatchSetContent(basePatch, targetSetDetail.getPatchSet());
        this.compareSet = IReviewsFactory.INSTANCE.createReviewItemSet();
        String basePatchSetLabel = content.getBase() != null ? String.valueOf(content.getBase().getPatchSetId()) : "Base";
        this.compareSet.setName(NLS.bind((String)"Compare Patch Set {0} with {1}", (Object)content.getTarget().getPatchSetId(), (Object)basePatchSetLabel));
        PatchSetContentCompareRemoteFactory remoteFactory = new PatchSetContentCompareRemoteFactory(this.getGerritFactoryProvider());
        RemoteEmfConsumer consumer = remoteFactory.getConsumerForRemoteObject((EObject)this.compareSet, (Object)content);
        consumer.setUiJob(true);
        consumer.addObserver(this.itemListClient);
        consumer.retrieve(true);
    }

    @Override
    protected boolean isExecutableStateKnown() {
        return true;
    }

    public boolean isExecutable() {
        return true;
    }
}

