/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class BugzillaSearchTest
extends TestCase {
    private static final String QUERY_NAME = "Query Page Name";
    private static final String BUG_SUMMARY_SUBSTRING_SEARCH = "/buglist.cgi?short_desc_type=allwordssubstr&short_desc=";
    private static final String BUG_COMMENT_SUBSTRING_SEARCH = "/buglist.cgi?long_desc_type=allwordssubstr&long_desc=";
    private TaskRepository repository;
    private BugzillaRepositoryConnector connector;

    protected void setUp() throws Exception {
        super.setUp();
        BugzillaFixture.current().client();
        this.connector = BugzillaFixture.current().connector();
        this.repository = BugzillaFixture.current().repository();
    }

    public void testSummarySearching() throws Exception {
        long now = System.currentTimeMillis();
        TaskData newTaskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, String.valueOf(now), null);
        BugzillaSearchTest.assertNotNull((Object)newTaskData);
        BugzillaSearchTest.assertEquals((int)1, (int)this.runQuery(BUG_SUMMARY_SUBSTRING_SEARCH, String.valueOf(now)).size());
    }

    public void testCommentSearching() throws Exception {
        long now = System.currentTimeMillis();
        TaskData newTaskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, String.valueOf(now));
        BugzillaSearchTest.assertNotNull((Object)newTaskData);
        BugzillaSearchTest.assertEquals((int)1, (int)this.runQuery(BUG_COMMENT_SUBSTRING_SEARCH, String.valueOf(now)).size());
    }

    private Set<TaskData> runQuery(String requestUrl, String queryString) throws Exception {
        IRepositoryQuery repositoryQuery = TasksUi.getRepositoryModel().createRepositoryQuery(this.repository);
        repositoryQuery.setUrl(String.valueOf(this.repository.getRepositoryUrl()) + requestUrl + queryString);
        repositoryQuery.setSummary(QUERY_NAME);
        final HashSet<TaskData> changedTaskData = new HashSet<TaskData>();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.add(taskData);
            }
        };
        IStatus status = this.connector.performQuery(this.repository, repositoryQuery, collector, null, (IProgressMonitor)new NullProgressMonitor());
        BugzillaSearchTest.assertEquals((int)0, (int)status.getCode());
        return changedTaskData;
    }
}

