/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;

public class RepositoryConfigurationTest
extends TestCase {
    private static final String PRODUCT = "product";
    RepositoryConfiguration cfg;

    protected void setUp() throws Exception {
        this.cfg = new RepositoryConfiguration();
        this.cfg.addProduct(PRODUCT);
    }

    public void testGetUnconfirmedAllowed_product() throws Exception {
        RepositoryConfigurationTest.assertFalse((boolean)this.cfg.getUnconfirmedAllowed(PRODUCT));
    }

    public void testGetUnconfirmedAllowed_productFalse() throws Exception {
        this.cfg.addUnconfirmedAllowed(PRODUCT, Boolean.FALSE);
        RepositoryConfigurationTest.assertFalse((boolean)this.cfg.getUnconfirmedAllowed(PRODUCT));
    }

    public void testGetUnconfirmedAllowed_productNull() throws Exception {
        this.cfg.addUnconfirmedAllowed(PRODUCT, null);
        RepositoryConfigurationTest.assertFalse((boolean)this.cfg.getUnconfirmedAllowed(PRODUCT));
    }

    public void testGetUnconfirmedAllowed_productTrue() throws Exception {
        this.cfg.addUnconfirmedAllowed(PRODUCT, Boolean.TRUE);
        RepositoryConfigurationTest.assertTrue((boolean)this.cfg.getUnconfirmedAllowed(PRODUCT));
    }

    public void testGetUnconfirmedAllowed_noProduct() throws Exception {
        RepositoryConfigurationTest.assertFalse((boolean)this.cfg.getUnconfirmedAllowed("no-product"));
    }
}

