/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.ui;

import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.internal.bugzilla.ui.TaskAttachmentHyperlink;
import org.eclipse.mylyn.internal.bugzilla.ui.TaskAttachmentTableEditorHyperlink;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.BugzillaConnectorUi;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;

public class BugzillaHyperlinkDetectorTest
extends TestCase {
    private BugzillaConnectorUi connector;
    private TaskRepository repository;
    private TaskTask task;

    private void assertHyperlinks(String string, IHyperlink ... expected) {
        IHyperlink[] links = this.connector.findHyperlinks(this.repository, (ITask)this.task, string, -1, 0);
        if (expected.length == 0) {
            BugzillaHyperlinkDetectorTest.assertNull((String)("Expected no hyperlinks, but got: " + (links != null ? Arrays.asList(links).toString() : "")), (Object)links);
            return;
        }
        BugzillaHyperlinkDetectorTest.assertNotNull((String)("Expected hyperlinks in " + string), (Object)links);
        BugzillaHyperlinkDetectorTest.assertEquals((int)expected.length, (int)links.length);
        int i = 0;
        while (i < links.length) {
            BugzillaHyperlinkDetectorTest.assertEquals((Object)expected[i], (Object)links[i]);
            ++i;
        }
    }

    private TaskHyperlink link(int offset, int length, String taskId) {
        return this.link(offset, length, taskId, null);
    }

    private TaskHyperlink link(int offset, int length, String taskId, String commentId) {
        TaskHyperlink link = new TaskHyperlink((IRegion)new Region(offset, length), this.repository, taskId);
        if (commentId != null) {
            link.setSelection((Object)("task.common.comment-" + commentId));
        }
        return link;
    }

    protected void setUp() throws Exception {
        this.repository = new TaskRepository("bugzilla", "http://localhost");
        this.task = new TaskTask("bugzilla", "http://localhost", "123");
        this.connector = new BugzillaConnectorUi();
    }

    public void testFindHyperlinksAttachment() {
        if (PlatformUiUtil.supportsMultipleHyperlinkPresenter()) {
            this.assertHyperlinks("attachment 123", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 14), this.repository, "123"), new TaskAttachmentTableEditorHyperlink((IRegion)new Region(0, 14), this.repository, "123")});
            this.assertHyperlinks("attachment  123", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 15), this.repository, "123"), new TaskAttachmentTableEditorHyperlink((IRegion)new Region(0, 15), this.repository, "123")});
            this.assertHyperlinks("attachment  # 123", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 17), this.repository, "123"), new TaskAttachmentTableEditorHyperlink((IRegion)new Region(0, 17), this.repository, "123")});
            this.assertHyperlinks("attachment#1", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 12), this.repository, "1"), new TaskAttachmentTableEditorHyperlink((IRegion)new Region(0, 12), this.repository, "1")});
            this.assertHyperlinks("attachment (id=123)", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 19), this.repository, "123"), new TaskAttachmentTableEditorHyperlink((IRegion)new Region(0, 19), this.repository, "123")});
            this.assertHyperlinks("Created attachment 123", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 22), this.repository, "123"), new TaskAttachmentTableEditorHyperlink((IRegion)new Region(0, 22), this.repository, "123")});
            this.assertHyperlinks("Created an attachment 123", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 25), this.repository, "123"), new TaskAttachmentTableEditorHyperlink((IRegion)new Region(0, 25), this.repository, "123")});
            this.assertHyperlinks("Created an attachment (id=123)", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 30), this.repository, "123"), new TaskAttachmentTableEditorHyperlink((IRegion)new Region(0, 30), this.repository, "123")});
        } else {
            this.assertHyperlinks("attachment 123", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 14), this.repository, "123")});
            this.assertHyperlinks("attachment  123", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 15), this.repository, "123")});
            this.assertHyperlinks("attachment  # 123", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 17), this.repository, "123")});
            this.assertHyperlinks("attachment#1", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 12), this.repository, "1")});
            this.assertHyperlinks("attachment (id=123)", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 19), this.repository, "123")});
            this.assertHyperlinks("Created attachment 123", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 22), this.repository, "123")});
            this.assertHyperlinks("Created an attachment 123", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 25), this.repository, "123")});
            this.assertHyperlinks("Created an attachment (id=123)", new IHyperlink[]{new TaskAttachmentHyperlink((IRegion)new Region(0, 30), this.repository, "123")});
        }
    }

    public void testFindHyperlinksBug() {
        this.assertHyperlinks("bug123", new IHyperlink[]{this.link(0, 6, "123")});
        this.assertHyperlinks("bug 123", new IHyperlink[]{this.link(0, 7, "123")});
        this.assertHyperlinks("bug  123", new IHyperlink[]{this.link(0, 8, "123")});
        this.assertHyperlinks("bug#123", new IHyperlink[]{this.link(0, 7, "123")});
        this.assertHyperlinks("bug  #  123", new IHyperlink[]{this.link(0, 11, "123")});
        this.assertHyperlinks("Bug: 123", new IHyperlink[]{this.link(0, 8, "123")});
        this.assertHyperlinks("bug: 123", new IHyperlink[]{this.link(0, 8, "123")});
    }

    public void testFindHyperlinksTask() {
        this.assertHyperlinks("task123", new IHyperlink[]{this.link(0, 7, "123")});
    }

    public void testFindHyperlinksDuplicateOf() {
        this.assertHyperlinks("duplicate of 123", new IHyperlink[]{this.link(0, 16, "123")});
    }

    public void testFindHyperlinksBugComment() {
        this.assertHyperlinks("bug 123 comment 12", new IHyperlink[]{this.link(0, 18, "123", "12")});
        this.assertHyperlinks("bug#123 comment 12", new IHyperlink[]{this.link(0, 18, "123", "12")});
        this.assertHyperlinks("bug 123 comment#12", new IHyperlink[]{this.link(0, 18, "123", "12")});
        this.assertHyperlinks("bug#123 comment#12", new IHyperlink[]{this.link(0, 18, "123", "12")});
        this.assertHyperlinks("bug  123  comment#  12", new IHyperlink[]{this.link(0, 22, "123", "12")});
        this.assertHyperlinks("bug456comment#1", new IHyperlink[]{this.link(0, 15, "456", "1")});
    }

    public void testFindHyperlinksBugNoComment() {
        this.assertHyperlinks("bug 123#c1", new IHyperlink[]{this.link(0, 7, "123")});
        this.assertHyperlinks("bug 123#1", new IHyperlink[]{this.link(0, 7, "123")});
        this.assertHyperlinks("bug#123#c1", new IHyperlink[]{this.link(0, 7, "123")});
        this.assertHyperlinks("bug#123#1", new IHyperlink[]{this.link(0, 7, "123")});
    }

    public void testFindHyperlinksComment() {
        this.assertHyperlinks("comment#12", new IHyperlink[]{this.link(0, 10, "123", "12")});
        this.assertHyperlinks("comment  #12", new IHyperlink[]{this.link(0, 12, "123", "12")});
        this.assertHyperlinks("comment 1", new IHyperlink[]{this.link(0, 9, "123", "1")});
    }

    public void testFindHyperlinksInline() {
        this.assertHyperlinks("abc bug 123 def", new IHyperlink[]{this.link(4, 7, "123")});
    }

    public void testFindHyperlinksMultiple() {
        this.assertHyperlinks("bug 456#comment#12", new IHyperlink[]{this.link(0, 7, "456"), this.link(8, 10, "123", "12")});
        this.assertHyperlinks("bug 123             bug 456", new IHyperlink[]{this.link(0, 7, "123"), this.link(20, 7, "456")});
        this.assertHyperlinks("bug: 123             bug: 456", new IHyperlink[]{this.link(0, 8, "123"), this.link(21, 8, "456")});
    }

    public void testFindHyperlinksLinebreak() {
        this.assertHyperlinks("bug\n456", new IHyperlink[0]);
    }

    public void testFindHyperlinksNoAttachment() {
        this.assertHyperlinks("attachment", new IHyperlink[0]);
        this.assertHyperlinks("attachmen 123", new IHyperlink[0]);
        this.assertHyperlinks("attachment id", new IHyperlink[0]);
        this.assertHyperlinks("attachment id", new IHyperlink[0]);
    }

    public void testFindHyperlinksNoBug() {
        this.assertHyperlinks("bu 123", new IHyperlink[0]);
        this.assertHyperlinks("bu# 123", new IHyperlink[0]);
        this.assertHyperlinks("bug", new IHyperlink[0]);
        this.assertHyperlinks("bugcomment", new IHyperlink[0]);
        this.assertHyperlinks("bug#comment", new IHyperlink[0]);
    }

    public void testFindHyperlinksNoComment() {
        this.assertHyperlinks("c 12", new IHyperlink[0]);
        this.assertHyperlinks("#c12", new IHyperlink[0]);
        this.assertHyperlinks("comment", new IHyperlink[0]);
    }
}

