/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.CommonListenerList;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.storage.CommonStore;
import org.eclipse.mylyn.commons.core.storage.ICommonStorable;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.tasks.ui.ChangeActivityHandleOperation;
import org.eclipse.mylyn.internal.context.tasks.ui.ContextStatePersistenceHandler;
import org.eclipse.mylyn.internal.context.tasks.ui.TaskContextStoreEvent;
import org.eclipse.mylyn.internal.context.tasks.ui.TaskContextStoreListener;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.context.AbstractTaskContextStore;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;

public class TaskContextStore
extends AbstractTaskContextStore {
    private static final String FOLDER_DATA = "data";
    private final CommonListenerList<TaskContextStoreListener> listeners = new CommonListenerList("org.eclipse.mylyn.tasks.ui");
    private File directory;
    private CommonStore taskStore;
    private final ContextStatePersistenceHandler stateHandler = new ContextStatePersistenceHandler();

    public void addListener(TaskContextStoreListener listener) {
        this.listeners.add((Object)listener);
    }

    public void clearContext(ITask task) {
        ContextCorePlugin.getContextManager().deleteContext(task.getHandleIdentifier());
        this.stateHandler.clear(task);
        final TaskContextStoreEvent event = new TaskContextStoreEvent(TaskContextStoreEvent.Kind.CLEAR, task);
        this.listeners.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<TaskContextStoreListener>(){

            public void run(TaskContextStoreListener listener) throws Exception {
                listener.taskContextChanged(event);
            }
        });
    }

    public IAdaptable copyContext(ITask sourceTask, ITask targetTask) {
        IInteractionContext result = this.copyContextInternal(sourceTask, targetTask);
        this.stateHandler.copy(sourceTask, targetTask);
        final TaskContextStoreEvent event = new TaskContextStoreEvent(TaskContextStoreEvent.Kind.COPY, sourceTask, targetTask);
        this.listeners.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<TaskContextStoreListener>(){

            public void run(TaskContextStoreListener listener) throws Exception {
                listener.taskContextChanged(event);
            }
        });
        return this.asAdaptable(result);
    }

    public void deleteContext(ITask task) {
        block5: {
            ICommonStorable storable = this.getStorable(task);
            try {
                try {
                    storable.deleteAll();
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Unexpected error while deleting context state", (Throwable)e));
                    storable.release();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                storable.release();
                throw throwable;
            }
            storable.release();
        }
        ContextCorePlugin.getContextManager().deleteContext(task.getHandleIdentifier());
        this.stateHandler.clear(task);
        final TaskContextStoreEvent event = new TaskContextStoreEvent(TaskContextStoreEvent.Kind.DELETE, task);
        this.listeners.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<TaskContextStoreListener>(){

            public void run(TaskContextStoreListener listener) throws Exception {
                listener.taskContextChanged(event);
            }
        });
    }

    public File getFileForContext(ITask task) {
        return ContextCorePlugin.getContextStore().getFileForContext(task.getHandleIdentifier());
    }

    public ICommonStorable getStorable(ITask task) {
        return this.getTaskStore().get(this.getPath(task));
    }

    public boolean hasContext(ITask task) {
        return ContextCore.getContextStore().hasContext(task.getHandleIdentifier());
    }

    public void mergeContext(ITask sourceTask, ITask targetTask) {
        ContextCorePlugin.getContextStore().merge(sourceTask.getHandleIdentifier(), targetTask.getHandleIdentifier());
        this.stateHandler.merge(sourceTask, targetTask);
        final TaskContextStoreEvent event = new TaskContextStoreEvent(TaskContextStoreEvent.Kind.MERGE, sourceTask, targetTask);
        this.listeners.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<TaskContextStoreListener>(){

            public void run(TaskContextStoreListener listener) throws Exception {
                listener.taskContextChanged(event);
            }
        });
    }

    public IAdaptable moveContext(ITask sourceTask, ITask targetTask) {
        IInteractionContext result = this.copyContextInternal(sourceTask, targetTask);
        ChangeActivityHandleOperation operation = new ChangeActivityHandleOperation(sourceTask.getHandleIdentifier(), targetTask.getHandleIdentifier());
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Failed to migrate activity to new task", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.getTaskStore().move(this.getPath(sourceTask), this.getPath(targetTask));
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Failed to migrate context state to new task", (Throwable)e));
        }
        final TaskContextStoreEvent event = new TaskContextStoreEvent(TaskContextStoreEvent.Kind.MOVE, sourceTask, targetTask);
        this.listeners.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<TaskContextStoreListener>(){

            public void run(TaskContextStoreListener listener) throws Exception {
                listener.taskContextChanged(event);
            }
        });
        return this.asAdaptable(result);
    }

    public void refactorRepositoryUrl(TaskRepository repository, String oldRepositoryUrl, String newRepositoryUrl) {
        this.refactorMetaContextHandles(oldRepositoryUrl, newRepositoryUrl);
        this.refactorContextFileNames(oldRepositoryUrl, newRepositoryUrl);
        if (repository != null) {
            this.refactorRepositoryLocation(repository, oldRepositoryUrl, newRepositoryUrl);
        }
    }

    public void removeListener(TaskContextStoreListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void saveActiveContext() {
        ContextCorePlugin.getContextStore().saveActiveContext();
        ITask task = TasksUi.getTaskActivityManager().getActiveTask();
        if (task != null) {
            this.stateHandler.saved(task);
            final TaskContextStoreEvent event = new TaskContextStoreEvent(TaskContextStoreEvent.Kind.SAVE, task);
            this.listeners.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<TaskContextStoreListener>(){

                public void run(TaskContextStoreListener listener) throws Exception {
                    listener.taskContextChanged(event);
                }
            });
        }
    }

    public synchronized void setDirectory(File directory) {
        File contextDirectory;
        this.directory = directory;
        if (this.taskStore != null) {
            this.taskStore.setLocation(directory);
        }
        if (!(contextDirectory = new File(directory.getParent(), "contexts")).exists()) {
            contextDirectory.mkdirs();
        }
        ContextCorePlugin.getContextStore().setContextDirectory(contextDirectory);
    }

    private IAdaptable asAdaptable(final IInteractionContext result) {
        return new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter == IInteractionContext.class) {
                    return result;
                }
                return null;
            }
        };
    }

    private IInteractionContext copyContextInternal(ITask sourceTask, ITask targetTask) {
        ContextCorePlugin.getContextStore().saveActiveContext();
        IInteractionContext result = ContextCore.getContextStore().cloneContext(sourceTask.getHandleIdentifier(), targetTask.getHandleIdentifier());
        return result;
    }

    private IPath getPath(ITask task) {
        Path path = new Path("");
        path = path.append(String.valueOf(task.getConnectorKind()) + "-" + CoreUtil.asFileName((String)task.getRepositoryUrl()));
        path = path.append(FOLDER_DATA);
        path = path.append(CoreUtil.asFileName((String)task.getTaskId()));
        return path;
    }

    private synchronized CommonStore getTaskStore() {
        if (this.taskStore == null) {
            this.taskStore = new CommonStore(this.directory);
        }
        return this.taskStore;
    }

    private void refactorContextFileNames(String oldUrl, String newUrl) {
        File[] files;
        File dataDir = new File(TasksUiPlugin.getDefault().getDataDirectory(), "contexts");
        if (dataDir.exists() && dataDir.isDirectory() && (files = dataDir.listFiles()) != null) {
            File[] fileArray = dataDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                int dotIndex = file.getName().lastIndexOf(".xml");
                if (dotIndex != -1) {
                    try {
                        String storedUrl;
                        String storedHandle = URLDecoder.decode(file.getName().substring(0, dotIndex), "UTF-8");
                        int delimIndex = storedHandle.lastIndexOf("-");
                        if (delimIndex != -1 && oldUrl.equals(storedUrl = storedHandle.substring(0, delimIndex))) {
                            String id = RepositoryTaskHandleUtil.getTaskId((String)storedHandle);
                            String newHandle = RepositoryTaskHandleUtil.getHandle((String)newUrl, (String)id);
                            File newFile = ContextCorePlugin.getContextStore().getFileForContext(newHandle);
                            file.renameTo(newFile);
                        }
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not move context file: " + file.getName(), (Throwable)e));
                    }
                }
                ++n2;
            }
        }
    }

    private void refactorMetaContextHandles(String oldRepositoryUrl, String newRepositoryUrl) {
        InteractionContext metaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        ContextCorePlugin.getContextManager().resetActivityMetaContext();
        InteractionContext newMetaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        for (InteractionEvent event : metaContext.getInteractionHistory()) {
            String taskId;
            String storedUrl;
            if (event.getStructureHandle() != null && (storedUrl = RepositoryTaskHandleUtil.getRepositoryUrl((String)event.getStructureHandle())) != null && oldRepositoryUrl.equals(storedUrl) && (taskId = RepositoryTaskHandleUtil.getTaskId((String)event.getStructureHandle())) != null) {
                String newHandle = RepositoryTaskHandleUtil.getHandle((String)newRepositoryUrl, (String)taskId);
                event = new InteractionEvent(event.getKind(), event.getStructureKind(), newHandle, event.getOriginId(), event.getNavigation(), event.getDelta(), event.getInterestContribution(), event.getDate(), event.getEndDate());
            }
            newMetaContext.parseEvent(event);
        }
    }

    private void refactorRepositoryLocation(TaskRepository repository, String oldRepositoryUrl, String newRepositoryUrl) {
        IPath oldPath = new Path(String.valueOf(repository.getConnectorKind()) + "-" + CoreUtil.asFileName((String)oldRepositoryUrl)).append(FOLDER_DATA);
        IPath newPath = new Path(String.valueOf(repository.getConnectorKind()) + "-" + CoreUtil.asFileName((String)newRepositoryUrl)).append(FOLDER_DATA);
        try {
            this.getTaskStore().move(oldPath, newPath);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Failed to migrate data store for repository {0}", (Object)newRepositoryUrl), (Throwable)e));
        }
    }

    public ContextStatePersistenceHandler getStateHandler() {
        return this.stateHandler;
    }
}

