/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.egit;

import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.Project;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.clone.GitCloneWizard;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositorySearchResult;
import org.eclipse.egit.ui.internal.provisional.wizards.NoRepositoryInfoException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Shell;

public class EGitUiUtil {
    public static RevCommit getRevCommit(Repository repository, PatchSet target) throws AmbiguousObjectException, IOException, MissingObjectException, IncorrectObjectTypeException {
        ObjectId ref = repository.resolve(target.getRevision().get());
        RevWalk walker = new RevWalk(repository);
        RevCommit targetCommit = walker.parseCommit((AnyObjectId)ref);
        return targetCommit;
    }

    private static RevCommit fetchRefSpec(IProgressMonitor monitor, Repository repository, RemoteConfig remote, RefSpec refSpec) throws URISyntaxException, CoreException, MissingObjectException, IncorrectObjectTypeException, IOException {
        List<RefSpec> refSpecs = Collections.singletonList(refSpec);
        FetchOperationUI op = new FetchOperationUI(repository, (URIish)remote.getURIs().get(0), refSpecs, Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"), false);
        op.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        FetchResult result = op.execute(monitor);
        ObjectId resultRef = result.getAdvertisedRef(refSpec.getSource()).getObjectId();
        return new RevWalk(repository).parseCommit((AnyObjectId)resultRef);
    }

    public static RevCommit fetchPatchSet(IProgressMonitor monitor, Repository repository, RemoteConfig remote, PatchSet patchSet) throws IOException, CoreException, URISyntaxException {
        try {
            return EGitUiUtil.getRevCommit(repository, patchSet);
        }
        catch (MissingObjectException missingObjectException) {
            RefSpec refSpec = new RefSpec(String.valueOf(patchSet.getRefName()) + ":FETCH_HEAD");
            return EGitUiUtil.fetchRefSpec(monitor, repository, remote, refSpec);
        }
    }

    public static int openCloneRepositoryWizard(Shell shell, final TaskRepository repository, final Project project) {
        GitCloneWizard cloneWizard = new GitCloneWizard(new IRepositorySearchResult(){

            public GitRepositoryInfo getGitRepositoryInfo() throws NoRepositoryInfoException {
                GitRepositoryInfo gitRepositoryInfo;
                try {
                    GerritConfiguration config = GerritCorePlugin.getGerritClient((TaskRepository)repository).getConfiguration();
                    gitRepositoryInfo = new GitRepositoryInfo(GerritUtil.getSshCloneUri((TaskRepository)repository, (GerritConfiguration)config, (Project)project));
                }
                catch (URISyntaxException e) {
                    throw new NoRepositoryInfoException(e.getMessage(), (Throwable)e);
                }
                return gitRepositoryInfo;
            }
        });
        WizardDialog dlg = new WizardDialog(shell, (IWizard)cloneWizard);
        dlg.setHelpAvailable(true);
        return dlg.open();
    }
}

