/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import java.io.IOException;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.HtmlTextPresentationParser;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.tests.HeadRequired;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.xml.sax.SAXException;

@HeadRequired
public class HtmlTextPresentationParserTest
extends TestCase {
    private HtmlTextPresentationParser parser;

    public void setUp() {
        this.parser = new HtmlTextPresentationParser();
        this.parser.setPresentation(new TextPresentation());
        this.parser.setDefaultFont(new Font(null, new FontData[]{new FontData("fake", 12, 0)}));
    }

    public void testAdjacentElementsSeparatedByWhitespace() throws Exception {
        this.parser.parse("<html><body><p><strong>one</strong> <em>two</em></p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("one two"));
    }

    public void testSignificantWhitespaceLossBug236367() throws SAXException, IOException {
        String html = new MarkupParser((MarkupLanguage)new TextileLanguage()).parseToHtml("one *two* three *four* five *six* seven");
        TestUtil.println("HTML: " + html);
        this.parser.parse(html);
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("one two three four five six seven"));
    }

    public void testOrderedListBlockHandling() throws Exception {
        this.parser.parse("<html><body><ol><li> one </li><li>    two </li></ol></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("\t1. one\n\t2. two"));
    }

    public void testOrderedListBlockHandling2() throws Exception {
        this.parser.parse("<html><body><ol><li> <b>one</b> </li><li>    two </li></ol></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("\t1. one\n\t2. two"));
    }

    public void testUnorderedListBlockHandling() throws Exception {
        this.parser.setBulletChars(new char[]{'A', 'B', 'C'});
        this.parser.parse("<html><body><ul><li> one</li><li>    two<ul><li>two.one</li></ul></li></ul></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("\tA  one\n\tA  two\n\t\tB  two.one"));
    }

    public void testParagraphBlockHandling() throws Exception {
        this.parser.parse("<html><body><p>first para\n\nwith some newlines</p>\n\n<p>second para</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("first para with some newlines\n\nsecond para"));
    }

    public void testParagraphBlockHandlingWithBR() throws Exception {
        this.parser.parse("<html><body><p>first para<br/>\nwith one newline plus br</p>\n\n<p>second para</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("first para\nwith one newline plus br\n\nsecond para"));
    }

    public void testParagraphBlockHandlingWithBR2() throws Exception {
        this.parser.parse("<html><body><p>first para<br/>with one newline plus br</p>\n\n<p>second para</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text: '" + text + "'");
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("first para\nwith one newline plus br\n\nsecond para"));
    }

    public void testDefinitionList() throws Exception {
        this.parser.parse("<html><body><dl><dt>foo</dt><dd>bar baz</dd></dl></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text + "'");
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("foo\n\tbar baz"));
    }

    public void testNonParaText() throws Exception {
        this.parser.parse("<html><body><p>one</p>two<p>three</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("one\n\ntwo\n\nthree"));
    }

    public void testBlockQuoteParaWhitespace() throws Exception {
        this.parser.parse("<html><body><p>one</p><blockquote><p>two</p></blockquote><p>three</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("one\n\n\ttwo\n\nthree"));
    }

    public void testBR() throws Exception {
        this.parser.parse("<html><head></head><body><p>One<br/>Two</p></body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("One\nTwo"));
    }

    public void testWhitespaceAfterTable() throws Exception {
        this.parser.parse("<html><head></head><body>before<table><tr><td>in1</td></tr><tr><td>in2</td></tr></table>after</body></html>");
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        HtmlTextPresentationParserTest.assertTrue((boolean)text.contains("in1 \t\nin2 \t\n\nafter"));
    }

    public void testWhitespaceAfterEmdash() throws Exception {
        String html = "<html><body><p>Foo<br/>Bar &#8212; baz</p></body></html>";
        this.parser.parse(html);
        String text = this.parser.getText();
        TestUtil.println("text:\n" + text);
        HtmlTextPresentationParserTest.assertTrue((boolean)Pattern.compile("Bar\\s\\S\\sbaz", 8).matcher(text).find());
    }
}

