/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup;

import com.google.common.collect.Sets;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MarkupLanguageTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final MarkupLanguage markupLanguage = new TestMarkupLanguage();

    @Test
    public void getFileExtensionsDefault() {
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{this.markupLanguage.getName()}), (Object)this.markupLanguage.getFileExtensions());
    }

    @Test
    public void setFileExtensionsNull() {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("Must specify file extensions");
        this.markupLanguage.setFileExtensions(null);
    }

    @Test
    public void setFileExtensionsEmpty() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("File extensions must not be empty");
        this.markupLanguage.setFileExtensions(Collections.emptySet());
    }

    @Test
    public void getFileExtensionsSpecified() {
        this.markupLanguage.setFileExtensions((Set)Sets.newHashSet((Object[])new String[]{this.markupLanguage.getName(), "123"}));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{this.markupLanguage.getName(), "123"}), (Object)this.markupLanguage.getFileExtensions());
    }

    @Test
    public void documentBuilderUnsupported() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.markupLanguage.createDocumentBuilder((Writer)new StringWriter());
    }

    private final class TestMarkupLanguage
    extends MarkupLanguage {
        public TestMarkupLanguage() {
            this.setName("TestLanguage");
        }

        public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
            throw new UnsupportedOperationException();
        }
    }
}

