/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.trac.core.Messages;
import org.eclipse.mylyn.internal.trac.core.TracAttachmentHandler;
import org.eclipse.mylyn.internal.trac.core.TracAttribute;
import org.eclipse.mylyn.internal.trac.core.TracClientManager;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracTaskDataHandler;
import org.eclipse.mylyn.internal.trac.core.TracTaskMapper;
import org.eclipse.mylyn.internal.trac.core.TracWikiHandler;
import org.eclipse.mylyn.internal.trac.core.client.AbstractWikiHandler;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.ITracWikiClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.model.TracComment;
import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskHistory;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.data.TaskRevision;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

public class TracRepositoryConnector
extends AbstractRepositoryConnector {
    private static final Date DEFAULT_COMPLETION_DATE = new Date(0L);
    private static int TASK_PRIORITY_LEVELS = 5;
    public static final String TASK_KEY_SUPPORTS_SUBTASKS = "SupportsSubtasks";
    public static final String TASK_KEY_UPDATE_DATE = "UpdateDate";
    private final TracAttachmentHandler attachmentHandler = new TracAttachmentHandler(this);
    private TracClientManager clientManager;
    private File repositoryConfigurationCacheFile;
    private final TracTaskDataHandler taskDataHandler = new TracTaskDataHandler(this);
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory = new TaskRepositoryLocationFactory();
    private final TracWikiHandler wikiHandler = new TracWikiHandler(this);

    public static String getDisplayUsername(TaskRepository repository) {
        AuthenticationCredentials credentials = repository.getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null && credentials.getUserName().length() > 0) {
            return "anonymous";
        }
        return repository.getUserName();
    }

    public static ITask.PriorityLevel getTaskPriority(String tracPriority) {
        TracPriorityLevel priority;
        if (tracPriority != null && (priority = TracPriorityLevel.fromPriority(tracPriority)) != null) {
            return priority.toPriorityLevel();
        }
        return ITask.PriorityLevel.getDefault();
    }

    public static ITask.PriorityLevel getTaskPriority(String priority, TracPriority[] tracPriorities) {
        if (priority != null && tracPriorities != null && tracPriorities.length > 0) {
            int minValue = tracPriorities[0].getValue();
            int range = tracPriorities[tracPriorities.length - 1].getValue() - minValue;
            TracPriority[] tracPriorityArray = tracPriorities;
            int n = tracPriorities.length;
            int n2 = 0;
            while (n2 < n) {
                TracPriority tracPriority = tracPriorityArray[n2];
                if (priority.equals(tracPriority.getName())) {
                    float relativeValue = (float)(tracPriority.getValue() - minValue) / (float)range;
                    int value = (int)(relativeValue * (float)TASK_PRIORITY_LEVELS) + 1;
                    return ITask.PriorityLevel.fromLevel((int)value);
                }
                ++n2;
            }
        }
        return TracRepositoryConnector.getTaskPriority(priority);
    }

    public static int getTicketId(String taskId) throws CoreException {
        try {
            return Integer.parseInt(taskId);
        }
        catch (NumberFormatException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.trac.core", 0, "Invalid ticket id: " + taskId, (Throwable)e));
        }
    }

    static List<String> getAttributeValues(TaskData data, String attributeId) {
        TaskAttribute attribute = data.getRoot().getMappedAttribute(attributeId);
        if (attribute != null) {
            return attribute.getValues();
        }
        return Collections.emptyList();
    }

    static String getAttributeValue(TaskData data, String attributeId) {
        TaskAttribute attribute = data.getRoot().getMappedAttribute(attributeId);
        if (attribute != null) {
            return attribute.getValue();
        }
        return "";
    }

    public static boolean hasAttachmentSupport(TaskRepository repository, ITask task) {
        return ITracClient.Version.XML_RPC.name().equals(repository.getVersion());
    }

    public static boolean hasChangedSince(TaskRepository repository) {
        return ITracClient.Version.XML_RPC.name().equals(repository.getVersion());
    }

    public static boolean hasRichEditor(TaskRepository repository) {
        return ITracClient.Version.XML_RPC.name().equals(repository.getVersion());
    }

    public static boolean hasRichEditor(TaskRepository repository, ITask task) {
        return TracRepositoryConnector.hasRichEditor(repository);
    }

    public static boolean isCompleted(String tracStatus) {
        TaskStatus taskStatus = TaskStatus.fromStatus(tracStatus);
        return taskStatus == TaskStatus.CLOSED;
    }

    public TracRepositoryConnector() {
        if (TracCorePlugin.getDefault() != null) {
            TracCorePlugin.getDefault().setConnector(this);
            IPath path = TracCorePlugin.getDefault().getRepostioryAttributeCachePath();
            this.repositoryConfigurationCacheFile = path.toFile();
        }
    }

    public TracRepositoryConnector(File repositoryConfigurationCacheFile) {
        this.repositoryConfigurationCacheFile = repositoryConfigurationCacheFile;
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public boolean canSynchronizeTask(TaskRepository taskRepository, ITask task) {
        return TracRepositoryConnector.hasRichEditor(taskRepository, task);
    }

    public TracAttachmentHandler getTaskAttachmentHandler() {
        return this.attachmentHandler;
    }

    public synchronized TracClientManager getClientManager() {
        if (this.clientManager == null) {
            this.clientManager = new TracClientManager(this.repositoryConfigurationCacheFile, this.taskRepositoryLocationFactory);
        }
        return this.clientManager;
    }

    public String getConnectorKind() {
        return "trac";
    }

    public String getLabel() {
        return Messages.TracRepositoryConnector_Trac_Client_Label;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        return this.taskDataHandler.getTaskData(repository, taskId, monitor);
    }

    public TracTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.lastIndexOf("/ticket/");
        return index == -1 ? null : url.substring(0, index);
    }

    public String getTaskIdFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.lastIndexOf("/ticket/");
        return index == -1 ? null : url.substring(index + "/ticket/".length());
    }

    public String getTaskIdPrefix() {
        return "#";
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        return String.valueOf(repositoryUrl) + "/ticket/" + taskId;
    }

    public AbstractWikiHandler getWikiHandler() {
        return this.wikiHandler;
    }

    public boolean hasWiki(TaskRepository repository) {
        ITracClient client = this.getClientManager().getTracClient(repository);
        return client instanceof ITracWikiClient;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector resultCollector, ISynchronizationSession session, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.TracRepositoryConnector_Querying_repository, -1);
            TracSearch search = TracUtil.toTracSearch(query);
            if (search == null) {
                RepositoryStatus repositoryStatus = new RepositoryStatus(repository.getRepositoryUrl(), 4, "org.eclipse.mylyn.trac.core", 1, "The query is invalid: \"" + query.getUrl() + "\"");
                return repositoryStatus;
            }
            search.setMax(5000);
            try {
                HashMap<String, ITask> taskById = null;
                ITracClient client = this.getClientManager().getTracClient(repository);
                client.updateAttributes(monitor, false);
                if (session != null && session.isFullSynchronization() && TracRepositoryConnector.hasRichEditor(repository) && !session.getTasks().isEmpty()) {
                    ArrayList<Integer> ticketIds = new ArrayList<Integer>();
                    client.searchForTicketIds(search, ticketIds, monitor);
                    for (Integer id : ticketIds) {
                        if (taskById == null) {
                            taskById = new HashMap<String, ITask>();
                            for (ITask task : session.getTasks()) {
                                taskById.put(task.getTaskId(), task);
                            }
                        }
                        TaskData taskData = new TaskData(this.taskDataHandler.getAttributeMapper(repository), "trac", repository.getRepositoryUrl(), "" + id);
                        taskData.setPartial(true);
                        TaskAttribute attribute = TracTaskDataHandler.createAttribute(taskData, TracAttribute.ID);
                        attribute.setValue("" + id);
                        resultCollector.accept(taskData);
                    }
                } else {
                    ArrayList<TracTicket> tickets = new ArrayList<TracTicket>();
                    client.search(search, tickets, monitor);
                    for (TracTicket ticket : tickets) {
                        TaskData taskData = this.taskDataHandler.createTaskDataFromTicket(client, repository, ticket, monitor);
                        taskData.setPartial(true);
                        if (session != null && !session.isFullSynchronization() && TracRepositoryConnector.hasRichEditor(repository)) {
                            ITask task2;
                            if (taskById == null) {
                                taskById = new HashMap();
                                for (ITask task2 : session.getTasks()) {
                                    taskById.put(task2.getTaskId(), task2);
                                }
                            }
                            if ((task2 = (ITask)taskById.get(String.valueOf(ticket.getId()))) != null && this.hasTaskChanged(repository, task2, taskData)) {
                                session.markStale(task2);
                            }
                        }
                        resultCollector.accept(taskData);
                    }
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                IStatus iStatus = TracCorePlugin.toStatus(e, repository);
                monitor.done();
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public void postSynchronization(ISynchronizationSession event, IProgressMonitor monitor) throws CoreException {
        try {
            Date date;
            monitor.beginTask("", 1);
            if (event.isFullSynchronization() && event.getStatus() == null && (date = this.getSynchronizationTimestamp(event)) != null) {
                event.getTaskRepository().setSynchronizationTimeStamp(String.valueOf(TracUtil.toTracTime(date)));
            }
        }
        finally {
            monitor.done();
        }
    }

    private Date getSynchronizationTimestamp(ISynchronizationSession event) {
        Date mostRecent = new Date(0L);
        Date mostRecentTimeStamp = TracUtil.parseDate(event.getTaskRepository().getSynchronizationTimeStamp());
        for (ITask task : event.getChangedTasks()) {
            Date taskModifiedDate = task.getModificationDate();
            if (taskModifiedDate == null || !taskModifiedDate.after(mostRecent)) continue;
            mostRecent = taskModifiedDate;
            mostRecentTimeStamp = task.getModificationDate();
        }
        return mostRecentTimeStamp;
    }

    public void preSynchronization(ISynchronizationSession session, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            Integer id;
            Date lastChanged;
            Set<Integer> ids;
            ITracClient client;
            Date since;
            TaskRepository repository;
            block22: {
                monitor.beginTask(Messages.TracRepositoryConnector_Getting_changed_tasks, -1);
                if (!session.isFullSynchronization()) {
                    return;
                }
                if (session.getTasks().isEmpty()) {
                    return;
                }
                repository = session.getTaskRepository();
                if (!TracRepositoryConnector.hasChangedSince(repository)) {
                    return;
                }
                if (repository.getSynchronizationTimeStamp() == null || repository.getSynchronizationTimeStamp().length() == 0) {
                    for (ITask task : session.getTasks()) {
                        session.markStale(task);
                    }
                    return;
                }
                since = new Date(0L);
                try {
                    since = TracUtil.parseDate(Integer.parseInt(repository.getSynchronizationTimeStamp()));
                }
                catch (NumberFormatException numberFormatException) {}
                client = this.getClientManager().getTracClient(repository);
                ids = client.getChangedTickets(since, monitor);
                if (!ids.isEmpty()) break block22;
                session.setNeedsPerformQueries(false);
                return;
            }
            if (ids.size() == 1 && since.equals(lastChanged = client.getTicketLastChanged(id = ids.iterator().next(), monitor))) {
                session.setNeedsPerformQueries(false);
                return;
            }
            try {
                for (ITask task : session.getTasks()) {
                    Integer id2 = TracRepositoryConnector.getTicketId(task.getTaskId());
                    if (!ids.contains(id2)) continue;
                    session.markStale(task);
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException(TracCorePlugin.toStatus(e, repository));
            }
        }
        finally {
            monitor.done();
        }
    }

    public synchronized void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
        if (this.clientManager != null) {
            this.clientManager.setTaskRepositoryLocationFactory(taskRepositoryLocationFactory);
        }
    }

    public void stop() {
        if (this.clientManager != null) {
            this.clientManager.writeCache();
        }
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            ITracClient client = this.getClientManager().getTracClient(repository);
            client.updateAttributes(monitor, true);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TracTaskMapper mapper = this.getTaskMapping(taskData);
        mapper.applyTo(task);
        String status = mapper.getStatus();
        if (status != null) {
            if (TracRepositoryConnector.isCompleted(mapper.getStatus())) {
                Date modificationDate = mapper.getModificationDate();
                if (modificationDate == null) {
                    modificationDate = DEFAULT_COMPLETION_DATE;
                }
                task.setCompletionDate(modificationDate);
            } else {
                task.setCompletionDate(null);
            }
        }
        task.setUrl(String.valueOf(taskRepository.getRepositoryUrl()) + "/ticket/" + taskData.getTaskId());
        if (!taskData.isPartial()) {
            task.setAttribute(TASK_KEY_SUPPORTS_SUBTASKS, Boolean.toString(this.taskDataHandler.supportsSubtasks(taskData)));
            Date date = task.getModificationDate();
            task.setAttribute(TASK_KEY_UPDATE_DATE, date != null ? String.valueOf(TracUtil.toTracTime(date)) : null);
        }
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TracTaskMapper mapper = this.getTaskMapping(taskData);
        if (taskData.isPartial()) {
            return mapper.hasChanges(task);
        }
        Date repositoryDate = mapper.getModificationDate();
        Date localDate = TracUtil.parseDate(task.getAttribute(TASK_KEY_UPDATE_DATE));
        return repositoryDate == null || !repositoryDate.equals(localDate);
    }

    public Collection<TaskRelation> getTaskRelations(TaskData taskData) {
        TaskAttribute attribute = taskData.getRoot().getAttribute("blockedby");
        if (attribute != null) {
            ArrayList<TaskRelation> result = new ArrayList<TaskRelation>();
            StringTokenizer t = new StringTokenizer(attribute.getValue(), ", ");
            while (t.hasMoreTokens()) {
                result.add(TaskRelation.subtask((String)t.nextToken()));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public TracTaskMapper getTaskMapping(TaskData taskData) {
        TaskRepository taskRepository = taskData.getAttributeMapper().getTaskRepository();
        ITracClient client = taskRepository != null ? this.getClientManager().getTracClient(taskRepository) : null;
        return new TracTaskMapper(taskData, client);
    }

    public boolean canGetTaskHistory(TaskRepository repository, ITask task) {
        return ITracClient.Version.XML_RPC.name().equals(repository.getVersion());
    }

    public TaskHistory getTaskHistory(TaskRepository repository, ITask task, IProgressMonitor monitor) throws CoreException {
        try {
            ITracClient client = this.getClientManager().getTracClient(repository);
            List<TracComment> comments = client.getComments(TracRepositoryConnector.getTicketId(task.getTaskId()), monitor);
            TaskHistory history = new TaskHistory(repository, task);
            TaskRevision revision = null;
            for (TracComment comment : comments) {
                TracAttribute attribute;
                String id = String.valueOf(comment.getCreated().getTime());
                if (revision == null || !id.equals(revision.getId())) {
                    revision = new TaskRevision(id, comment.getCreated(), repository.createPerson(comment.getAuthor()));
                    history.add(revision);
                }
                if ((attribute = TracAttribute.getByTracKey(comment.getField())) == null) continue;
                String fieldName = attribute.toString();
                if (fieldName.endsWith(":")) {
                    fieldName = fieldName.substring(0, fieldName.length() - 1);
                }
                TaskRevision.Change change = new TaskRevision.Change(attribute.getTracKey(), fieldName, comment.getOldValue(), comment.getNewValue());
                revision.add(change);
            }
            return history;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
    }

    public boolean canDeleteTask(TaskRepository repository, ITask task) {
        return TracRepositoryConnector.hasRichEditor(repository);
    }

    public IStatus deleteTask(TaskRepository repository, ITask task, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        ITracClient client = this.getClientManager().getTracClient(repository);
        try {
            client.deleteTicket(TracRepositoryConnector.getTicketId(task.getTaskId()), monitor);
        }
        catch (TracException e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
        return Status.OK_STATUS;
    }

    public static enum TaskKind {
        DEFECT,
        ENHANCEMENT,
        TASK,
        STORY;


        public static TaskKind fromString(String type) {
            if (type == null) {
                return null;
            }
            if (type.equals("Defect")) {
                return DEFECT;
            }
            if (type.equals("Enhancement")) {
                return ENHANCEMENT;
            }
            if (type.equals("Task")) {
                return TASK;
            }
            if (type.equals("Story")) {
                return STORY;
            }
            return null;
        }

        public static TaskKind fromType(String type) {
            if (type == null) {
                return null;
            }
            if (type.equals("defect") || type.equals("error")) {
                return DEFECT;
            }
            if (type.equals("enhancement")) {
                return ENHANCEMENT;
            }
            if (type.equals("task")) {
                return TASK;
            }
            if (type.equals("story")) {
                return STORY;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case DEFECT: {
                    return "Defect";
                }
                case ENHANCEMENT: {
                    return "Enhancement";
                }
                case TASK: {
                    return "Task";
                }
                case STORY: {
                    return "Story";
                }
            }
            return "";
        }
    }

    public static enum TaskStatus {
        ASSIGNED,
        CLOSED,
        NEW,
        REOPENED;


        public static TaskStatus fromStatus(String status) {
            if (status == null) {
                return null;
            }
            if (status.equals("new")) {
                return NEW;
            }
            if (status.equals("assigned")) {
                return ASSIGNED;
            }
            if (status.equals("reopened")) {
                return REOPENED;
            }
            if (status.equals("closed")) {
                return CLOSED;
            }
            return null;
        }

        public String toStatusString() {
            switch (this) {
                case NEW: {
                    return "new";
                }
                case ASSIGNED: {
                    return "assigned";
                }
                case REOPENED: {
                    return "reopened";
                }
                case CLOSED: {
                    return "closed";
                }
            }
            return "";
        }

        public String toString() {
            switch (this) {
                case NEW: {
                    return "New";
                }
                case ASSIGNED: {
                    return "Assigned";
                }
                case REOPENED: {
                    return "Reopened";
                }
                case CLOSED: {
                    return "Closed";
                }
            }
            return "";
        }
    }

    public static enum TracPriorityLevel {
        BLOCKER,
        CRITICAL,
        MAJOR,
        MINOR,
        TRIVIAL;


        public static TracPriorityLevel fromPriority(String priority) {
            if (priority == null) {
                return null;
            }
            if (priority.equals("blocker")) {
                return BLOCKER;
            }
            if (priority.equals("critical")) {
                return CRITICAL;
            }
            if (priority.equals("major")) {
                return MAJOR;
            }
            if (priority.equals("minor")) {
                return MINOR;
            }
            if (priority.equals("trivial")) {
                return TRIVIAL;
            }
            return null;
        }

        public ITask.PriorityLevel toPriorityLevel() {
            switch (this) {
                case BLOCKER: {
                    return ITask.PriorityLevel.P1;
                }
                case CRITICAL: {
                    return ITask.PriorityLevel.P2;
                }
                case MAJOR: {
                    return ITask.PriorityLevel.P3;
                }
                case MINOR: {
                    return ITask.PriorityLevel.P4;
                }
                case TRIVIAL: {
                    return ITask.PriorityLevel.P5;
                }
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case BLOCKER: {
                    return "blocker";
                }
                case CRITICAL: {
                    return "critical";
                }
                case MAJOR: {
                    return "major";
                }
                case MINOR: {
                    return "minor";
                }
                case TRIVIAL: {
                    return "trivial";
                }
            }
            return null;
        }
    }
}

