/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.AcronymEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.BeginBlockEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.BeginDocumentEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.BeginHeadingEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.BeginSpanEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.CharactersEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.CharactersUnescapedEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.DocumentBuilderEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.DocumentBuilderEvents;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.EndBlockEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.EndDocumentEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.EndHeadingEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.EndSpanEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.EntityReferenceEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.ImageEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.ImageLinkEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.LineBreakEvent;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.LinkEvent;

public class EventDocumentBuilder
extends DocumentBuilder {
    private final List<DocumentBuilderEvent> events = Lists.newArrayList();

    public DocumentBuilderEvents getDocumentBuilderEvents() {
        return new DocumentBuilderEvents(this.events);
    }

    @Override
    public void beginDocument() {
        this.events.add(new BeginDocumentEvent());
    }

    @Override
    public void endDocument() {
        this.events.add(new EndDocumentEvent());
    }

    @Override
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        this.events.add(new BeginBlockEvent(type, attributes));
    }

    @Override
    public void endBlock() {
        this.events.add(new EndBlockEvent());
    }

    @Override
    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.events.add(new BeginSpanEvent(type, attributes));
    }

    @Override
    public void endSpan() {
        this.events.add(new EndSpanEvent());
    }

    @Override
    public void beginHeading(int level, Attributes attributes) {
        this.events.add(new BeginHeadingEvent(level, attributes));
    }

    @Override
    public void endHeading() {
        this.events.add(new EndHeadingEvent());
    }

    @Override
    public void characters(String text) {
        this.events.add(new CharactersEvent(text));
    }

    @Override
    public void entityReference(String entity) {
        this.events.add(new EntityReferenceEvent(entity));
    }

    @Override
    public void image(Attributes attributes, String url) {
        this.events.add(new ImageEvent(attributes, url));
    }

    @Override
    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.events.add(new LinkEvent(attributes, hrefOrHashName, text));
    }

    @Override
    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.events.add(new ImageLinkEvent(linkAttributes, imageAttributes, href, imageUrl));
    }

    @Override
    public void acronym(String text, String definition) {
        this.events.add(new AcronymEvent(text, definition));
    }

    @Override
    public void lineBreak() {
        this.events.add(new LineBreakEvent());
    }

    @Override
    public void charactersUnescaped(String literal) {
        this.events.add(new CharactersUnescapedEvent(literal));
    }
}

