/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.model;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.gerrit.dashboard.core.GerritTask;
import org.eclipse.mylyn.gerrit.dashboard.ui.GerritUi;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.commands.table.AdjustMyStarredHandler;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.model.ReviewTableContentProvider;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.model.ReviewTableDefinition;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.model.ReviewTableLabelProvider;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.model.ReviewTableSorter;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.tasks.core.IAttributeContainer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class UIReviewTable {
    private final int TABLE_STYLE = 66304;
    private TableViewer fViewer;
    private final Listener mouseButtonListener = new Listener(){

        public void handleEvent(Event aEvent) {
            GerritUi.Ftracer.traceInfo("mouseButtonListener() for " + aEvent.button);
            switch (aEvent.type) {
                case 3: {
                    if (aEvent.button == 1) {
                        UIReviewTable.this.processItemSelection();
                    }
                    if (aEvent.button == 2) {
                        Table table = UIReviewTable.this.fViewer.getTable();
                        table.deselectAll();
                        Point p = new Point(aEvent.x, aEvent.y);
                        TableItem tbi = UIReviewTable.this.fViewer.getTable().getItem(p);
                        if (tbi != null) {
                            table.setSelection(tbi);
                        }
                        AdjustMyStarredHandler handler = new AdjustMyStarredHandler();
                        try {
                            handler.execute(new ExecutionEvent());
                        }
                        catch (ExecutionException excutionException) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", excutionException.getMessage(), (Throwable)excutionException));
                        }
                    }
                    int cfr_ignored_0 = aEvent.button;
                    break;
                }
            }
        }
    };

    public TableViewer createTableViewerSection(Composite aParent) {
        Composite viewerForm = UIUtils.createsGeneralComposite(aParent, 2064);
        GridData gribDataViewer = new GridData(1808);
        viewerForm.setLayoutData((Object)gribDataViewer);
        GridLayout layout = new GridLayout();
        layout.numColumns = ReviewTableDefinition.values().length;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        viewerForm.setLayout((Layout)layout);
        this.fViewer = new TableViewer(viewerForm, 66304);
        this.fViewer = this.buildAndLayoutTable(this.fViewer);
        this.fViewer.setContentProvider((IContentProvider)new ReviewTableContentProvider());
        ReviewTableLabelProvider tableProvider = new ReviewTableLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)tableProvider);
        ReviewTableSorter.bind(this.fViewer);
        this.fViewer.setComparator((ViewerComparator)new ReviewTableSorter(6));
        this.fViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GerritUi.Ftracer.traceInfo("Table selection: " + e.toString());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fViewer.getTable().addListener(3, this.mouseButtonListener);
        return this.fViewer;
    }

    private TableViewer buildAndLayoutTable(TableViewer aViewer) {
        final Table table = aViewer.getTable();
        ReviewTableDefinition[] tableInfo = ReviewTableDefinition.values();
        int size = tableInfo.length;
        GerritUi.Ftracer.traceInfo("Table\tName\tWidth\tResize Moveable");
        int index = 0;
        while (index < size) {
            GerritUi.Ftracer.traceInfo("index [ " + index + " ] " + tableInfo[index].getName() + "\t: " + tableInfo[index].getWidth() + "\t: " + tableInfo[index].getResize() + "\t: " + tableInfo[index].getMoveable());
            TableViewerColumn col = this.createTableViewerColumn(tableInfo[index]);
            GridData gribData = new GridData(1808);
            gribData.minimumWidth = tableInfo[index].getWidth();
            col.getColumn().getParent().setLayoutData((Object)gribData);
            ++index;
        }
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                table.setRedraw(false);
                Point tableSize = table.getSize();
                Point parentSize = table.getParent().getSize();
                int minimumTableWidth = ReviewTableDefinition.getMinimumWidth();
                int mimimumSubjectWidth = ReviewTableDefinition.SUBJECT.getWidth();
                int minProjectWidth = ReviewTableDefinition.PROJECT.getWidth();
                int scrollWidth = table.getVerticalBar().getSize().x;
                if (!table.getVerticalBar().isVisible()) {
                    scrollWidth = 0;
                }
                int computeExtraWidth = parentSize.x - 10 - minimumTableWidth - scrollWidth;
                int newSubjectWidth = mimimumSubjectWidth;
                int newProjectWidth = minProjectWidth;
                if (computeExtraWidth > 0) {
                    int value = 2 * computeExtraWidth / 3;
                    newSubjectWidth = mimimumSubjectWidth + value;
                    newProjectWidth = minProjectWidth + computeExtraWidth - value;
                }
                table.getColumn(2).setWidth(newSubjectWidth);
                table.getColumn(4).setWidth(newProjectWidth);
                table.setSize(parentSize.x - 10, tableSize.y);
                table.setRedraw(true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return aViewer;
    }

    private TableViewerColumn createTableViewerColumn(ReviewTableDefinition aTableInfo) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(aTableInfo.getName());
        column.setWidth(aTableInfo.getWidth());
        column.setAlignment(aTableInfo.getAlignment());
        column.setResizable(aTableInfo.getResize());
        column.setMoveable(aTableInfo.getMoveable());
        return viewerColumn;
    }

    private void processItemSelection() {
        Object obj;
        ISelection tableSelection = this.fViewer.getSelection();
        if (!tableSelection.isEmpty() && tableSelection instanceof IStructuredSelection && (obj = ((IStructuredSelection)tableSelection).getFirstElement()) instanceof GerritTask) {
            IAttributeContainer item = (IAttributeContainer)obj;
            GerritUi.Ftracer.traceInfo("Selected table OBJECT selection ID: " + item.getAttribute("task.common.key") + "\t subject: " + item.getAttribute("task.common.summary"));
        }
    }
}

