/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.client;

import java.net.InetSocketAddress;
import java.net.Proxy;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.IProxyProvider;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.internal.trac.core.TracClientFactory;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.trac.tests.support.TestProxy;

public class TracClientProxyTest
extends TestCase {
    private TestProxy testProxy;
    private Proxy proxy;
    private int proxyPort;
    private ITracClient.Version version;

    protected void setUp() throws Exception {
        super.setUp();
        this.testProxy = new TestProxy();
        this.proxyPort = this.testProxy.startAndWait();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.testProxy.stop();
    }

    public void testConnectProxyWeb() throws Exception {
        this.version = ITracClient.Version.TRAC_0_9;
        this.connectProxy("http://mylyn.org/trac", "GET");
    }

    public void testConnectProxyXmlRpc() throws Exception {
        this.version = ITracClient.Version.XML_RPC;
        this.connectProxy("http://mylyn.org/trac", "POST");
    }

    public void testConnectProxySslWeb() throws Exception {
        this.version = ITracClient.Version.TRAC_0_9;
        this.connectProxy("https://mylyn.org/trac", "CONNECT");
    }

    public void testConnectProxySslXmlRpc() throws Exception {
        this.version = ITracClient.Version.XML_RPC;
        this.connectProxy("https://mylyn.org/trac", "CONNECT");
    }

    private void connectProxy(String url, String expectedMethod) throws Exception {
        this.testProxy.setResponse("HTTP/1.1 404 Not Found");
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("localhost", this.proxyPort));
        WebLocation location = new WebLocation(url, "", "", new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return TracClientProxyTest.this.proxy;
            }
        });
        ITracClient client = TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)this.version);
        try {
            client.validate((IProgressMonitor)new NullProgressMonitor());
        }
        catch (TracException tracException) {}
        TracClientProxyTest.assertEquals((String)expectedMethod, (String)this.testProxy.getRequest().getMethod());
    }
}

