/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiPlugin;

public class BuildImages {
    private static final URL baseURL = BuildsUiPlugin.getDefault().getBundle().getEntry("/icons/");
    public static final String T_OBJ = "obj16";
    public static final String T_OVR = "ovr16";
    public static final String T_ETOOL = "etool16";
    public static final String T_DTOOL = "dtool16";
    public static final String T_VIEW = "eview16";
    public static final ImageDescriptor VIEW_BUILDS = BuildImages.create("eview16", "build-view.png");
    public static final ImageDescriptor VIEW_HISTORY = BuildImages.create("eview16", "history_view.gif");
    public static final ImageDescriptor STATUS_PASSED = BuildImages.create("obj16", "passed-status.png");
    public static final ImageDescriptor STATUS_FAILED = BuildImages.create("obj16", "failed-status.gif");
    public static final ImageDescriptor STATUS_UNSTABLE = BuildImages.create("obj16", "unstable-status.png");
    public static final ImageDescriptor STATUS_DISABLED = BuildImages.create("obj16", "disabled-status.png");
    public static final ImageDescriptor TEST = BuildImages.create("obj16", "test.gif");
    public static final ImageDescriptor TEST_PASSED = BuildImages.create("obj16", "testok.gif");
    public static final ImageDescriptor TEST_FAILED = BuildImages.create("obj16", "testfail.gif");
    public static final ImageDescriptor TEST_ERROR = BuildImages.create("obj16", "testerr.gif");
    public static final ImageDescriptor TEST_IGNORED = BuildImages.create("obj16", "testignored.gif");
    public static final ImageDescriptor TEST_SUITE = BuildImages.create("obj16", "tsuite.gif");
    public static final ImageDescriptor TEST_SUITE_PASSED = BuildImages.create("obj16", "tsuiteok.gif");
    public static final ImageDescriptor TEST_SUITE_FAILED = BuildImages.create("obj16", "tsuitefail.gif");
    public static final ImageDescriptor TEST_SUITE_ERROR = BuildImages.create("obj16", "tsuiteerror.gif");
    public static final ImageDescriptor TEST_SUITE_IGNORED = BuildImages.create("obj16", "tsuiteignored.gif");
    public static final ImageDescriptor SERVER = BuildImages.create("obj16", "server.gif");
    public static final ImageDescriptor SERVER_DISABLED = ImageDescriptor.createWithFlags((ImageDescriptor)SERVER, (int)1);
    public static final ImageDescriptor HEALTH_00 = BuildImages.create("obj16", "weather_lightning.png");
    public static final ImageDescriptor HEALTH_20 = BuildImages.create("obj16", "weather_rain.png");
    public static final ImageDescriptor HEALTH_40 = BuildImages.create("obj16", "weather_clouds.png");
    public static final ImageDescriptor HEALTH_60 = BuildImages.create("obj16", "weather_cloudy.png");
    public static final ImageDescriptor HEALTH_80 = BuildImages.create("obj16", "weather_sun.png");
    public static final ImageDescriptor CHANGE_SET = BuildImages.create("obj16", "changeset.gif");
    public static final ImageDescriptor RUN = BuildImages.create("etool16", "run_exc.gif");
    public static final ImageDescriptor RUN_DISABLED = BuildImages.create("dtool16", "run_exc.gif");
    public static final ImageDescriptor CONSOLE = BuildImages.create("etool16", "console.gif");
    public static final ImageDescriptor FILTER_SUCCEEDING = BuildImages.create("etool16", "filter_succeeding.png");
    public static final ImageDescriptor JUNIT = BuildImages.create("eview16", "junit.gif");
    public static final ImageDescriptor DECORATION_RUNNING = BuildImages.create("ovr16", "run_co.gif");
    public static final ImageDescriptor FILTER_FAILURES = BuildImages.create("obj16", "failures.gif");

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)BuildImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuilder buffer = new StringBuilder(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }
}

