/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.htmltext;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.htmltext.HtmlTextActivator;
import org.eclipse.mylyn.htmltext.commands.Command;
import org.eclipse.mylyn.htmltext.commands.GetHtmlCommand;
import org.eclipse.mylyn.htmltext.commands.SetHtmlCommand;
import org.eclipse.mylyn.htmltext.configuration.Configuration;
import org.eclipse.mylyn.htmltext.events.NodeSelectionEvent;
import org.eclipse.mylyn.htmltext.listener.NodeSelectionChangeListener;
import org.eclipse.mylyn.htmltext.model.TriState;
import org.eclipse.mylyn.htmltext.util.ColorConverter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class HtmlComposer {
    private final Browser browser;
    private transient List<NodeSelectionChangeListener> selectionListenerList = new ArrayList<NodeSelectionChangeListener>();
    private transient List<ModifyListener> modifyListenerList = new ArrayList<ModifyListener>();
    private final List<Command> pendingCommands = Collections.synchronizedList(new ArrayList());
    private Map<Command, List<ModifyListener>> pendingListeners = new HashMap<Command, List<ModifyListener>>();
    private Map<String, List<ModifyListener>> pendingListenerCallBackMap = new HashMap<String, List<ModifyListener>>();
    private final Map<String, Command> trackedCommands = new HashMap<String, Command>();
    private boolean initialized;

    public HtmlComposer(Composite parent, int style) {
        this(parent, style, null);
    }

    public HtmlComposer(Composite parent, int style, Configuration config) {
        this.browser = new Browser(parent, style);
        this.browser.setMenu(new Menu((Control)this.browser));
        new RenderCompleteFunction(this.browser);
        try {
            URL baseUrl = FileLocator.resolve((URL)FileLocator.find((Bundle)HtmlTextActivator.getDefault().getBundle(), (IPath)new Path("/eclipsebridge/base.html"), (Map)Collections.EMPTY_MAP));
            this.browser.setUrl(String.valueOf(baseUrl.toString()) + (config != null ? "?" + config.toQuery() : ""));
            this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

                public void completed(ProgressEvent event) {
                    HtmlComposer.this.browser.execute("integration.eclipseRunning = true;");
                    HtmlComposer.this.browser.removeProgressListener((ProgressListener)this);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addControlListener(ControlListener listener) {
        this.browser.addControlListener(listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.browser.addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.browser.addFocusListener(listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.browser.addHelpListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListenerList.add(listener);
    }

    public void addNodeSelectionChangeListener(NodeSelectionChangeListener listener) {
        this.selectionListenerList.add(listener);
    }

    public void addPaintListener(PaintListener listener) {
        this.browser.addPaintListener(listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.browser.addTraverseListener(listener);
    }

    public Point computeSize(int wHint, int hHint) {
        return this.browser.computeSize(wHint, hHint);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.browser.computeSize(wHint, hHint, changed);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return this.browser.computeTrim(x, y, width, height);
    }

    public void dispose() {
        Collection<Command> values = this.trackedCommands.values();
        for (Command command : values) {
            command.dispose();
        }
        this.browser.dispose();
    }

    public Object evaluate(String script) throws SWTException {
        return this.browser.evaluate(script);
    }

    public boolean execute(String script) {
        return this.browser.execute(script);
    }

    public void execute(Command command) {
        if (this.initialized) {
            if (this.pendingListeners.get(command) != null) {
                String nanoTime = String.valueOf(System.nanoTime());
                this.pendingListenerCallBackMap.put(nanoTime, this.pendingListeners.get(command));
                this.execute("integration.pendingCommandIdentifier = '" + nanoTime + "';");
                this.execute(command.getCommand());
                this.pendingListeners.remove(command);
            } else {
                this.execute("integration.pendingCommandIdentifier = '';");
                this.execute(command.getCommand());
            }
        } else {
            this.pendingListeners.put(command, new ArrayList<ModifyListener>(this.modifyListenerList));
            this.pendingCommands.add(command);
        }
    }

    public Object executeWithReturn(Command command) {
        if (this.initialized) {
            return this.evaluate(command.getCommand());
        }
        return null;
    }

    public boolean forceFocus() {
        return this.browser.forceFocus();
    }

    public Accessible getAccessible() {
        return this.browser.getAccessible();
    }

    public Color getBackground() {
        return this.browser.getBackground();
    }

    public Image getBackgroundImage() {
        return this.browser.getBackgroundImage();
    }

    public int getBackgroundMode() {
        return this.browser.getBackgroundMode();
    }

    public int getBorderWidth() {
        return this.browser.getBorderWidth();
    }

    public Rectangle getBounds() {
        return this.browser.getBounds();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Control[] getChildren() {
        return this.browser.getChildren();
    }

    public Rectangle getClientArea() {
        return this.browser.getClientArea();
    }

    public Cursor getCursor() {
        return this.browser.getCursor();
    }

    public Object getData() {
        return this.browser.getData();
    }

    public Object getData(String key) {
        return this.browser.getData(key);
    }

    public Display getDisplay() {
        return this.browser.getDisplay();
    }

    public boolean getEnabled() {
        return this.browser.getEnabled();
    }

    public Font getFont() {
        return this.browser.getFont();
    }

    public Color getForeground() {
        return this.browser.getForeground();
    }

    public ScrollBar getHorizontalBar() {
        return this.browser.getHorizontalBar();
    }

    public String getHtml() {
        GetHtmlCommand getHtmlCommand = new GetHtmlCommand();
        getHtmlCommand.setComposer(this);
        Object executeWithReturn = this.executeWithReturn(getHtmlCommand);
        if (executeWithReturn != null) {
            return String.valueOf(executeWithReturn);
        }
        return null;
    }

    public Layout getLayout() {
        return this.browser.getLayout();
    }

    public Object getLayoutData() {
        return this.browser.getLayoutData();
    }

    public boolean getLayoutDeferred() {
        return this.browser.getLayoutDeferred();
    }

    public Listener[] getListeners(int eventType) {
        return this.browser.getListeners(eventType);
    }

    public Point getLocation() {
        return this.browser.getLocation();
    }

    public Menu getMenu() {
        return this.browser.getMenu();
    }

    public Monitor getMonitor() {
        return this.browser.getMonitor();
    }

    public Composite getParent() {
        return this.browser.getParent();
    }

    public Region getRegion() {
        return this.browser.getRegion();
    }

    public Shell getShell() {
        return this.browser.getShell();
    }

    public Point getSize() {
        return this.browser.getSize();
    }

    public int getStyle() {
        return this.browser.getStyle();
    }

    public Control[] getTabList() {
        return this.browser.getTabList();
    }

    public ScrollBar getVerticalBar() {
        return this.browser.getVerticalBar();
    }

    public boolean getVisible() {
        return this.browser.getVisible();
    }

    public Object getWebBrowser() {
        return this.browser.getWebBrowser();
    }

    void initialize() {
        new SelectionChangedFunction(this.browser);
        new ModifiedFunction(this.browser);
        this.initialized = true;
        for (Command command : this.pendingCommands) {
            this.execute(command);
        }
        this.pendingCommands.clear();
    }

    public boolean isDisposed() {
        return this.browser.isDisposed();
    }

    public boolean isEnabled() {
        return this.browser.isEnabled();
    }

    public boolean isFocusControl() {
        return this.browser.isFocusControl();
    }

    public boolean isLayoutDeferred() {
        return this.browser.isLayoutDeferred();
    }

    public boolean isListening(int eventType) {
        return this.browser.isListening(eventType);
    }

    public boolean isReparentable() {
        return this.browser.isReparentable();
    }

    public boolean isVisible() {
        return this.browser.isVisible();
    }

    public void layout() {
        this.browser.layout();
    }

    public void layout(boolean changed) {
        this.browser.layout(changed);
    }

    public void layout(boolean changed, boolean all) {
        this.browser.layout(changed, all);
    }

    public void layout(Control[] changed) {
        this.browser.layout(changed);
    }

    public void moveAbove(Control control) {
        this.browser.moveAbove(control);
    }

    public void moveBelow(Control control) {
        this.browser.moveBelow(control);
    }

    public void notifyListeners(int eventType, Event event) {
        this.browser.notifyListeners(eventType, event);
    }

    public void pack() {
        this.browser.pack();
    }

    public void pack(boolean changed) {
        this.browser.pack(changed);
    }

    public boolean print(GC gc) {
        return this.browser.print(gc);
    }

    public void redraw() {
        this.browser.redraw();
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.browser.redraw(x, y, width, height, all);
    }

    public void refresh() {
        this.browser.refresh();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.browser.removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.browser.removeFocusListener(listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.browser.removeHelpListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListenerList.remove(listener);
    }

    public void removeNodeSelectionChangeListener(NodeSelectionChangeListener listener) {
        this.selectionListenerList.remove(listener);
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        this.browser.removeOpenWindowListener(listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.browser.removePaintListener(listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.browser.removeTraverseListener(listener);
    }

    public void setBackground(final Color color) {
        this.browser.setBackground(color);
        this.execute(new Command(){

            @Override
            public String getCommandIdentifier() {
                return "set_background_internal";
            }

            @Override
            public String getCommand() {
                String hexValue = color != null ? "#" + ColorConverter.convertRgbToHex(color.getRGB()) : "";
                return "document.getElementById('cke_editor1_arialbl').nextSibling.style.backgroundColor = '" + hexValue + "';";
            }
        });
    }

    public void setBackgroundImage(Image image) {
        this.browser.setBackgroundImage(image);
    }

    public void setBackgroundMode(int mode) {
        this.browser.setBackgroundMode(mode);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.browser.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.browser.setBounds(rect);
    }

    public void setCapture(boolean capture) {
        this.browser.setCapture(capture);
    }

    public void setCursor(Cursor cursor) {
        this.browser.setCursor(cursor);
    }

    public void setData(Object data) {
        this.browser.setData(data);
    }

    public void setData(String key, Object value) {
        this.browser.setData(key, value);
    }

    public void setEnabled(boolean enabled) {
        this.browser.setEnabled(enabled);
    }

    public boolean setFocus() {
        boolean setFocus = this.browser.setFocus();
        this.browser.execute("integration.editor.focus();");
        return setFocus;
    }

    public void setFont(Font font) {
        this.browser.setFont(font);
    }

    public void setForeground(Color color) {
        this.browser.setForeground(color);
    }

    public void setHtml(String html) {
        SetHtmlCommand setHtmlCommand = new SetHtmlCommand();
        setHtmlCommand.setComposer(this);
        setHtmlCommand.setHtml(html);
        this.execute(setHtmlCommand);
    }

    public void setLayout(Layout layout) {
        this.browser.setLayout(layout);
    }

    public void setLayoutData(Object layoutData) {
        this.browser.setLayoutData(layoutData);
    }

    public void setLayoutDeferred(boolean defer) {
        this.browser.setLayoutDeferred(defer);
    }

    public void setLocation(int x, int y) {
        this.browser.setLocation(x, y);
    }

    public void setLocation(Point location) {
        this.browser.setLocation(location);
    }

    public void setMenu(Menu menu) {
        this.browser.setMenu(menu);
    }

    public boolean setParent(Composite parent) {
        return this.browser.setParent(parent);
    }

    public void setRedraw(boolean redraw) {
        this.browser.setRedraw(redraw);
    }

    public void setRegion(Region region) {
        this.browser.setRegion(region);
    }

    public void setSize(int width, int height) {
        this.browser.setSize(width, height);
    }

    public void setSize(Point size) {
        this.browser.setSize(size);
    }

    public void setTabList(Control[] tabList) {
        this.browser.setTabList(tabList);
    }

    public void setVisible(boolean visible) {
        this.browser.setVisible(visible);
    }

    public Point toControl(int x, int y) {
        return this.browser.toControl(x, y);
    }

    public Point toControl(Point point) {
        return this.browser.toControl(point);
    }

    public Point toDisplay(int x, int y) {
        return this.browser.toDisplay(x, y);
    }

    public Point toDisplay(Point point) {
        return this.browser.toDisplay(point);
    }

    public String toString() {
        return this.browser.toString();
    }

    public void trackCommand(Command command) {
        this.trackedCommands.put(command.getCommandIdentifier(), command);
    }

    public boolean traverse(int traversal) {
        return this.browser.traverse(traversal);
    }

    public void untrackCommand(Command command) {
        this.trackedCommands.remove(command.getCommandIdentifier());
    }

    private class ModifiedFunction
    extends BrowserFunction {
        public ModifiedFunction(Browser browser) {
            super(browser, "_delegate_modified");
        }

        public Object function(Object[] arguments) {
            if (arguments.length > 0) {
                String identifier = (String)arguments[0];
                Event event = new Event();
                event.widget = this.getBrowser();
                event.data = this;
                ModifyEvent modifyEvent = new ModifyEvent(event);
                if (HtmlComposer.this.pendingListenerCallBackMap.get(identifier) != null) {
                    List list = (List)HtmlComposer.this.pendingListenerCallBackMap.get(identifier);
                    for (ModifyListener modifyListener : list) {
                        modifyListener.modifyText(modifyEvent);
                    }
                } else if (HtmlComposer.this.modifyListenerList.size() > 0) {
                    for (ModifyListener listener : HtmlComposer.this.modifyListenerList) {
                        listener.modifyText(modifyEvent);
                    }
                }
                HtmlComposer.this.pendingListenerCallBackMap.remove(identifier);
            }
            return null;
        }
    }

    private class RenderCompleteFunction
    extends BrowserFunction {
        public RenderCompleteFunction(Browser browser) {
            super(browser, "_delegate_init");
        }

        public Object function(Object[] arguments) {
            HtmlComposer.this.initialize();
            return null;
        }
    }

    private class SelectionChangedFunction
    extends BrowserFunction {
        public SelectionChangedFunction(Browser browser) {
            super(browser, "_delegate_selectionChanged");
        }

        public Object function(Object[] arguments) {
            if (HtmlComposer.this.selectionListenerList.size() > 0) {
                NodeSelectionEvent nodeSelectionEvent = new NodeSelectionEvent(null);
                for (NodeSelectionChangeListener listener : HtmlComposer.this.selectionListenerList) {
                    listener.selectedNodeChanged(nodeSelectionEvent);
                }
            }
            if (HtmlComposer.this.trackedCommands.size() > 0) {
                Set keySet = HtmlComposer.this.trackedCommands.keySet();
                for (String string : keySet) {
                    String valueOf = String.valueOf(HtmlComposer.this.evaluate("return integration.editor.getCommand('" + string + "').state;"));
                    TriState fromString = TriState.fromString(valueOf);
                    if (fromString == ((Command)HtmlComposer.this.trackedCommands.get(string)).getState()) continue;
                    ((Command)HtmlComposer.this.trackedCommands.get(string)).setState(fromString);
                }
            }
            return null;
        }
    }
}

