/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.common.collect.ArrayListMultimap;
import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ChangeMessage;
import com.google.gerrit.reviewdb.PatchSetApproval;
import com.google.gerrit.reviewdb.Project;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritQueryResultSchema;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritPerson;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritQueryResult;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.GerritReviewLabel;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.eclipse.mylyn.reviews.internal.core.BuildResult;
import org.eclipse.mylyn.reviews.internal.core.ReviewFileCommentsMapper;
import org.eclipse.mylyn.reviews.internal.core.TaskBuildStatusMapper;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.osgi.util.NLS;

public class GerritTaskDataHandler
extends AbstractTaskDataHandler {
    private final GerritConnector connector;
    private final String ANONYMOUS = "Anonymous";

    public GerritTaskDataHandler(GerritConnector connector) {
        this.connector = connector;
    }

    public TaskData createTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) {
        TaskData data = new TaskData(this.getAttributeMapper(repository), "org.eclipse.mylyn.gerrit", repository.getRepositoryUrl(), taskId);
        this.initializeTaskData(repository, data, null, monitor);
        return data;
    }

    public TaskData createPartialTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) {
        TaskData data = new TaskData(this.getAttributeMapper(repository), "org.eclipse.mylyn.gerrit", repository.getRepositoryUrl(), taskId);
        GerritQueryResultSchema.getDefault().initialize(data);
        data.setPartial(true);
        return data;
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository repository) {
        return new TaskAttributeMapper(repository){

            public boolean equals(TaskAttribute newAttribute, TaskAttribute oldAttribute) {
                if (oldAttribute == null) {
                    return false;
                }
                if (!"BuildResult".equals(newAttribute.getMetaData().getType())) {
                    return super.equals(newAttribute, oldAttribute);
                }
                if (!super.equals(newAttribute, oldAttribute)) {
                    return false;
                }
                for (TaskAttribute newChild : newAttribute.getAttributes().values()) {
                    if (this.equals(newChild, oldAttribute.getAttribute(newChild.getId()))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        ReviewObserver reviewObserver = new ReviewObserver();
        try {
            TaskData taskData;
            RemoteEmfConsumer<IRepository, IReview, String, GerritChange, String, Date> consumer;
            GerritChange gerritChange;
            GerritClient client = this.connector.getClient(repository);
            boolean anonymous = client.isAnonymous();
            String id = null;
            if (!anonymous) {
                id = this.getAccountId(client, repository, monitor);
            }
            if ((gerritChange = (GerritChange)(consumer = this.updateModelData(repository, taskData = this.createTaskData(repository, taskId = client.toReviewId(taskId, monitor), monitor), reviewObserver, monitor)).getRemoteObject()) == null) {
                throw new CoreException((IStatus)this.connector.createErrorStatus(repository, NLS.bind((String)"Couldn't retrieve remote object for task: {0}. Check remote connection", (Object)taskId)));
            }
            Project.NameKey project = gerritChange.getChangeDetail().getChange().getProject();
            client.refreshConfigOnce(project, monitor);
            if (!monitor.isCanceled()) {
                this.updateTaskData(repository, taskData, gerritChange, (IReview)consumer.getModelObject(), !anonymous, id);
            }
            TaskData taskData2 = taskData;
            return taskData2;
        }
        catch (GerritException e) {
            throw this.connector.toCoreException(repository, NLS.bind((String)"Problem retrieving task data for task: {0}", (Object)taskId), e);
        }
        finally {
            reviewObserver.dispose();
        }
    }

    private RemoteEmfConsumer<IRepository, IReview, String, GerritChange, String, Date> updateModelData(TaskRepository repository, TaskData taskData, ReviewObserver reviewObserver, IProgressMonitor monitor) throws CoreException {
        GerritClient client = this.connector.getClient(repository);
        GerritRemoteFactoryProvider factoryProvider = (GerritRemoteFactoryProvider)client.getFactoryProvider();
        RemoteEmfConsumer consumer = factoryProvider.getReviewFactory().getConsumerForLocalKey((EObject)((IRepository)factoryProvider.getRoot()), taskData.getTaskId());
        consumer.addObserver((RemoteEmfObserver)reviewObserver);
        if (!consumer.isRetrieving()) {
            if (monitor.isCanceled()) {
                return consumer;
            }
            consumer.open();
            if (monitor.isCanceled()) {
                return consumer;
            }
            consumer.setAsynchronous(false);
            consumer.retrieve(true);
            consumer.setAsynchronous(true);
        }
        while (!reviewObserver.complete && !monitor.isCanceled()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                reviewObserver.dispose();
                Thread.currentThread().interrupt();
            }
        }
        consumer.save();
        if (!consumer.getStatus().isOK()) {
            if (consumer.getStatus().getException() instanceof CoreException) {
                throw (CoreException)consumer.getStatus().getException();
            }
            throw new CoreException(consumer.getStatus());
        }
        return consumer;
    }

    protected String getAccountId(GerritClient client, TaskRepository repository, IProgressMonitor monitor) throws GerritException {
        Account account;
        String id = repository.getProperty("org.eclipse.mylyn.gerrit.accountId");
        if (id == null && (account = client.getAccount(monitor)) != null) {
            id = account.getId().toString();
            repository.setProperty("org.eclipse.mylyn.gerrit.accountId", id);
        }
        return id;
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData taskData, ITaskMapping initializationData, IProgressMonitor monitor) {
        GerritTaskSchema.getDefault().initialize(taskData);
        return true;
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public void updateTaskData(TaskRepository repository, TaskData data, GerritChange gerritReview, IReview modelReview, boolean canPublish, String accountId) {
        void var17_22;
        GerritTaskSchema schema = GerritTaskSchema.getDefault();
        ChangeDetailX changeDetail = gerritReview.getChangeDetail();
        Change change = changeDetail.getChange();
        AccountInfo owner = changeDetail.getAccounts().get(change.getOwner());
        this.updatePartialTaskData(repository, data, new GerritQueryResult(new ChangeInfo(change)));
        this.setAttributeValue(data, schema.BRANCH, change.getDest().get());
        String userId = GerritUtil.getUserId(owner);
        String userLabel = GerritUtil.getUserLabel(owner);
        TaskAttribute ownerAttribute = this.setAttributeValue(data, schema.OWNER, userId);
        if (ownerAttribute != null) {
            ownerAttribute.putOption(userId, userLabel);
        }
        this.setAttributeValue(data, schema.UPLOADED, GerritTaskDataHandler.dateToString(changeDetail.getDateCreated()));
        this.setAttributeValue(data, schema.UPDATED, GerritTaskDataHandler.dateToString(changeDetail.getLastModified()));
        this.setAttributeValue(data, schema.DESCRIPTION, changeDetail.getDescription());
        int i = 1;
        String accountName = repository.getUserName();
        for (ChangeMessage message : changeDetail.getMessages()) {
            TaskCommentMapper mapper = new TaskCommentMapper();
            if (message.getAuthor() != null) {
                String email;
                AccountInfo author = changeDetail.getAccounts().get(message.getAuthor());
                String id = author.getId().toString();
                String userName = id.equals(accountId) && accountName != null ? accountName : ((email = author.getPreferredEmail()) != null ? email : id);
                IRepositoryPerson person = repository.createPerson(userName);
                person.setName(author.getFullName());
                mapper.setAuthor(person);
            } else {
                IRepositoryPerson person = repository.createPerson("Gerrit Code Review");
                mapper.setAuthor(person);
            }
            mapper.setText(message.getMessage());
            mapper.setCreationDate((Date)message.getWrittenOn());
            mapper.setNumber(Integer.valueOf(i));
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.comment-" + i);
            mapper.applyTo(attribute);
            ++i;
        }
        ArrayListMultimap resultsByPatchNumber = ArrayListMultimap.create();
        for (BuildResult buildResult : changeDetail.getPatchSetBuildStatuses()) {
            resultsByPatchNumber.put((Object)buildResult.getPatchSetNumber(), (Object)buildResult);
        }
        for (Map.Entry entry : resultsByPatchNumber.asMap().entrySet()) {
            int patchNumber = (Integer)entry.getKey();
            TaskBuildStatusMapper mapper = new TaskBuildStatusMapper((Collection)entry.getValue());
            TaskAttribute attribute = data.getRoot().createAttribute("PATCH_SET-" + patchNumber);
            mapper.applyTo(attribute);
        }
        this.setAttributeValue(data, schema.CAN_PUBLISH, Boolean.toString(canPublish));
        this.setAttributeValue(data, schema.IS_STARRED, Boolean.toString(changeDetail.isStarred()));
        Short s = 0;
        Short verifyState = 0;
        for (ApprovalDetail approvals : changeDetail.getApprovals()) {
            Map map = approvals.getApprovalMap();
            PatchSetApproval approval = (PatchSetApproval)map.get(new ApprovalCategory.Id("CRVW"));
            if (approval != null && approval.getValue() != 0) {
                Short s2 = this.getStateValue(approval.getValue(), (Short)var17_22);
            }
            if ((approval = (PatchSetApproval)map.get(new ApprovalCategory.Id("VRIF"))) == null || approval.getValue() == 0) continue;
            verifyState = this.getStateValue(approval.getValue(), verifyState);
        }
        this.setAttributeValue(data, schema.REVIEW_STATE, var17_22.toString());
        this.setAttributeValue(data, schema.VERIFY_STATE, verifyState.toString());
        new ReviewFileCommentsMapper(modelReview).applyTo(data);
    }

    private Short getStateValue(Short value, Short oldState) {
        Short state = 0;
        state = value < 0 ? Short.valueOf((short)Math.min(oldState.shortValue(), value.shortValue())) : Short.valueOf((short)Math.max(oldState.shortValue(), value.shortValue()));
        return state;
    }

    public void migrateTaskData(TaskRepository repository, TaskData taskData) {
        super.migrateTaskData(repository, taskData);
        if (taskData.getRoot().getAttribute(GerritTaskSchema.getDefault().NEW_COMMENT.getKey()) == null) {
            taskData.getRoot().createAttribute(GerritTaskSchema.getDefault().NEW_COMMENT.getKey());
        }
    }

    public void updatePartialTaskData(TaskRepository repository, TaskData data, GerritQueryResult queryResult) {
        GerritPerson owner;
        GerritQueryResultSchema schema = GerritQueryResultSchema.getDefault();
        this.setAttributeValue(data, schema.KEY, this.shortenChangeId(queryResult.getId()));
        this.setAttributeValue(data, schema.PROJECT, queryResult.getProject());
        this.setAttributeValue(data, schema.SUMMARY, queryResult.getSubject());
        this.setAttributeValue(data, schema.STATUS, queryResult.getStatus());
        this.setAttributeValue(data, schema.URL, this.connector.getTaskUrl(repository.getUrl(), data.getTaskId()));
        this.setAttributeValue(data, schema.UPDATED, GerritTaskDataHandler.dateToString(queryResult.getUpdated()));
        this.setAttributeValue(data, schema.CHANGE_ID, queryResult.getId());
        if (GerritConnector.isClosed(queryResult.getStatus())) {
            this.setAttributeValue(data, schema.COMPLETED, GerritTaskDataHandler.dateToString(queryResult.getUpdated()));
        }
        if ((owner = queryResult.getOwner()) != null) {
            String fullName = this.getFullNameFromAccount(repository);
            if (fullName != null && fullName.equals(owner.getName())) {
                String preferredEmail = this.getPreferredEmailFromAccount(repository);
                TaskAttribute ownerAttribute = this.setAttributeValue(data, schema.OWNER, preferredEmail);
                ownerAttribute.putOption(preferredEmail, fullName);
            } else {
                this.setAttributeValue(data, schema.OWNER, owner.getName());
            }
        } else {
            this.setAttributeValue(data, schema.OWNER, "Anonymous");
        }
        this.setAttributeValue(data, schema.BRANCH, queryResult.getBranch());
        this.setAttributeValue(data, schema.IS_STARRED, (queryResult.isStarred() ? Boolean.TRUE : Boolean.FALSE).toString());
        this.setAttributeValue(data, schema.TOPIC, queryResult.getTopic());
        GerritReviewLabel reviewLabel = queryResult.getReviewLabel();
        if (reviewLabel != null) {
            if (reviewLabel.getVerifyStatus() != null) {
                this.setAttributeValue(data, schema.VERIFY_STATE, reviewLabel.getVerifyStatus().getStatus());
            }
            if (reviewLabel.getCodeReviewStatus() != null) {
                this.setAttributeValue(data, schema.REVIEW_STATE, reviewLabel.getCodeReviewStatus().getStatus());
            }
        }
    }

    private String getFullNameFromAccount(TaskRepository repository) {
        GerritConfiguration config = this.connector.getConfiguration(repository);
        if (config != null && config.getAccount() != null) {
            return config.getAccount().getFullName();
        }
        return null;
    }

    private String getPreferredEmailFromAccount(TaskRepository repository) {
        GerritConfiguration config = this.connector.getConfiguration(repository);
        if (config != null && config.getAccount() != null) {
            return config.getAccount().getPreferredEmail();
        }
        return null;
    }

    private String shortenChangeId(String changeId) {
        changeId = GerritUtil.toChangeId(changeId);
        return changeId.substring(0, Math.min(9, changeId.length()));
    }

    private TaskAttribute setAttributeValue(TaskData data, AbstractTaskSchema.Field gerritAttribute, String value) {
        TaskAttribute attribute = data.getRoot().getAttribute(gerritAttribute.getKey());
        if (value != null) {
            attribute.setValue(value);
        }
        return attribute;
    }

    private static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        return Long.toString(date.getTime());
    }

    private class ReviewObserver
    extends RemoteEmfObserver<IRepository, IReview, String, Date> {
        boolean complete;

        private ReviewObserver() {
        }

        public void updated(boolean modified) {
            this.complete = true;
        }
    }
}

