/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.docs.epub.core;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public abstract class AbstractXHTMLScanner
extends DefaultHandler2 {
    protected StringBuilder buffer = new StringBuilder();
    protected boolean recording = false;
    protected String currentHref = null;
    protected boolean insideHead;

    protected int isHeader(String qName) {
        if ((qName.startsWith("h") || qName.startsWith("H")) && qName.length() == 2 && !qName.equalsIgnoreCase("hr")) {
            String n = qName.substring(1);
            try {
                int i = Integer.parseInt(n);
                if (i > 0 && i < 7) {
                    return i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Bad header in " + this.currentHref);
            }
        }
        return 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("head")) {
            this.insideHead = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("head")) {
            this.insideHead = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.recording) {
            String s = new String(ch, start, length);
            this.buffer.append(s.replace("\n", ""));
        }
    }
}

