/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.internal.tasks.core.SaxRepositoriesContentHandler;
import org.eclipse.mylyn.internal.tasks.core.SaxRepositoriesWriter;
import org.eclipse.mylyn.internal.tasks.core.XmlReaderUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaxRepositoriesTest {
    private static final String kind = "connector.kind";
    private static final String kindCharacters = "connector.kind-`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<";
    private static final String firstUrl = "http://first.url";
    private static final String secondUrl = "http://second.url";
    private static final String urlCharacters = "http://some.url--`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<";
    private static final String labelPropertyValue = "test repository";
    private static final String labelPropertyValueAlternate = "test repository alternate";
    private static final String labelPropertyKey = "label";
    private static final String labelPropertyCharacters = "`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<";
    private static final String labelPropertyKeyCharacters = "label-`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<";
    private SaxRepositoriesContentHandler handler;
    private final String version1RepositoryXml = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><TaskRepositories OutputVersion=\"1\"><TaskRepository url=\"%s\" kind=\"%s\" %s=\"%s\"/></TaskRepositories>", "http://first.url", "connector.kind", "label", "test repository");
    private final String version1RepositoryXmlMultiple = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><TaskRepositories OutputVersion=\"1\"><TaskRepository url=\"%s\" kind=\"%s\" %s=\"%s\"/><TaskRepository url=\"%s\" kind=\"%s\" %s=\"%s\"/></TaskRepositories>", "http://first.url", "connector.kind", "label", "test repository", "http://second.url", "connector.kind", "label", "test repository");
    private final String version1RepositoryXmlSpecialCharacters = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><TaskRepositories OutputVersion=\"1\"><TaskRepository url=\"%s\" kind=\"%s\" %s=\"%s\"/></TaskRepositories>", this.escapeXml(this.escapeXml("http://some.url--`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<")), this.escapeXml(this.escapeXml("connector.kind-`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<")), "label", this.escapeXml(this.escapeXml("`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<")));
    private final String version2RepositoryXml = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><TaskRepositories OutputVersion=\"2\"><TaskRepository url=\"%s\" kind=\"%s\"><Property key=\"%s\" value=\"%s\"/></TaskRepository></TaskRepositories>", "http://first.url", "connector.kind", "label", "test repository");
    private final String version2RepositoryXmlMultiple = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><TaskRepositories OutputVersion=\"2\"><TaskRepository url=\"%s\" kind=\"%s\"><Property key=\"%s\" value=\"%s\"/></TaskRepository><TaskRepository url=\"%s\" kind=\"%s\"><Property key=\"%s\" value=\"%s\"/></TaskRepository></TaskRepositories>", "http://first.url", "connector.kind", "label", "test repository", "http://second.url", "connector.kind", "label", "test repository");
    private final String version2RepositoryXmlSpecialCharacters = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><TaskRepositories OutputVersion=\"2\"><TaskRepository url=\"%s\" kind=\"%s\"><Property key=\"%s\" value=\"%s\"/></TaskRepository></TaskRepositories>", this.escapeXml(this.escapeXml("http://some.url--`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<")), this.escapeXml(this.escapeXml("connector.kind-`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<")), this.escapeXml("label-`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<"), this.escapeXml("`~!@#$%^&*()_+-=[{}]\\|'\";:/?.>,<"));
    private final String version1AndVersion2RepositoryXmlMultiple = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><TaskRepositories OutputVersion=\"2\"><TaskRepository url=\"%s\" kind=\"%s\" %s=\"%s\"><Property key=\"%s\" value=\"%s\"/></TaskRepository><TaskRepository url=\"%s\" kind=\"%s\" %s=\"%s\"><Property key=\"%s\" value=\"%s\"/></TaskRepository></TaskRepositories>", "http://first.url", "connector.kind", "label", "test repository alternate", "label", "test repository", "http://second.url", "connector.kind", "label", "test repository alternate", "label", "test repository");

    @Before
    public void setUp() {
        this.handler = new SaxRepositoriesContentHandler();
    }

    @Test
    public void readVersion1() throws SAXException, IOException {
        this.assertRead(this.version1RepositoryXml, Sets.newHashSet((Object[])new TaskRepository[]{this.createTestRepository(firstUrl)}));
    }

    @Test
    public void readVersion1Multiple() throws SAXException, IOException {
        this.assertRead(this.version1RepositoryXmlMultiple, Sets.newHashSet((Object[])new TaskRepository[]{this.createTestRepository(firstUrl), this.createTestRepository(secondUrl)}));
    }

    @Test
    public void readVersion1Characters() throws SAXException, IOException {
        this.assertRead(this.version1RepositoryXmlSpecialCharacters, Sets.newHashSet((Object[])new TaskRepository[]{this.createTestRepository(kindCharacters, urlCharacters, labelPropertyKey, labelPropertyCharacters)}), labelPropertyKey, labelPropertyCharacters);
    }

    @Test
    public void readVersion2() throws SAXException, IOException {
        this.assertRead(this.version2RepositoryXml, Sets.newHashSet((Object[])new TaskRepository[]{this.createTestRepository(firstUrl)}));
    }

    @Test
    public void readVersion2Multiple() throws SAXException, IOException {
        this.assertRead(this.version2RepositoryXmlMultiple, Sets.newHashSet((Object[])new TaskRepository[]{this.createTestRepository(firstUrl), this.createTestRepository(secondUrl)}));
    }

    @Test
    public void readVersion2Characters() throws SAXException, IOException {
        this.assertRead(this.version2RepositoryXmlSpecialCharacters, Sets.newHashSet((Object[])new TaskRepository[]{this.createTestRepository(kindCharacters, urlCharacters, labelPropertyKeyCharacters, labelPropertyCharacters)}), labelPropertyKeyCharacters, labelPropertyCharacters);
    }

    @Test
    public void write() throws SAXException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.write(output, (List<TaskRepository>)ImmutableList.of((Object)this.createTestRepository(firstUrl)));
        this.assertRead(((Object)output).toString(), Sets.newHashSet((Object[])new TaskRepository[]{this.createTestRepository(firstUrl)}));
    }

    @Test
    public void writeMultiple() throws SAXException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.write(output, (List<TaskRepository>)ImmutableList.of((Object)this.createTestRepository(firstUrl), (Object)this.createTestRepository(secondUrl)));
        this.assertRead(((Object)output).toString(), Sets.newHashSet((Object[])new TaskRepository[]{this.createTestRepository(firstUrl), this.createTestRepository(secondUrl)}));
    }

    @Test
    public void readMixed() throws Exception {
        this.assertRead(this.version1AndVersion2RepositoryXmlMultiple, Sets.newHashSet((Object[])new TaskRepository[]{this.createTestRepository(firstUrl), this.createTestRepository(secondUrl)}));
    }

    @Test
    public void writeMixedBadCharacters() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.write(output, Lists.newArrayList((Object[])new TaskRepository[]{this.createTestRepository(kind, firstUrl, labelPropertyKeyCharacters, labelPropertyValue)}));
        String serialized = ((Object)output).toString();
        Assert.assertTrue((boolean)serialized.contains(("key=\"" + this.escapeXml(labelPropertyKeyCharacters) + "\"").replace("&apos;", "'")));
        Assert.assertTrue((boolean)serialized.contains("value=\"" + this.escapeXml(labelPropertyValue) + "\""));
        Assert.assertEquals((long)serialized.lastIndexOf(labelPropertyValue), (long)serialized.indexOf(labelPropertyValue));
    }

    private void assertRead(String xml, Set<TaskRepository> expectedRepositories) throws SAXException, IOException {
        this.assertRead(xml, expectedRepositories, labelPropertyKey, labelPropertyValue);
    }

    private void assertRead(String xml, Set<TaskRepository> expectedRepositories, String labelPropertyKey, String labelPropertyValue) throws SAXException, IOException {
        this.parse(xml);
        Set repositories = this.handler.getRepositories();
        Assert.assertEquals(expectedRepositories, (Object)repositories);
        for (TaskRepository repository : repositories) {
            Assert.assertEquals((Object)labelPropertyValue, (Object)repository.getProperty(labelPropertyKey));
        }
    }

    private void parse(String xml) throws SAXException, IOException {
        XMLReader reader = XmlReaderUtil.createXmlReader();
        reader.setContentHandler((ContentHandler)this.handler);
        reader.parse(new InputSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
    }

    private void write(OutputStream output, List<TaskRepository> repositories) throws IOException {
        SaxRepositoriesWriter writer = new SaxRepositoriesWriter();
        writer.setOutputStream(output);
        writer.writeRepositoriesToStream(repositories);
    }

    private TaskRepository createTestRepository(String url) {
        return this.createTestRepository(kind, url, labelPropertyKey, labelPropertyValue);
    }

    private TaskRepository createTestRepository(String kind, String url, String labelPropertyKey, String labelProperty) {
        TaskRepository repository = new TaskRepository(kind, url);
        repository.setProperty(labelPropertyKey, labelProperty);
        return repository;
    }

    private String escapeXml(String stringToEscape) {
        return XmlStringConverter.convertToXmlString((String)stringToEscape);
    }
}

