/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.actions;

import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.mylyn.builds.core.BuildState;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.internal.core.operations.GetBuildsOperation;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.actions.Messages;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditor;
import org.eclipse.mylyn.internal.builds.ui.editor.RefreshBuildEditorOperationListener;
import org.eclipse.ui.IWorkbenchPart;

public class RefreshBuildEditorAction
extends Action {
    private final BuildEditor editor;

    public RefreshBuildEditorAction(BuildEditor editor) {
        super(Messages.RefreshBuildEditorAction_RefreshBuildEditor);
        this.setImageDescriptor(CommonImages.REFRESH);
        this.editor = editor;
    }

    public void updateEnablement() {
        this.setEnabled(this.getBuild().getState() != BuildState.STOPPED);
    }

    public void run() {
        IBuild build = this.getBuild();
        IBuildPlan plan = build.getPlan();
        String label = build.getLabel();
        EditorHandle handle = new EditorHandle();
        handle.setPart((IWorkbenchPart)this.editor);
        GetBuildsRequest request = new GetBuildsRequest(plan, Collections.singletonList(label), GetBuildsRequest.Scope.FULL);
        GetBuildsOperation operation = BuildsUiInternal.getFactory().getGetBuildsOperation(request);
        operation.addOperationChangeListener((OperationChangeListener)new RefreshBuildEditorOperationListener(build, handle));
        operation.execute();
    }

    private IBuild getBuild() {
        return this.editor.getEditorInput().getBuild();
    }
}

