/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.support;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.junit.Assert;

public class BugzillaHarness {
    private final BugzillaFixture fixture;
    private TaskRepository repository;
    private BugzillaClient priviledgedClient;

    public BugzillaRepositoryConnector connector() {
        return this.fixture.connector();
    }

    public TaskRepository repository() {
        if (this.repository == null) {
            this.repository = this.fixture.singleRepository();
        }
        return this.repository;
    }

    public ITask getTask(String taskId) throws Exception {
        TaskRepository repository = this.repository();
        TaskData taskData = this.fixture.connector().getTaskData(repository, taskId, null);
        ITask task = TasksUi.getRepositoryModel().createTask(repository, taskData.getTaskId());
        TasksUiPlugin.getTaskDataManager().putUpdatedTaskData(task, taskData, true);
        return task;
    }

    private BugzillaClient priviledgedClient() throws Exception {
        if (this.priviledgedClient == null) {
            this.priviledgedClient = this.fixture.client();
        }
        return this.priviledgedClient;
    }

    TaskData createTaskData(ITaskMapping initializationData, ITaskMapping selectionData, IProgressMonitor monitor) throws CoreException {
        AbstractTaskDataHandler taskDataHandler = this.connector().getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository());
        TaskData taskData = new TaskData(mapper, this.repository().getConnectorKind(), this.repository().getRepositoryUrl(), "");
        boolean result = taskDataHandler.initializeTaskData(this.repository(), taskData, initializationData, monitor);
        if (!result) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Initialization of task failed. The provided data is insufficient."));
        }
        if (selectionData != null) {
            this.connector().getTaskMapping(taskData).merge(selectionData);
        }
        return taskData;
    }

    private RepositoryResponse createNewTask(TaskData taskData) throws IOException, CoreException, Exception {
        return this.fixture.submitTask(taskData, this.priviledgedClient());
    }

    public BugzillaHarness(BugzillaFixture fixture) {
        this.fixture = fixture;
    }

    public String taskXmlRpcExists() {
        String taskID = null;
        String queryUrlString = String.valueOf(this.repository().getRepositoryUrl()) + "/buglist.cgi?" + "short_desc=test%20XMLRPC%20getBugData&resolution=---&query_format=advanced" + "&short_desc_type=casesubstring&component=TestComponent&product=TestProduct";
        RepositoryQuery query = new RepositoryQuery(this.repository().getConnectorKind(), "handle-testQueryViaConnector");
        query.setUrl(queryUrlString);
        final HashMap changedTaskData = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.put(Integer.valueOf(taskData.getTaskId()), taskData);
            }
        };
        this.connector().performQuery(this.repository(), (IRepositoryQuery)query, collector, null, (IProgressMonitor)new NullProgressMonitor());
        if (changedTaskData.size() > 0) {
            Set ks = changedTaskData.keySet();
            TreeSet sks = new TreeSet(ks);
            taskID = ((Integer)sks.last()).toString();
        }
        return taskID;
    }

    public String createXmlRpcTask() throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test XMLRPC getBugData";
            }

            public String getDescription() {
                return "The Description of the XMLRPC getBugData Bug";
            }
        };
        TaskAttribute flagA = null;
        TaskAttribute flagB = null;
        TaskAttribute flagC = null;
        TaskAttribute flagD = null;
        TaskAttribute stateA = null;
        TaskAttribute stateB = null;
        TaskAttribute stateC = null;
        TaskAttribute stateD = null;
        TaskData taskDataNew = this.createTaskData((ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null);
        RepositoryResponse response = this.createNewTask(taskDataNew);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (Object)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.getTask(taskId);
        Assert.assertNotNull((Object)task);
        TaskData taskData = this.fixture.connector().getTaskData(this.repository(), task.getTaskId(), null);
        Assert.assertNotNull((Object)taskData);
        TaskAttribute attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        String fileName = "test-attach-1.txt";
        File attachFile = new File(fileName);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        BufferedWriter write = new BufferedWriter(new FileWriter(attachFile));
        write.write("test file from " + System.currentTimeMillis());
        write.close();
        FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("text/plain");
        attachment.setDescription("Description");
        attachment.setName("My Attachment 1");
        this.priviledgedClient().postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        taskData = this.fixture.getTask(taskData.getTaskId(), this.priviledgedClient());
        Assert.assertNotNull((Object)taskData);
        TaskAttribute attachmentAttribute = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        int flagCount = 0;
        int flagCountUnused = 0;
        TaskAttribute attachmentFlag1 = null;
        TaskAttribute attachmentFlag2 = null;
        for (TaskAttribute attribute : attachmentAttribute.getAttributes().values()) {
            if (!attribute.getId().startsWith("task.common.kind.flag")) continue;
            ++flagCount;
            if (!attribute.getId().startsWith("task.common.kind.flag_type")) continue;
            ++flagCountUnused;
            TaskAttribute stateAttribute = taskData.getAttributeMapper().getAssoctiatedAttribute(attribute);
            if (stateAttribute.getMetaData().getLabel().equals("AttachmentFlag1")) {
                attachmentFlag1 = attribute;
            }
            if (!stateAttribute.getMetaData().getLabel().equals("AttachmentFlag2")) continue;
            attachmentFlag2 = attribute;
        }
        Assert.assertEquals((long)2L, (long)flagCount);
        Assert.assertEquals((long)2L, (long)flagCountUnused);
        Assert.assertNotNull(attachmentFlag1);
        Assert.assertNotNull(attachmentFlag2);
        TaskAttribute stateAttribute1 = taskData.getAttributeMapper().getAssoctiatedAttribute(attachmentFlag1);
        stateAttribute1.setValue("?");
        TaskAttribute requestee = attachmentFlag1.getAttribute("requestee");
        requestee.setValue("guest@mylyn.eclipse.org");
        this.priviledgedClient().postUpdateAttachment(attachmentAttribute, "update", null);
        task = this.getTask(taskId);
        Assert.assertNotNull((Object)task);
        taskData = this.fixture.connector().getTaskData(this.repository(), task.getTaskId(), null);
        Assert.assertNotNull((Object)taskData);
        for (TaskAttribute taskAttribute : taskData.getRoot().getAttributes().values()) {
            if (!taskAttribute.getId().startsWith("task.common.kind.flag")) continue;
            TaskAttribute state = taskAttribute.getAttribute("state");
            if (state.getMetaData().getLabel().equals("BugFlag1")) {
                flagA = taskAttribute;
                stateA = state;
                continue;
            }
            if (state.getMetaData().getLabel().equals("BugFlag2")) {
                flagB = taskAttribute;
                stateB = state;
                continue;
            }
            if (state.getMetaData().getLabel().equals("BugFlag3")) {
                flagC = taskAttribute;
                stateC = state;
                continue;
            }
            if (!state.getMetaData().getLabel().equals("BugFlag4")) continue;
            flagD = taskAttribute;
            stateD = state;
        }
        Assert.assertNotNull(flagA);
        Assert.assertNotNull(flagB);
        Assert.assertNotNull(flagC);
        Assert.assertNotNull(flagD);
        Assert.assertNotNull(stateA);
        Assert.assertNotNull(stateB);
        Assert.assertNotNull(stateC);
        Assert.assertNotNull(stateD);
        if (flagD != null) {
            TaskAttribute requesteeD = flagD.getAttribute("requestee");
            requesteeD.setValue("guest@mylyn.eclipse.org");
        }
        if (stateA != null) {
            stateA.setValue("+");
        }
        if (stateB != null) {
            stateB.setValue("?");
        }
        if (stateC != null) {
            stateC.setValue("?");
        }
        if (stateD != null) {
            stateD.setValue("?");
        }
        TaskAttribute cf_freetext = taskData.getRoot().getAttribute("cf_freetext");
        TaskAttribute cf_dropdown = taskData.getRoot().getAttribute("cf_dropdown");
        TaskAttribute cf_largetextbox = taskData.getRoot().getAttribute("cf_largetextbox");
        TaskAttribute cf_multiselect = taskData.getRoot().getAttribute("cf_multiselect");
        TaskAttribute cf_datetime = taskData.getRoot().getAttribute("cf_datetime");
        TaskAttribute cf_bugid = taskData.getRoot().getAttribute("cf_bugid");
        cf_freetext.setValue("Freetext");
        cf_dropdown.setValue("one");
        cf_largetextbox.setValue("large text box");
        cf_multiselect.setValue("Blue");
        cf_datetime.setValue("2012-01-01 00:00:00");
        String cf_bugidValue = this.taskCfBugIdExists();
        if (cf_bugidValue == null) {
            cf_bugidValue = this.createCfBugIdTask();
        }
        cf_bugid.setValue(cf_bugidValue);
        response = this.fixture.submitTask(taskData, this.priviledgedClient());
        return taskId;
    }

    public String taskAttachmentAttributesExists() {
        String taskID = null;
        String queryUrlString = String.valueOf(this.repository().getRepositoryUrl()) + "/buglist.cgi?" + "short_desc=test%20Bug%20with%20Attachment&resolution=---&query_format=advanced" + "&short_desc_type=casesubstring&component=ManualC2&product=ManualTest";
        RepositoryQuery query = new RepositoryQuery(this.repository().getConnectorKind(), "handle-testQueryViaConnector");
        query.setUrl(queryUrlString);
        final HashMap changedTaskData = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.put(Integer.valueOf(taskData.getTaskId()), taskData);
            }
        };
        this.connector().performQuery(this.repository(), (IRepositoryQuery)query, collector, null, (IProgressMonitor)new NullProgressMonitor());
        if (changedTaskData.size() > 0) {
            Set ks = changedTaskData.keySet();
            TreeSet sks = new TreeSet(ks);
            taskID = ((Integer)sks.last()).toString();
        }
        return taskID;
    }

    public String createAttachmentAttributesTask() throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "ManualTest";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "ManualC2";
            }

            public String getSummary() {
                return "test Bug with Attachment";
            }

            public String getDescription() {
                return "The Description of the test with Attachment Bug";
            }
        };
        TaskData taskDataNew = this.createTaskData((ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null);
        RepositoryResponse response = this.createNewTask(taskDataNew);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (Object)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.getTask(taskId);
        Assert.assertNotNull((Object)task);
        TaskData taskData = this.fixture.connector().getTaskData(this.repository(), task.getTaskId(), null);
        Assert.assertNotNull((Object)taskData);
        TaskAttribute attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        String fileName = "test-attach-1.txt";
        File attachFile = File.createTempFile("test-attach", null);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        BufferedWriter write = new BufferedWriter(new FileWriter(attachFile));
        write.write("test file from " + System.currentTimeMillis());
        write.close();
        FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("text/plain");
        attachment.setDescription("My Attachment 1");
        attachment.setName("My Attachment 1");
        this.priviledgedClient().postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        taskData = this.fixture.getTask(taskData.getTaskId(), this.priviledgedClient());
        Assert.assertNotNull((Object)taskData);
        task = this.getTask(taskId);
        Assert.assertNotNull((Object)task);
        taskData = this.fixture.connector().getTaskData(this.repository(), task.getTaskId(), null);
        Assert.assertNotNull((Object)taskData);
        attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        fileName = "test-attach-2.txt";
        attachFile = new File(fileName);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        write = new BufferedWriter(new FileWriter(attachFile));
        write.write("test file 2 from " + System.currentTimeMillis());
        write.close();
        attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("text/plain");
        attachment.setDescription("My Attachment 2");
        attachment.setName("My Attachment 2");
        this.priviledgedClient().postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        taskData = this.fixture.getTask(taskData.getTaskId(), this.priviledgedClient());
        Assert.assertNotNull((Object)taskData);
        task = this.getTask(taskId);
        Assert.assertNotNull((Object)task);
        taskData = this.fixture.connector().getTaskData(this.repository(), task.getTaskId(), null);
        Assert.assertNotNull((Object)taskData);
        attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        fileName = "test-attach-3.txt";
        attachFile = new File(fileName);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        write = new BufferedWriter(new FileWriter(attachFile));
        write.write("test file 3 from " + System.currentTimeMillis());
        write.close();
        attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("text/plain");
        attachment.setDescription("My Attachment 3");
        attachment.setName("My Attachment 3");
        TaskAttribute child = attrAttachment.createMappedAttribute("task.common.attachment.patch");
        if (child != null) {
            child.setValue("1");
        }
        this.priviledgedClient().postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        taskData = this.fixture.getTask(taskData.getTaskId(), this.priviledgedClient());
        Assert.assertNotNull((Object)taskData);
        task = this.getTask(taskId);
        Assert.assertNotNull((Object)task);
        taskData = this.fixture.connector().getTaskData(this.repository(), task.getTaskId(), null);
        Assert.assertNotNull((Object)taskData);
        attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        fileName = "test-attach-4.txt";
        attachFile = new File(fileName);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        write = new BufferedWriter(new FileWriter(attachFile));
        write.write("test file 4 from " + System.currentTimeMillis());
        write.close();
        attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("text/plain");
        attachment.setDescription("My Attachment 4");
        attachment.setName("My Attachment 4");
        child = attrAttachment.createMappedAttribute("task.common.attachment.patch");
        if (child != null) {
            child.setValue("1");
        }
        this.priviledgedClient().postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        taskData = this.fixture.getTask(taskData.getTaskId(), this.priviledgedClient());
        Assert.assertNotNull((Object)taskData);
        TaskAttribute attachment1 = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(1);
        Assert.assertNotNull((Object)attachment1);
        TaskAttribute obsolete = attachment1.getMappedAttribute("task.common.attachment.deprecated");
        Assert.assertNotNull((Object)obsolete);
        obsolete.setValue("1");
        ((BugzillaTaskDataHandler)this.connector().getTaskDataHandler()).postUpdateAttachment(this.repository(), attachment1, "update", (IProgressMonitor)new NullProgressMonitor());
        task = this.getTask(taskId);
        Assert.assertNotNull((Object)task);
        taskData = this.fixture.connector().getTaskData(this.repository(), task.getTaskId(), null);
        Assert.assertNotNull((Object)taskData);
        TaskAttribute attachment2 = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(3);
        Assert.assertNotNull((Object)attachment);
        obsolete = attachment2.getMappedAttribute("task.common.attachment.deprecated");
        Assert.assertNotNull((Object)obsolete);
        obsolete.setValue("1");
        ((BugzillaTaskDataHandler)this.connector().getTaskDataHandler()).postUpdateAttachment(this.repository(), attachment2, "update", (IProgressMonitor)new NullProgressMonitor());
        return taskId;
    }

    public String taskCustomFieldExists() {
        String taskID = null;
        String queryUrlString = String.valueOf(this.repository().getRepositoryUrl()) + "/buglist.cgi?" + "short_desc=test%20Bug%20with%20Custom%20Fields&resolution=---&query_format=advanced" + "&short_desc_type=casesubstring&component=ManualC2&product=ManualTest";
        RepositoryQuery query = new RepositoryQuery(this.repository().getConnectorKind(), "handle-testQueryViaConnector");
        query.setUrl(queryUrlString);
        final HashMap changedTaskData = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.put(Integer.valueOf(taskData.getTaskId()), taskData);
            }
        };
        this.connector().performQuery(this.repository(), (IRepositoryQuery)query, collector, null, (IProgressMonitor)new NullProgressMonitor());
        if (changedTaskData.size() > 0) {
            Set ks = changedTaskData.keySet();
            TreeSet sks = new TreeSet(ks);
            taskID = ((Integer)sks.last()).toString();
        }
        return taskID;
    }

    public String createCustomFieldTask() throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "ManualTest";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "ManualC2";
            }

            public String getSummary() {
                return "test Bug with Custom Fields";
            }

            public String getDescription() {
                return "The Description of the test with Custom Fields Bug";
            }
        };
        TaskData taskDataNew = this.createTaskData((ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null);
        RepositoryResponse response = this.createNewTask(taskDataNew);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (Object)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.getTask(taskId);
        Assert.assertNotNull((Object)task);
        TaskData taskData = this.fixture.connector().getTaskData(this.repository(), task.getTaskId(), null);
        Assert.assertNotNull((Object)taskData);
        TaskMapper mapper = new TaskMapper(taskData);
        TaskAttribute cf_multiselect = mapper.getTaskData().getRoot().getAttribute("cf_multiselect");
        cf_multiselect.setValue("Green");
        response = this.fixture.submitTask(taskData, this.priviledgedClient());
        return taskId;
    }

    public ArrayList<String> taskMissingHitsExists() {
        ArrayList<String> taskIDs = new ArrayList<String>();
        String queryUrlString = String.valueOf(this.repository().getRepositoryUrl()) + "/buglist.cgi?" + "short_desc=test%20Missing%20Hits&resolution=---&query_format=advanced" + "&short_desc_type=casesubstring&component=ManualC2&product=ManualTest";
        RepositoryQuery query = new RepositoryQuery(this.repository().getConnectorKind(), "handle-testQueryViaConnector");
        query.setUrl(queryUrlString);
        final HashMap changedTaskData = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.put(Integer.valueOf(taskData.getTaskId()), taskData);
            }
        };
        this.connector().performQuery(this.repository(), (IRepositoryQuery)query, collector, null, (IProgressMonitor)new NullProgressMonitor());
        if (changedTaskData.size() > 0) {
            Set ks = changedTaskData.keySet();
            TreeSet sks = new TreeSet(ks);
            for (Integer integer : sks) {
                taskIDs.add("" + integer);
            }
        }
        return taskIDs;
    }

    public void createMissingHitsTask() throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "ManualTest";
            }
        };
        TaskMapping taskMappingSelect1 = new TaskMapping(){

            public String getComponent() {
                return "ManualC2";
            }

            public String getSummary() {
                return "test Missing Hits 1";
            }

            public String getDescription() {
                return "The Description of the test Missing Hits 1";
            }
        };
        TaskMapping taskMappingSelect2 = new TaskMapping(){

            public String getComponent() {
                return "ManualC2";
            }

            public String getSummary() {
                return "test Missing Hits 2";
            }

            public String getDescription() {
                return "The Description of the test Missing Hits 2";
            }
        };
        TaskMapping taskMappingSelect3 = new TaskMapping(){

            public String getComponent() {
                return "ManualC2";
            }

            public String getSummary() {
                return "test Missing Hits 3";
            }

            public String getDescription() {
                return "The Description of the test Missing Hits 3";
            }
        };
        this.createTask(taskMappingInit, taskMappingSelect1);
        this.createTask(taskMappingInit, taskMappingSelect2);
        this.createTask(taskMappingInit, taskMappingSelect3);
    }

    private String createTask(TaskMapping taskMappingInit, TaskMapping taskMappingSelect) throws Exception {
        TaskData taskDataNew = this.createTaskData((ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null);
        RepositoryResponse response = this.createNewTask(taskDataNew);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (Object)response.getReposonseKind().toString());
        return response.getTaskId();
    }

    public String taskAliasExists() {
        String taskID = null;
        String queryUrlString = String.valueOf(this.repository().getRepositoryUrl()) + "/buglist.cgi?" + "short_desc=test%20Alias%20Bug&resolution=---&query_format=advanced" + "&short_desc_type=casesubstring&component=TestComponent&product=TestProduct";
        RepositoryQuery query = new RepositoryQuery(this.repository().getConnectorKind(), "handle-testQueryViaConnector");
        query.setUrl(queryUrlString);
        final HashMap changedTaskData = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.put(Integer.valueOf(taskData.getTaskId()), taskData);
            }
        };
        this.connector().performQuery(this.repository(), (IRepositoryQuery)query, collector, null, (IProgressMonitor)new NullProgressMonitor());
        if (changedTaskData.size() > 0) {
            Set ks = changedTaskData.keySet();
            TreeSet sks = new TreeSet(ks);
            taskID = ((Integer)sks.last()).toString();
        }
        return taskID;
    }

    public String createAliasTask() throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test Alias Bug";
            }

            public String getDescription() {
                return "The Description of the Alias Bug";
            }
        };
        TaskData taskDataNew = this.createTaskData((ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null);
        TaskAttribute alias = taskDataNew.getRoot().getAttribute("alias");
        if (alias == null) {
            alias = taskDataNew.getRoot().createAttribute("alias");
        }
        alias.setValue("Fritz");
        RepositoryResponse response = this.createNewTask(taskDataNew);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (Object)response.getReposonseKind().toString());
        return response.getTaskId();
    }

    public String taskAlias2Exists() {
        String taskID = null;
        String queryUrlString = String.valueOf(this.repository().getRepositoryUrl()) + "/buglist.cgi?" + "short_desc=test%20Alias%20Bug2&resolution=---&query_format=advanced" + "&short_desc_type=casesubstring&component=TestComponent&product=TestProduct";
        RepositoryQuery query = new RepositoryQuery(this.repository().getConnectorKind(), "handle-testQueryViaConnector");
        query.setUrl(queryUrlString);
        final HashMap changedTaskData = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.put(Integer.valueOf(taskData.getTaskId()), taskData);
            }
        };
        this.connector().performQuery(this.repository(), (IRepositoryQuery)query, collector, null, (IProgressMonitor)new NullProgressMonitor());
        if (changedTaskData.size() > 0) {
            Set ks = changedTaskData.keySet();
            TreeSet sks = new TreeSet(ks);
            taskID = ((Integer)sks.last()).toString();
        }
        return taskID;
    }

    public String createAliasTask2() throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test Alias Bug2";
            }

            public String getDescription() {
                return "The Description of the Alias Bug";
            }
        };
        TaskData taskDataNew = this.createTaskData((ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null);
        RepositoryResponse response = this.createNewTask(taskDataNew);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (Object)response.getReposonseKind().toString());
        return response.getTaskId();
    }

    public String taskCfBugIdExists() {
        String taskID = null;
        String queryUrlString = String.valueOf(this.repository().getRepositoryUrl()) + "/buglist.cgi?" + "short_desc=test%20CF%20Bug%20ID%20Bug&resolution=---&query_format=advanced" + "&short_desc_type=casesubstring&component=TestComponent&product=TestProduct";
        RepositoryQuery query = new RepositoryQuery(this.repository().getConnectorKind(), "handle-testQueryViaConnector");
        query.setUrl(queryUrlString);
        final HashMap changedTaskData = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.put(Integer.valueOf(taskData.getTaskId()), taskData);
            }
        };
        this.connector().performQuery(this.repository(), (IRepositoryQuery)query, collector, null, (IProgressMonitor)new NullProgressMonitor());
        if (changedTaskData.size() > 0) {
            Set ks = changedTaskData.keySet();
            TreeSet sks = new TreeSet(ks);
            taskID = ((Integer)sks.last()).toString();
        }
        return taskID;
    }

    public String createCfBugIdTask() throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test CF Bug ID Bug";
            }

            public String getDescription() {
                return "The Description of the CF Bug ID Bug";
            }
        };
        TaskData taskDataNew = this.createTaskData((ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null);
        RepositoryResponse response = this.createNewTask(taskDataNew);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (Object)response.getReposonseKind().toString());
        return response.getTaskId();
    }

    public String enhanceSearchTaskExists() {
        String taskID = null;
        String queryUrlString = String.valueOf(this.repository().getRepositoryUrl()) + "/buglist.cgi?" + "short_desc=test%20EnhanceSearch&resolution=---&query_format=advanced" + "&short_desc_type=casesubstring&component=TestComponent&product=TestProduct";
        RepositoryQuery query = new RepositoryQuery(this.repository().getConnectorKind(), "handle-testQueryViaConnector");
        query.setUrl(queryUrlString);
        final HashMap changedTaskData = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.put(Integer.valueOf(taskData.getTaskId()), taskData);
            }
        };
        this.connector().performQuery(this.repository(), (IRepositoryQuery)query, collector, null, (IProgressMonitor)new NullProgressMonitor());
        if (changedTaskData.size() > 0) {
            Set ks = changedTaskData.keySet();
            TreeSet sks = new TreeSet(ks);
            taskID = ((Integer)sks.last()).toString();
        }
        return taskID;
    }

    public String createEnhanceSearchTask() throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test EnhanceSearch";
            }

            public String getDescription() {
                return "The Description of the Bug 335278";
            }
        };
        TaskData[] taskDataNew = new TaskData[]{TasksUiInternal.createTaskData((TaskRepository)this.repository(), (ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null)};
        ITask taskNew = TasksUiUtil.createOutgoingNewTask((String)taskDataNew[0].getConnectorKind(), (String)taskDataNew[0].getRepositoryUrl());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        HashSet changed = new HashSet();
        workingCopy.save(changed, null);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskDataNew[0], this.priviledgedClient());
        ((AbstractTask)taskNew).setSubmitting(true);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (Object)response.getReposonseKind().toString());
        return response.getTaskId();
    }
}

