/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.ui.search.StackTraceDuplicateDetector;

public class StackTraceDuplicateDetectorTest
extends TestCase {
    public void testStackTrace() throws Exception {
        String stackTrace = "java.lang.NullPointerException\nat jeff.testing.stack.trace.functionality(jeff.java:481)";
        StackTraceDuplicateDetectorTest.assertNotNull((Object)StackTraceDuplicateDetector.getStackTraceFromDescription((String)stackTrace));
    }

    public void testNoStackTrace() throws Exception {
        String stackTrace = "this is not really a stacktrace";
        StackTraceDuplicateDetectorTest.assertNull((Object)StackTraceDuplicateDetector.getStackTraceFromDescription((String)stackTrace));
    }

    public void testStackTraceWithAppendedText() throws Exception {
        String stackTrace = "java.lang.NullPointerException\nat jeff.testing.stack.trace.functionality(jeff.java:481)";
        String extraText = "\nExtra text that isnt' part of the stack trace java:";
        StackTraceDuplicateDetectorTest.assertEquals((String)(String.valueOf(stackTrace) + "\n"), (String)StackTraceDuplicateDetector.getStackTraceFromDescription((String)(String.valueOf(extraText) + "\n" + stackTrace + "\n")));
    }

    public void testStackTraceMisaligned() throws Exception {
        String stackTrace = "java.lang.IllegalStateException: zip file closed\n     at java.util.zip.ZipFile.ensureOpen (ZipFile.java:518)\nat java.util.zip.ZipFile.getEntry (ZipFile.java:251)\n   at java.util.jar.JarFile.getEntry(JarFile.java:200)\nat sun.net.www.protocol.jar.URLJarFile.getEntry\n     (URLJarFile.java:90)\nat sun.net.www.protocol.jar.JarURLConnection.connect(JarURLConnection.java:112)\nat sun.net.www.protocol.jar.JarURLConnection.getInputStream\n(JarURLConnection.java:124)\nat org.eclipse.jdt.internal.core.JavaElement\n.getURLContents(JavaElement.java:734)";
        StackTraceDuplicateDetectorTest.assertEquals((String)stackTrace, (String)StackTraceDuplicateDetector.getStackTraceFromDescription((String)stackTrace));
    }

    public void testStackTraceSUN() throws Exception {
        String stackTrace = "java.lang.IllegalStateException: zip file closed\n     at java.util.zip.ZipFile.ensureOpen(ZipFile.java:518)\n     at java.util.zip.ZipFile.getEntry(ZipFile.java:251)\n     at java.util.jar.JarFile.getEntry(JarFile.java:200)\n     at sun.net.www.protocol.jar.URLJarFile.getEntry(URLJarFile.java:90)\n     at sun.net.www.protocol.jar.JarURLConnection.connect(JarURLConnection.java:112)\n     at sun.net.www.protocol.jar.JarURLConnection.getInputStream(JarURLConnection.java:124)\n     at org.eclipse.jdt.internal.core.JavaElement.getURLContents(JavaElement.java:734)";
        StackTraceDuplicateDetectorTest.assertEquals((String)stackTrace, (String)StackTraceDuplicateDetector.getStackTraceFromDescription((String)stackTrace));
    }

    public void testStackTraceGCJ() throws Exception {
        String stackTrace = "java.lang.Error: Something bad happened\n\t   at testcase.main(java.lang.String[]) (Unknown Source)\n\t   at gnu.java.lang.MainThread.call_main() (/usr/lib/libgcj.so.6.0.0)\n\t   at gnu.java.lang.MainThread.run() (/usr/lib/libgcj.so.6.0.0)";
        StackTraceDuplicateDetectorTest.assertEquals((String)stackTrace, (String)StackTraceDuplicateDetector.getStackTraceFromDescription((String)stackTrace));
    }

    public void testStackTraceNoLineNums() throws Exception {
        String stackTrace = "java.lang.Error: Something bad happened\n\tat testcase.main (testcase.java)\n\tat java.lang.reflect.Method.Invoke (Method.java)";
        StackTraceDuplicateDetectorTest.assertEquals((String)stackTrace, (String)StackTraceDuplicateDetector.getStackTraceFromDescription((String)stackTrace));
    }

    public void testStackTraceJRockit() throws Exception {
        String stackTrace = "java.lang.Error: Something bad happened\n\tat java/io/BufferedReader.readLine(BufferedReader.java:331)\n\tat java/io/BufferedReader.readLine(BufferedReader.java:362)\n\tat java/util/Properties.load(Properties.java:192)\n\tat java/util/logging/LogManager.readConfiguration(L:555)";
        StackTraceDuplicateDetectorTest.assertEquals((String)stackTrace, (String)StackTraceDuplicateDetector.getStackTraceFromDescription((String)stackTrace));
    }

    public void testStackTraceOther() throws Exception {
        String stackTrace = "java.lang.Error: Something bad happened\n\t   at testcase.main (testcase.java:3)\n\t   at java.lang.VirtualMachine.invokeMain (VirtualMachine.java)\n\t   at java.lang.VirtualMachine.main (VirtualMachine.java:108)";
        StackTraceDuplicateDetectorTest.assertEquals((String)stackTrace, (String)StackTraceDuplicateDetector.getStackTraceFromDescription((String)stackTrace));
    }
}

