/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import junit.framework.TestCase;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;

public class AbstractRepositoryConnectorUiTest
extends TestCase {
    private AbstractRepositoryConnectorUi connectorUi;
    private TaskRepository repository;
    private TaskAttribute commentAttribute;
    private MockTask task;

    protected void setUp() throws Exception {
        MockRepositoryConnector connector = new MockRepositoryConnector();
        this.connectorUi = new MockRepositoryConnectorUi(connector);
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        this.task = new MockTask("1");
        TaskAttributeMapper mapper = new TaskAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, "mock", "http://mockrepository.test", "1");
        this.commentAttribute = taskData.getRoot().createAttribute("comment");
    }

    public void testGetReplyTextDescription() throws Exception {
        TaskTask task = new TaskTask("abc", "http://eclipse.org/mylyn", "1");
        String replyText = this.connectorUi.getReplyText(null, (ITask)task, null, false);
        AbstractRepositoryConnectorUiTest.assertEquals((String)"(In reply to comment #0)", (String)replyText);
    }

    public void testGetReplyTextSpecificComment() throws Exception {
        TaskComment taskComment = new TaskComment(this.repository, (ITask)this.task, this.commentAttribute){

            public int getNumber() {
                return 13;
            }
        };
        String replyText = this.connectorUi.getReplyText(null, (ITask)this.task, (ITaskComment)taskComment, false);
        AbstractRepositoryConnectorUiTest.assertEquals((String)"(In reply to comment #13)", (String)replyText);
    }

    public void testGetReplyTextSpecificCommentOnTask() throws Exception {
        TaskComment taskComment = new TaskComment(this.repository, (ITask)this.task, this.commentAttribute){

            public int getNumber() {
                return 13;
            }
        };
        String replyText = this.connectorUi.getReplyText(null, (ITask)this.task, (ITaskComment)taskComment, true);
        AbstractRepositoryConnectorUiTest.assertEquals((String)"(In reply to 1 comment #13)", (String)replyText);
    }

    public void testGetImageDescriptor() {
        TaskTask task = new TaskTask("mock", "http://connector.url", "1");
        task.setOwner("TaskOwner");
        ImageDescriptor desc = this.connectorUi.getImageDescriptor((IRepositoryElement)task);
        AbstractRepositoryConnectorUiTest.assertNotNull((Object)desc);
        AbstractRepositoryConnectorUiTest.assertEquals((Object)TasksUiImages.TASK, (Object)desc);
    }

    public void testGetImageDescriptorOwnedByMe() {
        TaskRepository repository = new TaskRepository("mock", "http://connector.url");
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("RepoUser", "SecretPassword"), false);
        try {
            TasksUiPlugin.getRepositoryManager().addRepository(repository);
            TaskTask task = new TaskTask("mock", "http://connector.url", "1");
            task.setOwner("RepoUser");
            ImageDescriptor desc = this.connectorUi.getImageDescriptor((IRepositoryElement)task);
            AbstractRepositoryConnectorUiTest.assertNotNull((Object)desc);
            AbstractRepositoryConnectorUiTest.assertEquals((Object)TasksUiImages.TASK_OWNED, (Object)desc);
        }
        finally {
            TasksUiPlugin.getRepositoryManager().removeRepository(repository);
        }
    }

    public void testGetImageDescriptorOwnedNotByMe() {
        TaskRepository repository = new TaskRepository("mock", "http://connector.url");
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("RepoUser", "SecretPassword"), false);
        try {
            TasksUiPlugin.getRepositoryManager().addRepository(repository);
            TaskTask task = new TaskTask("mock", "http://connector.url", "1");
            task.setOwner("AnotherRepoUser");
            ImageDescriptor desc = this.connectorUi.getImageDescriptor((IRepositoryElement)task);
            AbstractRepositoryConnectorUiTest.assertNotNull((Object)desc);
            AbstractRepositoryConnectorUiTest.assertEquals((Object)TasksUiImages.TASK, (Object)desc);
        }
        finally {
            TasksUiPlugin.getRepositoryManager().removeRepository(repository);
        }
    }
}

