/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui.editor;

import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.PlanningPart;

public class PlanningPartTest
extends TestCase {
    private static final int DAY = 86400000;
    private static final long WEEK = 604800000L;

    public void testGetLabelWeek() {
        WeekDateRange range = TaskActivityUtil.getCurrentWeek();
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_This_Week, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getWeekOf((Date)new Date(0L));
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_This_Week, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getNextWeek();
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Next_Week, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getWeekOf((Date)new Date(System.currentTimeMillis() + 604800000L));
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Next_Week, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getWeekOf((Date)new Date(System.currentTimeMillis() + 1209600000L));
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Later, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getWeekOf((Date)new Date(System.currentTimeMillis() + 1814400000L));
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Later, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getWeekOf((Date)new Date(System.currentTimeMillis() - 604800000L));
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_This_Week, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getWeekOf((Date)new Date(System.currentTimeMillis() - 1209600000L));
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_This_Week, (String)PlanningPart.getLabel((DateRange)range));
    }

    public void testGetLabelDay() {
        DayDateRange range = TaskActivityUtil.getDayOf((Date)new Date());
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Today, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getDayOf((Date)new Date(System.currentTimeMillis() - 86400000L));
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Today, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getDayOf((Date)TaskActivityUtil.getCurrentWeek().getStartDate().getTime());
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Today, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getDayOf((Date)new Date(0L));
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Today, (String)PlanningPart.getLabel((DateRange)range));
        Calendar cal = TaskActivityUtil.getCalendar();
        if (cal.get(7) != TaskActivityUtil.getLastDayOfWeek((Calendar)cal)) {
            range = TaskActivityUtil.getDayOf((Date)new Date(System.currentTimeMillis() + 86400000L));
            PlanningPartTest.assertEquals((String)Messages.PlanningPart_This_Week, (String)PlanningPart.getLabel((DateRange)range));
        }
        range = TaskActivityUtil.getDayOf((Date)new Date(System.currentTimeMillis() + 604800000L));
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Next_Week, (String)PlanningPart.getLabel((DateRange)range));
        cal = TaskActivityUtil.getNextWeek().getEndDate();
        cal.add(6, 1);
        range = TaskActivityUtil.getDayOf((Date)cal.getTime());
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Later, (String)PlanningPart.getLabel((DateRange)range));
        range = TaskActivityUtil.getDayOf((Date)new Date(System.currentTimeMillis() + 1209600000L));
        PlanningPartTest.assertEquals((String)Messages.PlanningPart_Later, (String)PlanningPart.getLabel((DateRange)range));
    }
}

