/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.core;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.RefactorRepositoryUrlOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class TracRepositoryQueryTest
extends TestCase {
    public void testChangeRepositoryUrl() throws Exception {
        TaskRepository repository = new TaskRepository("trac", "http://mylyn.org/trac-one");
        TracSearch search = new TracSearch();
        String queryUrl = String.valueOf(repository.getRepositoryUrl()) + "/query?format=tab" + search.toUrl();
        IRepositoryQuery query = TasksUi.getRepositoryModel().createRepositoryQuery(repository);
        query.setUrl(queryUrl);
        TasksUiPlugin.getTaskList().addQuery((RepositoryQuery)query);
        String taskId = "123";
        ITask task = TasksUi.getRepositoryModel().createTask(repository, taskId);
        task.setUrl(String.valueOf(repository.getRepositoryUrl()) + "/ticket/" + taskId);
        TasksUiPlugin.getTaskList().addTask(task);
        String oldUrl = repository.getRepositoryUrl();
        String newUrl = "http://mylyn.org/trac-two";
        new RefactorRepositoryUrlOperation(oldUrl, newUrl).run((IProgressMonitor)new NullProgressMonitor());
        repository.setRepositoryUrl(newUrl);
        TracRepositoryQueryTest.assertEquals((String)newUrl, (String)query.getRepositoryUrl());
        TracRepositoryQueryTest.assertEquals((String)(String.valueOf(newUrl) + "/query?format=tab" + search.toUrl()), (String)query.getUrl());
        TracRepositoryQueryTest.assertEquals((String)(String.valueOf(newUrl) + "/ticket/" + taskId), (String)task.getUrl());
    }
}

