/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.index.tests;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.eclipse.mylyn.internal.tasks.index.tests.AbstractTaskListIndexTest;
import org.eclipse.mylyn.tasks.core.ITask;
import org.junit.Assert;
import org.junit.Test;

public class TaskListIndexCorruptTest
extends AbstractTaskListIndexTest {
    private void setupCorruptIndex() throws Exception {
        this.setupIndex();
        this.context.createLocalTask();
        this.index.waitUntilIdle();
        this.index.close();
        this.disposeIndex();
        this.corruptIndex();
    }

    private void corruptIndex() throws IOException {
        File[] files = this.tempDir.listFiles();
        if (files == null || files.length == 0) {
            throw new IllegalStateException("index has no files");
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                this.corruptFile(file);
            }
            ++n2;
        }
    }

    private void corruptFile(File file) throws IOException {
        Random random = new Random(123L);
        long length = file.length();
        Throwable throwable = null;
        Object var6_6 = null;
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            byte[] bytes = new byte[1];
            long i = 0L;
            while (i < length) {
                random.nextBytes(bytes);
                ((OutputStream)stream).write(bytes[0]);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testCorrupt() throws Exception {
        this.setupCorruptIndex();
        this.setupIndex();
        ITask task = this.context.createLocalTask();
        this.index.waitUntilIdle();
        Assert.assertTrue((boolean)this.index.matches(task, task.getSummary()));
    }
}

