/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.PersonContentProposal;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryQuery;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class PersonProposalProviderTest
extends TestCase {
    private static final Comparator<IContentProposal> CONTENT_COMPARATOR = new Comparator<IContentProposal>(){

        @Override
        public int compare(IContentProposal o1, IContentProposal o2) {
            return o1.getContent().compareTo(o2.getContent());
        }
    };

    protected void setUp() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
    }

    protected void tearDown() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
    }

    public void testGetProposalsNullParameters() {
        PersonProposalProvider provider = new PersonProposalProvider(null, null);
        IContentProposal[] result = provider.getProposals("", 0);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)0, (int)result.length);
        result = provider.getProposals(" ", 1);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)0, (int)result.length);
    }

    public void testGetProposalsNullContents() throws Exception {
        PersonProposalProvider provider = new PersonProposalProvider("http://mockrepository.test", "mock");
        try {
            provider.getProposals(null, 0);
            PersonProposalProviderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidPosition() throws Exception {
        PersonProposalProvider provider = new PersonProposalProvider("http://mockrepository.test", "mock");
        try {
            provider.getProposals("", -1);
            PersonProposalProviderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetProposalsTask() {
        MockTask task = new MockTask(null, "1", null);
        task.setOwner("foo");
        PersonProposalProvider provider = new PersonProposalProvider((AbstractTask)task, null);
        PersonProposalProviderTest.assertProposalsForFoo(provider);
    }

    public void testGetProposalsTaskDataWithReporter() {
        MockTask task = new MockTask(null, "1", null);
        TaskData taskData = this.createMockTaskData();
        taskData.getRoot().createMappedAttribute("task.common.user.reporter").setValue("foo");
        taskData.getRoot().getMappedAttribute("task.common.user.reporter").getMetaData().setReadOnly(true);
        PersonProposalProvider provider = new PersonProposalProvider((AbstractTask)task, taskData);
        PersonProposalProviderTest.assertProposalsForFoo(provider);
    }

    public void testGetProposalsTaskDataWithReporterPerson() {
        MockTask task = new MockTask(null, "1", null);
        TaskData taskData = this.createMockTaskData();
        taskData.getRoot().createMappedAttribute("task.common.user.reporter").setValue("foo");
        taskData.getRoot().getMappedAttribute("task.common.user.reporter").getMetaData().setReadOnly(true);
        taskData.getRoot().getMappedAttribute("task.common.user.reporter").getMetaData().setType("person");
        PersonProposalProvider provider = new PersonProposalProvider((AbstractTask)task, taskData);
        PersonProposalProviderTest.assertProposalsForFoo(provider);
    }

    private TaskData createMockTaskData() {
        return new TaskData(new TaskAttributeMapper(TaskTestUtil.createMockRepository()), "mock", "http://mockrepository.test", "1");
    }

    private static void assertProposalsForFoo(PersonProposalProvider provider) {
        IContentProposal[] result = provider.getProposals("", 0);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getContent());
        result = provider.getProposals("a", 1);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)0, (int)result.length);
        result = provider.getProposals("fo", 2);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getContent());
        result = provider.getProposals("", 0);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getContent());
    }

    public void testGetProposalNoOwnerAndNoPerson() throws Exception {
        PersonProposalProvider provider = new PersonProposalProvider("http://mockrepository.test", "mock");
        IContentProposal[] result = provider.getProposals("", 0);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)0, (int)result.length);
    }

    public void testGetProposalsMultipleAddresses() {
        MockTask task = new MockTask(null, "1", null);
        task.setOwner("foo");
        PersonProposalProvider provider = new PersonProposalProvider((AbstractTask)task, null);
        IContentProposal[] result = provider.getProposals("f,xx", 1);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"foo,xx", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)3, (int)result[0].getCursorPosition());
        result = provider.getProposals("f xx", 1);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"foo xx", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)3, (int)result[0].getCursorPosition());
        result = provider.getProposals("a,xx", 1);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)0, (int)result.length);
        result = provider.getProposals("xx,f", 4);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"xx,foo", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)6, (int)result[0].getCursorPosition());
        result = provider.getProposals("xx f", 4);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"xx foo", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)6, (int)result[0].getCursorPosition());
        result = provider.getProposals("xx,a", 4);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)0, (int)result.length);
        result = provider.getProposals("xyz,f,yy", 4);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"xyz,foo,yy", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)7, (int)result[0].getCursorPosition());
        result = provider.getProposals("xx f yy", 4);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"xx foo yy", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)6, (int)result[0].getCursorPosition());
        result = provider.getProposals("xx,a,yy", 4);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)0, (int)result.length);
        result = provider.getProposals("xx,,yy", 3);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"xx,foo,yy", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)6, (int)result[0].getCursorPosition());
        result = provider.getProposals("x yy", 2);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"x foo", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)5, (int)result[0].getCursorPosition());
        result = provider.getProposals(", ", 1);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)",foo ", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)4, (int)result[0].getCursorPosition());
        result = provider.getProposals(", ", 0);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"foo, ", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)3, (int)result[0].getCursorPosition());
    }

    public void testConstructorRepositoryUrlKind() throws Exception {
        MockTask task1 = new MockTask("http://mockrepository.test", "1");
        task1.setOwner("foo");
        PersonProposalProvider provider = new PersonProposalProvider("http://mockrepository.test", "mock");
        MockRepositoryQuery query = new MockRepositoryQuery("summary");
        TasksUiPlugin.getTaskList().addQuery((RepositoryQuery)query);
        TasksUiPlugin.getTaskList().addTask((ITask)task1, (AbstractTaskContainer)query);
        IContentProposal[] result = provider.getProposals("f,xx", 1);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"foo,xx", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"foo", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((int)3, (int)result[0].getCursorPosition());
    }

    public void testCurrentUser() throws Exception {
        TaskTask task = TaskTestUtil.createMockTask("1");
        task.setOwner("user");
        TasksUiPlugin.getTaskList().addTask((ITask)task);
        TaskRepository repository = TaskTestUtil.createMockRepository();
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("user", ""), false);
        TasksUi.getRepositoryManager().addRepository(repository);
        PersonProposalProvider provider = new PersonProposalProvider("http://mockrepository.test", "mock");
        IContentProposal[] result = provider.getProposals("user", 1);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertTrue((boolean)((PersonContentProposal)result[0]).isCurrentUser());
    }

    public void testGetProposalByPrettyName() throws Exception {
        HashMap<String, String> users = new HashMap<String, String>();
        users.put("11", "foo");
        users.put("22", "bar");
        users.put("33", "far");
        users.put("21", "boo");
        MockTask task1 = new MockTask(null, "1", null);
        task1.setOwner("11");
        PersonProposalProvider provider = new PersonProposalProvider((AbstractTask)task1, null, users);
        IContentProposal[] result = provider.getProposals("", 0);
        Arrays.sort(result, CONTENT_COMPARATOR);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)4, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"11", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"21", (String)result[1].getContent());
        PersonProposalProviderTest.assertEquals((String)"22", (String)result[2].getContent());
        PersonProposalProviderTest.assertEquals((String)"33", (String)result[3].getContent());
        result = provider.getProposals("f", 1);
        Arrays.sort(result, CONTENT_COMPARATOR);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)2, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"11", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"33", (String)result[1].getContent());
        result = provider.getProposals("b", 1);
        Arrays.sort(result, CONTENT_COMPARATOR);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)2, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"21", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"22", (String)result[1].getContent());
        result = provider.getProposals("1", 1);
        Arrays.sort(result, CONTENT_COMPARATOR);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"11", (String)result[0].getContent());
        result = provider.getProposals("3", 1);
        Arrays.sort(result, CONTENT_COMPARATOR);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"33", (String)result[0].getContent());
        result = provider.getProposals("2", 1);
        Arrays.sort(result, CONTENT_COMPARATOR);
        PersonProposalProviderTest.assertNotNull((Object)result);
        PersonProposalProviderTest.assertEquals((int)2, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"21", (String)result[0].getContent());
        PersonProposalProviderTest.assertEquals((String)"22", (String)result[1].getContent());
    }

    public void testGetProposalByOwnerId() throws Exception {
        TaskTask task = TaskTestUtil.createMockTask("1");
        task.setOwner("Joel User");
        TasksUiPlugin.getTaskList().addTask((ITask)task);
        TaskRepository repository = TaskTestUtil.createMockRepository();
        TasksUi.getRepositoryManager().addRepository(repository);
        PersonProposalProvider provider = new PersonProposalProvider("http://mockrepository.test", "mock");
        IContentProposal[] result = provider.getProposals("joel", 1);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"Joel User", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((String)"Joel User", (String)result[0].getContent());
        task.setOwnerId("joel.user@mylyn.org");
        provider = new PersonProposalProvider("http://mockrepository.test", "mock");
        result = provider.getProposals("joel", 1);
        PersonProposalProviderTest.assertEquals((int)1, (int)result.length);
        PersonProposalProviderTest.assertEquals((String)"Joel User <joel.user@mylyn.org>", (String)result[0].getLabel());
        PersonProposalProviderTest.assertEquals((String)"joel.user@mylyn.org", (String)result[0].getContent());
        task.setOwnerId("");
        task.setOwner("");
        provider = new PersonProposalProvider("http://mockrepository.test", "mock");
        result = provider.getProposals("joel", 1);
        PersonProposalProviderTest.assertEquals((int)0, (int)result.length);
    }
}

