/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;

public class TaskActivityManagerTest
extends TestCase {
    private TaskActivityManager taskActivityManager;
    private TaskList taskList;
    private TaskRepository repository;
    private AbstractTask task1;
    private AbstractTask task2;

    protected void setUp() throws Exception {
        this.taskActivityManager = TasksUiPlugin.getTaskActivityManager();
        this.taskActivityManager.deactivateActiveTask();
        this.taskActivityManager.clear();
        this.taskList = TasksUiPlugin.getTaskList();
        TaskTestUtil.resetTaskListAndRepositories();
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        TasksUiPlugin.getRepositoryManager().addRepository(this.repository);
    }

    public void testWeekEnd() {
        LocalTask task = new LocalTask("12", "task-12");
        TaskActivityManagerTest.assertFalse((boolean)this.taskActivityManager.isScheduledForToday((AbstractTask)task));
        Calendar end = TaskActivityUtil.getNextWeek().getEndDate();
        Calendar start = TaskActivityUtil.getCalendar();
        start.setTimeInMillis(end.getTimeInMillis());
        TaskActivityUtil.snapStartOfDay((Calendar)start);
        this.taskActivityManager.setScheduledFor((AbstractTask)task, new DateRange(start, end));
        TaskActivityManagerTest.assertTrue((boolean)this.taskActivityManager.isScheduledForNextWeek((AbstractTask)task));
        this.taskActivityManager.setScheduledFor((AbstractTask)task, (DateRange)TaskActivityUtil.getNextWeek());
        TaskActivityManagerTest.assertTrue((boolean)this.taskActivityManager.isScheduledForNextWeek((AbstractTask)task));
        TaskActivityManagerTest.assertEquals((int)0, (int)this.taskActivityManager.getScheduledTasks(new DateRange(start, end)).size());
        end = TaskActivityUtil.getNextWeek().next().getEndDate();
        start = TaskActivityUtil.getCalendar();
        start.setTimeInMillis(end.getTimeInMillis());
        TaskActivityUtil.snapStartOfDay((Calendar)start);
        this.taskActivityManager.setScheduledFor((AbstractTask)task, new DateRange(start, end));
        TaskActivityManagerTest.assertEquals((int)1, (int)this.taskActivityManager.getScheduledTasks(new DateRange(start, end)).size());
        TaskActivityManagerTest.assertEquals((int)1, (int)this.taskActivityManager.getScheduledTasks((DateRange)TaskActivityUtil.getNextWeek().next()).size());
    }

    public void testTaskActivation() {
        MockTask task = new MockTask("test:activation");
        MockTaskActivationListener listener = new MockTaskActivationListener();
        try {
            this.taskActivityManager.addActivationListener((ITaskActivationListener)listener);
            try {
                this.taskActivityManager.activateTask((ITask)task);
                TaskActivityManagerTest.assertTrue((boolean)listener.hasPreActivated);
                TaskActivityManagerTest.assertTrue((boolean)listener.hasActivated);
                TaskActivityManagerTest.assertFalse((boolean)listener.hasPreDeactivated);
                TaskActivityManagerTest.assertFalse((boolean)listener.hasDeactivated);
                listener.reset();
            }
            finally {
                this.taskActivityManager.deactivateTask((ITask)task);
            }
            TaskActivityManagerTest.assertFalse((boolean)listener.hasPreActivated);
            TaskActivityManagerTest.assertFalse((boolean)listener.hasActivated);
            TaskActivityManagerTest.assertTrue((boolean)listener.hasPreDeactivated);
            TaskActivityManagerTest.assertTrue((boolean)listener.hasDeactivated);
        }
        finally {
            this.taskActivityManager.removeActivationListener((ITaskActivationListener)listener);
        }
    }

    public void testTaskActivationExtension() {
        if (MockTaskActivationListenerExtension.INSTANCE != null) {
            MockTaskActivationListenerExtension.INSTANCE.reset();
        }
        MockTask task = new MockTask("test:activation");
        try {
            this.taskActivityManager.activateTask((ITask)task);
            TaskActivityManagerTest.assertNotNull((String)"Expected creation of task activation listener instance", (Object)((Object)MockTaskActivationListenerExtension.INSTANCE));
            TaskActivityManagerTest.assertTrue((boolean)MockTaskActivationListenerExtension.INSTANCE.hasPreActivated);
            TaskActivityManagerTest.assertTrue((boolean)MockTaskActivationListenerExtension.INSTANCE.hasActivated);
            TaskActivityManagerTest.assertFalse((boolean)MockTaskActivationListenerExtension.INSTANCE.hasPreDeactivated);
            TaskActivityManagerTest.assertFalse((boolean)MockTaskActivationListenerExtension.INSTANCE.hasDeactivated);
            MockTaskActivationListenerExtension.INSTANCE.reset();
        }
        finally {
            this.taskActivityManager.deactivateTask((ITask)task);
        }
        TaskActivityManagerTest.assertFalse((boolean)MockTaskActivationListenerExtension.INSTANCE.hasPreActivated);
        TaskActivityManagerTest.assertFalse((boolean)MockTaskActivationListenerExtension.INSTANCE.hasActivated);
        TaskActivityManagerTest.assertTrue((boolean)MockTaskActivationListenerExtension.INSTANCE.hasPreDeactivated);
        TaskActivityManagerTest.assertTrue((boolean)MockTaskActivationListenerExtension.INSTANCE.hasDeactivated);
    }

    public void testTaskActivationExtensionInstanceCount() {
        MockTask task = new MockTask("test:activation");
        try {
            this.taskActivityManager.activateTask((ITask)task);
            TaskActivityManagerTest.assertNotNull((String)"Expected creation of task activation listener instance", (Object)((Object)MockTaskActivationListenerExtension.INSTANCE));
            TaskActivityManagerTest.assertEquals((int)1, (int)MockTaskActivationListenerExtension.INSTANCE_COUNT);
        }
        finally {
            this.taskActivityManager.deactivateTask((ITask)task);
        }
    }

    public void testIsActiveToday() {
        LocalTask task = new LocalTask("1", "task-1");
        TaskActivityManagerTest.assertFalse((boolean)this.taskActivityManager.isScheduledForToday((AbstractTask)task));
        task.setScheduledForDate((DateRange)TaskActivityUtil.getCurrentWeek().getToday());
        TaskActivityManagerTest.assertTrue((boolean)this.taskActivityManager.isScheduledForToday((AbstractTask)task));
        task.setReminded(true);
        TaskActivityManagerTest.assertTrue((boolean)this.taskActivityManager.isScheduledForToday((AbstractTask)task));
        task.setReminded(true);
    }

    public void testScheduledForToday() {
        LocalTask task = new LocalTask("1", "task-1");
        task.setScheduledForDate((DateRange)TaskActivityUtil.getCurrentWeek().getToday());
        TaskActivityManagerTest.assertTrue((boolean)this.taskActivityManager.isScheduledForToday((AbstractTask)task));
        task.setScheduledForDate((DateRange)TaskActivityUtil.getCurrentWeek().getToday().next());
        TaskActivityManagerTest.assertFalse((boolean)this.taskActivityManager.isScheduledForToday((AbstractTask)task));
    }

    public void testSchedulePastEndOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 8);
        calendar.set(5, 30);
        TaskActivityUtil.snapForwardNumDays((Calendar)calendar, (int)1);
        TaskActivityManagerTest.assertEquals((String)"Should be October", (int)9, (int)calendar.get(2));
    }

    public void testIsCompletedToday() {
        LocalTask task = new LocalTask("1", "task 1");
        task.setCompletionDate(new Date());
        TaskActivityManagerTest.assertTrue((boolean)this.taskActivityManager.isCompletedToday((ITask)task));
        MockTask mockTask = new MockTask("1");
        mockTask.setOwner("unknown");
        this.taskList.addTask((ITask)mockTask);
        mockTask.setCompletionDate(new Date());
        TaskActivityManagerTest.assertFalse((String)("completed: " + mockTask.getCompletionDate()), (boolean)this.taskActivityManager.isCompletedToday((ITask)mockTask));
        mockTask = new MockTask("2");
        this.taskList.addTask((ITask)mockTask);
        mockTask.setCompletionDate(new Date());
        mockTask.setOwner("testUser");
        this.repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("testUser", ""), false);
        TaskActivityManagerTest.assertTrue((boolean)this.taskActivityManager.isCompletedToday((ITask)mockTask));
    }

    public void testAllTasksDeactivation() {
        this.initializeTasks();
        this.taskActivityManager.activateTask((ITask)this.task2);
        TaskActivityManagerTest.assertEquals((Object)this.task2, (Object)this.taskActivityManager.getActiveTask());
        this.taskActivityManager.deactivateActiveTask();
        TaskActivityManagerTest.assertNull((Object)this.taskActivityManager.getActiveTask());
    }

    public void testActivateNonActiveTaskCanDeactivate() {
        this.initializeTasks();
        this.assertActivateNonActiveTaskCanDeactivate(true, (ITask)this.task2);
    }

    public void testActivateNonActiveTaskCannotDeactivate() {
        this.initializeTasks();
        this.assertActivateNonActiveTaskCanDeactivate(false, (ITask)this.task1);
    }

    private void assertActivateNonActiveTaskCanDeactivate(boolean canDeactivate, ITask expectedActiveTask) {
        MockTaskActivationListener listener = new MockTaskActivationListener(canDeactivate);
        try {
            this.taskActivityManager.addActivationListener((ITaskActivationListener)listener);
            this.taskActivityManager.activateTask((ITask)this.task1);
            TaskActivityManagerTest.assertEquals((Object)this.task1, (Object)this.taskActivityManager.getActiveTask());
            this.taskActivityManager.activateTask((ITask)this.task2);
            TaskActivityManagerTest.assertEquals((Object)expectedActiveTask, (Object)this.taskActivityManager.getActiveTask());
            listener.verifyCalledCanDeactivate(1);
        }
        finally {
            this.taskActivityManager.removeActivationListener((ITaskActivationListener)listener);
        }
    }

    public void testDeactivateTaskCanDeactivate() {
        this.initializeTasks();
        this.assertDeactivateTaskCanDeactivate(true, null);
    }

    public void testDeactivateTaskCannotDeactivate() {
        this.initializeTasks();
        this.assertDeactivateTaskCanDeactivate(false, (ITask)this.task1);
    }

    private void assertDeactivateTaskCanDeactivate(boolean canDeactivate, ITask expectedActiveTask) {
        MockTaskActivationListener listener = new MockTaskActivationListener(canDeactivate);
        try {
            this.taskActivityManager.addActivationListener((ITaskActivationListener)listener);
            this.taskActivityManager.activateTask((ITask)this.task1);
            TaskActivityManagerTest.assertEquals((Object)this.task1, (Object)this.taskActivityManager.getActiveTask());
            this.taskActivityManager.deactivateTask((ITask)this.task1);
            TaskActivityManagerTest.assertEquals((Object)expectedActiveTask, (Object)this.taskActivityManager.getActiveTask());
            listener.verifyCalledCanDeactivate(1);
        }
        finally {
            this.taskActivityManager.removeActivationListener((ITaskActivationListener)listener);
        }
    }

    public void testDeactivateTaskOnInactiveTask() {
        this.initializeTasks();
        this.taskActivityManager.deactivateTask((ITask)this.task1);
        TaskActivityManagerTest.assertNull((Object)this.taskActivityManager.getActiveTask());
    }

    public void testMoveActivity() {
        this.initializeTasks();
        Calendar end = TaskActivityUtil.getNextWeek().getEndDate();
        Calendar start = TaskActivityUtil.getCalendar();
        start.setTimeInMillis(end.getTimeInMillis());
        TaskActivityUtil.snapStartOfDay((Calendar)start);
        this.taskActivityManager.setScheduledFor(this.task1, new DateRange(start, end));
        this.taskActivityManager.setDueDate((ITask)this.task1, new Date(start.getTimeInMillis() + 1L));
        TaskActivityManagerTest.assertEquals(Collections.singleton(this.task1), (Object)this.taskActivityManager.getScheduledTasks(start, end));
        TaskActivityManagerTest.assertEquals(Collections.singleton(this.task1), (Object)this.taskActivityManager.getDueTasks(start, end));
        this.taskActivityManager.activateTask((ITask)this.task1);
        this.taskActivityManager.moveActivity((ITask)this.task1, this.task2);
        TaskActivityManagerTest.assertEquals(Collections.singleton(this.task2), (Object)this.taskActivityManager.getScheduledTasks(start, end));
        TaskActivityManagerTest.assertEquals(Collections.singleton(this.task2), (Object)this.taskActivityManager.getDueTasks(start, end));
        TaskActivityManagerTest.assertTrue((boolean)this.task2.isActive());
        TaskActivityManagerTest.assertEquals((Object)this.task2, (Object)this.taskActivityManager.getActiveTask());
    }

    private void initializeTasks() {
        this.task1 = new LocalTask("task1", "description1");
        this.task2 = new LocalTask("task2", "description2");
        this.taskList.addTask((ITask)this.task1);
        this.taskList.addTask((ITask)this.task2);
        TaskActivityManagerTest.assertNull((Object)this.taskActivityManager.getActiveTask());
    }

    private class MockTaskActivationListener
    extends TaskActivationAdapter {
        private boolean hasActivated = false;
        private boolean hasPreActivated = false;
        private boolean hasDeactivated = false;
        private boolean hasPreDeactivated = false;
        private int timesCalledCanDeactivate;
        private final boolean canDeactivate;

        public MockTaskActivationListener() {
            this(true);
        }

        public MockTaskActivationListener(boolean canDeactivate) {
            this.canDeactivate = canDeactivate;
        }

        public void reset() {
            this.hasActivated = false;
            this.hasPreActivated = false;
            this.hasDeactivated = false;
            this.hasPreDeactivated = false;
            this.timesCalledCanDeactivate = 0;
        }

        public void preTaskActivated(ITask task) {
            TaskActivityManagerTest.assertFalse((boolean)this.hasActivated);
            this.hasPreActivated = true;
        }

        public void preTaskDeactivated(ITask task) {
            TaskActivityManagerTest.assertFalse((boolean)this.hasDeactivated);
            this.hasPreDeactivated = true;
        }

        public void taskActivated(ITask task) {
            TaskActivityManagerTest.assertTrue((boolean)this.hasPreActivated);
            this.hasActivated = true;
        }

        public void taskDeactivated(ITask task) {
            TaskActivityManagerTest.assertTrue((boolean)this.hasPreDeactivated);
            this.hasDeactivated = true;
        }

        public boolean canDeactivateTask(ITask task) {
            ++this.timesCalledCanDeactivate;
            return this.canDeactivate;
        }

        public void verifyCalledCanDeactivate(int times) {
            TaskActivityManagerTest.assertEquals((int)times, (int)this.timesCalledCanDeactivate);
        }
    }

    public static class MockTaskActivationListenerExtension
    extends TaskActivationAdapter {
        public static MockTaskActivationListenerExtension INSTANCE;
        public static int INSTANCE_COUNT;
        public boolean hasActivated = false;
        public boolean hasPreActivated = false;
        public boolean hasDeactivated = false;
        public boolean hasPreDeactivated = false;

        public MockTaskActivationListenerExtension() {
            INSTANCE = this;
            ++INSTANCE_COUNT;
        }

        public void reset() {
            this.hasActivated = false;
            this.hasPreActivated = false;
            this.hasDeactivated = false;
            this.hasPreDeactivated = false;
        }

        public void preTaskActivated(ITask task) {
            this.hasPreActivated = true;
        }

        public void preTaskDeactivated(ITask task) {
            this.hasPreDeactivated = true;
        }

        public void taskActivated(ITask task) {
            this.hasActivated = true;
        }

        public void taskDeactivated(ITask task) {
            this.hasDeactivated = true;
        }
    }
}

