/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataFileManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;

public class TaskDataFileManagerTest
extends TestCase {
    private final TestTaskDataFileManager fileManager = new TestTaskDataFileManager();

    public void testShortFileName() {
        TaskDataFileManagerTest.assertEquals((String)"11111%2520", (String)this.fileManager.getFileName((ITask)TaskTestUtil.createMockTask("11111%20"), true));
        TaskDataFileManagerTest.assertEquals((String)"11111%20", (String)this.fileManager.getFileName((ITask)TaskTestUtil.createMockTask("11111%20"), false));
        TaskDataFileManagerTest.assertEquals((String)"11111%2520%2B", (String)this.fileManager.getFileName((ITask)TaskTestUtil.createMockTask("11111%20+"), false));
        TaskDataFileManagerTest.assertEquals((String)"11111%2520%2B", (String)this.fileManager.getFileName((ITask)TaskTestUtil.createMockTask("11111%20+"), true));
    }

    public void testLongFileNameThatDoesNotRequireEncoding() {
        String str = StringUtils.repeat((String)"1", (int)256);
        TaskDataFileManagerTest.assertEquals((String)(String.valueOf(StringUtils.repeat((String)"1", (int)242)) + ".71634944"), (String)this.fileManager.getFileName((ITask)TaskTestUtil.createMockTask(str), false));
        TaskDataFileManagerTest.assertEquals((String)str, (String)this.fileManager.getFileName((ITask)TaskTestUtil.createMockTask(str), true));
    }

    public void testLongFileNameThatRequiresEncoding() {
        String str = "+" + StringUtils.repeat((String)"1", (int)255);
        String result = this.fileManager.getFileName((ITask)TaskTestUtil.createMockTask(str), false);
        TaskDataFileManagerTest.assertEquals((String)("%2B" + StringUtils.repeat((String)"1", (int)237) + ".3664039548"), (String)result);
        result = this.fileManager.getFileName((ITask)TaskTestUtil.createMockTask(str), true);
        TaskDataFileManagerTest.assertEquals((String)str.replaceAll("\\+", "%2B"), (String)result);
    }

    public void testGetSetDataPath() {
        String path = "path";
        this.fileManager.setDataPath("path");
        TaskDataFileManagerTest.assertEquals((String)"path", (String)this.fileManager.getDataPath());
    }

    public void testGetFile() {
        String path = "path";
        this.fileManager.setDataPath("path");
        String taskId = "taskId";
        File result = this.fileManager.getFile("url", (ITask)TaskTestUtil.createMockTask("taskId"), "kind");
        TaskDataFileManagerTest.assertTrue((boolean)result.getPath().matches("^path\\S+taskId\\.\\S+$"));
    }

    private class TestTaskDataFileManager
    extends TaskDataFileManager {
        private TestTaskDataFileManager() {
        }

        public String getFileName(ITask task, boolean fileExists) {
            return super.getFileName(task, name -> fileExists);
        }
    }
}

