/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.lang.RandomStringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracPermissionDeniedException;
import org.eclipse.mylyn.internal.trac.core.client.TracRemoteException;
import org.eclipse.mylyn.internal.trac.core.client.TracXmlRpcClient;
import org.eclipse.mylyn.internal.trac.core.model.TracAction;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSearchFilter;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPage;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPageInfo;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracHarness;
import org.eclipse.mylyn.trac.tests.support.TracTestUtil;

public class TracXmlRpcClientTest
extends TestCase {
    private static final int VERY_HIGH_REVISION = 100000;
    private TracXmlRpcClient client;
    private TracHarness harness;

    protected void setUp() throws Exception {
        TracFixture fixture = TracFixture.current();
        this.harness = fixture.createHarness();
        this.client = (TracXmlRpcClient)fixture.connect();
    }

    protected void tearDown() throws Exception {
        this.harness.dispose();
    }

    public void testValidateFailNoAuth() throws Exception {
        if (this.harness.getFixture().requiresAuthentication()) {
            return;
        }
        this.client = (TracXmlRpcClient)TracFixture.current().connect(this.client.getUrl(), "", "");
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracXmlRpcClientTest.fail((String)"Expected TracPermissionDeniedException");
        }
        catch (TracPermissionDeniedException tracPermissionDeniedException) {
            // empty catch block
        }
    }

    public void testMulticallExceptions() throws Exception {
        try {
            this.client.getTickets(new int[]{1, Integer.MAX_VALUE}, null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testSingleCallExceptions() throws Exception {
        try {
            this.client.getTicketLastChanged(Integer.valueOf(Integer.MAX_VALUE), null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testUpdateAttributes() throws Exception {
        TracXmlRpcClientTest.assertNull((Object)this.client.getMilestones());
        this.client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), true);
        TracVersion[] versions = this.client.getVersions();
        TracXmlRpcClientTest.assertEquals((int)2, (int)versions.length);
        Arrays.sort(versions, new Comparator<TracVersion>(){

            @Override
            public int compare(TracVersion o1, TracVersion o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        TracXmlRpcClientTest.assertEquals((String)"1.0", (String)versions[0].getName());
        TracXmlRpcClientTest.assertEquals((String)"", (String)versions[0].getDescription());
        TracXmlRpcClientTest.assertEquals((Object)new Date(0L), (Object)versions[0].getTime());
        TracXmlRpcClientTest.assertEquals((String)"2.0", (String)versions[1].getName());
        TracXmlRpcClientTest.assertEquals((String)"", (String)versions[1].getDescription());
        TracXmlRpcClientTest.assertEquals((Object)new Date(0L), (Object)versions[1].getTime());
    }

    public void testSearchValidateTicket() throws Exception {
        String uniqueTag = RandomStringUtils.randomAlphanumeric((int)6);
        TracTicket ticket = this.harness.createTicket("searchValidateTicket " + uniqueTag);
        ticket.putBuiltinValue(TracTicket.Key.COMPONENT, "component1");
        ticket.putBuiltinValue(TracTicket.Key.DESCRIPTION, "description1");
        ticket.putBuiltinValue(TracTicket.Key.MILESTONE, "milestone1");
        ticket.putBuiltinValue(TracTicket.Key.REPORTER, "anonymous");
        this.client.updateTicket(ticket, "", null);
        TracSearch search = new TracSearch();
        search.addFilter(new TracSearchFilter("summary", TracSearchFilter.CompareOperator.CONTAINS, uniqueTag));
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracXmlRpcClientTest.assertEquals((int)1, (int)result.size());
        ticket.putBuiltinValue(TracTicket.Key.OWNER, ((TracTicket)result.get(0)).getValue(TracTicket.Key.OWNER));
        TracTestUtil.assertTicketEquals(ticket, (TracTicket)result.get(0));
    }

    public void testGetTicketActions() throws Exception {
        TracTicket ticket = this.harness.createTicket("getTicketActions");
        TracAction[] actions = ticket.getActions();
        TracXmlRpcClientTest.assertNotNull((Object)actions);
        TracXmlRpcClientTest.assertEquals((int)4, (int)actions.length);
        TracXmlRpcClientTest.assertEquals((String)"leave", (String)actions[0].getId());
        TracXmlRpcClientTest.assertEquals((String)"resolve", (String)actions[1].getId());
        TracXmlRpcClientTest.assertEquals((String)"resolve", (String)actions[1].getLabel());
        TracXmlRpcClientTest.assertNotNull((Object)actions[1].getHint());
        List fields = actions[1].getFields();
        TracXmlRpcClientTest.assertEquals((int)1, (int)fields.size());
        TracXmlRpcClientTest.assertEquals((int)5, (int)((TracTicketField)fields.get(0)).getOptions().length);
        TracXmlRpcClientTest.assertEquals((String)"fixed", (String)((TracTicketField)fields.get(0)).getOptions()[0]);
        TracXmlRpcClientTest.assertEquals((String)"reassign", (String)actions[2].getId());
        fields = actions[2].getFields();
        TracXmlRpcClientTest.assertEquals((int)1, (int)fields.size());
        TracXmlRpcClientTest.assertNull((Object)((TracTicketField)fields.get(0)).getOptions());
        TracXmlRpcClientTest.assertEquals((String)"accept", (String)actions[3].getId());
    }

    public void testGetTicketActionsClosed() throws Exception {
        TracTicket ticket = this.harness.createTicket("getTicketActionsClosed");
        ticket.putBuiltinValue(TracTicket.Key.STATUS, "closed");
        ticket.putBuiltinValue(TracTicket.Key.RESOLUTION, "fixed");
        this.client.updateTicket(ticket, "", null);
        ticket = this.client.getTicket(ticket.getId(), null);
        TracAction[] actions = ticket.getActions();
        TracXmlRpcClientTest.assertNotNull((Object)actions);
        TracXmlRpcClientTest.assertEquals((int)2, (int)actions.length);
        TracXmlRpcClientTest.assertEquals((String)"leave", (String)actions[0].getId());
        TracXmlRpcClientTest.assertEquals((String)"reopen", (String)actions[1].getId());
    }

    public void testWikiToHtml() throws Exception {
        String tracUrl = this.client.getUrl();
        if (tracUrl.endsWith("/")) {
            tracUrl = tracUrl.substring(0, tracUrl.length() - 1);
        }
        String html = this.client.wikiToHtml("", null);
        TracXmlRpcClientTest.assertEquals((String)"", (String)html);
        html = this.client.wikiToHtml("A simple line of text.", null);
        TracXmlRpcClientTest.assertEquals((String)"<p>\nA simple line of text.\n</p>\n", (String)html);
        String source = "= WikiFormattingTesting =\n * '''bold''', '''!''' can be bold too''', and '''! '''\n * ''italic''\n * '''''bold italic'''''\n * __underline__\n * {{{monospace}}} or `monospace`\n * ~~strike-through~~\n * ^superscript^ \n * ,,subscript,,\n= Heading =\n== Subheading ==\n";
        String expectedHtml = TracFixture.current().getVersion().compareTo("0.12") >= 0 ? "<h1 id=\"WikiFormattingTesting\"><a class=\"missing wiki\" href=\"" + tracUrl + "/wiki/WikiFormattingTesting\" rel=\"nofollow\">WikiFormattingTesting?</a></h1>\n<ul><li><strong>bold</strong>, <strong>''' can be bold too</strong>, and <strong>! </strong>\n</li><li><em>italic</em>\n</li><li><strong><em>bold italic</em></strong>\n</li><li><span class=\"underline\">underline</span>\n</li><li><tt>monospace</tt> or <tt>monospace</tt>\n</li><li><del>strike-through</del>\n</li><li><sup>superscript</sup> \n</li><li><sub>subscript</sub>\n</li></ul><h1 id=\"Heading\">Heading</h1>\n<h2 id=\"Subheading\">Subheading</h2>\n" : "<h1 id=\"WikiFormattingTesting\"><a class=\"missing wiki\" href=\"" + tracUrl + "/wiki/WikiFormattingTesting\" rel=\"nofollow\">WikiFormattingTesting?</a></h1>\n<ul><li><strong>bold</strong>, <strong>''' can be bold too</strong>, and <strong>! </strong>\n</li><li><i>italic</i>\n</li><li><strong><i>bold italic</i></strong>\n</li><li><span class=\"underline\">underline</span>\n</li><li><tt>monospace</tt> or <tt>monospace</tt>\n</li><li><del>strike-through</del>\n</li><li><sup>superscript</sup> \n</li><li><sub>subscript</sub>\n</li></ul><h1 id=\"Heading\">Heading</h1>\n<h2 id=\"Subheading\">Subheading</h2>\n";
        html = this.client.wikiToHtml(source, null);
        TracXmlRpcClientTest.assertEquals((String)expectedHtml, (String)html);
    }

    public void testValidateWikiAPI() throws Exception {
        this.client.validateWikiRpcApi(null);
    }

    public void testGetAllWikiPageNames() throws Exception {
        String[] names = this.client.getAllWikiPageNames(null);
        List<String> all = Arrays.asList(names);
        TracXmlRpcClientTest.assertTrue((boolean)all.contains("Test"));
    }

    public void testGetWikiPage() throws Exception {
        String pageName = "TestGetPage" + RandomStringUtils.randomAlphanumeric((int)6);
        this.harness.createWikiPage(pageName, "Version 1");
        this.harness.createWikiPage(pageName, "Version 2");
        TracWikiPage page = this.client.getWikiPage(pageName, null);
        TracXmlRpcClientTest.assertEquals((String)pageName, (String)page.getPageInfo().getPageName());
        TracXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)page.getPageInfo().getAuthor());
        TracXmlRpcClientTest.assertEquals((int)2, (int)page.getPageInfo().getVersion());
        TracXmlRpcClientTest.assertEquals((String)"Version 2", (String)page.getContent());
        TracXmlRpcClientTest.assertTrue((boolean)page.getPageHTML().startsWith("<html>"));
        page = this.client.getWikiPage(pageName, 1, null);
        TracXmlRpcClientTest.assertEquals((String)pageName, (String)page.getPageInfo().getPageName());
        TracXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)page.getPageInfo().getAuthor());
        TracXmlRpcClientTest.assertEquals((int)1, (int)page.getPageInfo().getVersion());
        TracXmlRpcClientTest.assertEquals((String)"Version 1", (String)page.getContent());
        TracXmlRpcClientTest.assertTrue((boolean)page.getPageHTML().startsWith("<html>"));
    }

    public void testGetWikiPageInfoInvalidRevision() throws Exception {
        try {
            this.client.getWikiPageInfo("Test", 100000, null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testGetWikiPageInfoInvalidPage() throws Exception {
        try {
            this.client.getWikiPageInfo("NoSuchPage", null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testGetWikiPageInfoNull() throws Exception {
        try {
            this.client.getWikiPageInfo(null, null);
            TracXmlRpcClientTest.fail((String)"Expected RuntimeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetWikiPageContentInvalidRevision() throws Exception {
        try {
            this.client.getWikiPageContent("Test", 100000, null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testGetWikiPageContentInvalidPage() throws Exception {
        try {
            this.client.getWikiPageContent("NoSuchPage", null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testGetWikiPageContentContentNull() throws Exception {
        try {
            this.client.getWikiPageContent(null, null);
            TracXmlRpcClientTest.fail((String)"Expected RuntimeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetWikiPageHtmlInvalidRevision() throws Exception {
        try {
            this.client.getWikiPageHtml("Test", 100000, null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testGetWikiPageHtmlInvalidPage() throws Exception {
        try {
            this.client.getWikiPageHtml("NoSuchPage", null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testGetWikiPageHtmlNull() throws Exception {
        try {
            this.client.getWikiPageHtml(null, null);
            TracXmlRpcClientTest.fail((String)"Expected RuntimeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetWikiPageInvalidRevision() throws Exception {
        try {
            this.client.getWikiPage("Test", 100000, null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testGetWikiPageInvalidPage() throws Exception {
        try {
            this.client.getWikiPage("NoSuchPage", null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testGetWikiPageNull() throws Exception {
        try {
            this.client.getWikiPage(null, null);
            TracXmlRpcClientTest.fail((String)"Expected RuntimeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetWikiInfoAllVersionsInvalidPage() throws Exception {
        try {
            this.client.getWikiPageInfoAllVersions("NoSuchPage", null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {
            // empty catch block
        }
    }

    public void testGetWikiInfoAllVersionsInvalidPageNull() throws Exception {
        try {
            this.client.getWikiPageInfoAllVersions(null, null);
            TracXmlRpcClientTest.fail((String)"Expected RuntimeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetRecentWikiChanges() throws Exception {
        this.harness.createWikiPage("Test", "test content " + RandomStringUtils.randomAlphanumeric((int)6));
        TracWikiPageInfo[] changes = this.client.getRecentWikiChanges(new Date(0L), null);
        TracWikiPageInfo testPage = null;
        TracWikiPageInfo[] tracWikiPageInfoArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            TracWikiPageInfo item = tracWikiPageInfoArray[n2];
            TracXmlRpcClientTest.assertTrue((item.getPageName() != null ? 1 : 0) != 0);
            if (item.getPageName().equals("Test")) {
                testPage = item;
            }
            ++n2;
        }
        TracXmlRpcClientTest.assertTrue((testPage != null ? 1 : 0) != 0);
    }

    public void testInvalidCharacters() throws Exception {
        TracTicket ticket = this.harness.createTicket("invalid characters");
        ticket.putBuiltinValue(TracTicket.Key.DESCRIPTION, "Control Character: \u0002");
        try {
            this.client.updateTicket(ticket, "set invalid characters in description", null);
            TracXmlRpcClientTest.fail((String)"Expected TracException");
        }
        catch (TracException tracException) {
            // empty catch block
        }
    }
}

