/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.http.core;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.repositories.http.core.HttpUtil;

public class CommonHttpResponse {
    private final HttpRequest request;
    private final HttpResponse response;

    public CommonHttpResponse(HttpRequest request, HttpResponse response) {
        Assert.isNotNull((Object)request);
        Assert.isNotNull((Object)response);
        this.request = request;
        this.response = response;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public InputStream getResponseEntityAsStream(IProgressMonitor monitor) throws IOException {
        HttpEntity entity = this.response.getEntity();
        if (entity == null) {
            throw new IOException("Expected entity");
        }
        return HttpUtil.getResponseBodyAsStream(entity, monitor);
    }

    public void release(IProgressMonitor monitor) {
        HttpUtil.release(this.request, this.response, monitor);
    }

    public String getRequestPath() {
        if (this.request instanceof HttpUriRequest) {
            return ((HttpUriRequest)this.request).getURI().getPath();
        }
        return null;
    }

    public String getResponseCharSet() {
        return EntityUtils.getContentCharSet((HttpEntity)this.response.getEntity());
    }
}

