/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.http.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.eclipse.mylyn.commons.core.net.NetUtil;
import org.eclipse.mylyn.commons.core.operations.MonitoredOperation;

public class PollingProtocolSocketFactory
implements SchemeSocketFactory {
    private static final SocketFactory factory = SocketFactory.getDefault();

    public Socket createSocket(HttpParams params) throws IOException {
        return NetUtil.configureSocket((Socket)factory.createSocket());
    }

    public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        Socket socket = sock != null ? sock : NetUtil.configureSocket((Socket)factory.createSocket());
        int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        socket.bind(localAddress);
        NetUtil.connect((Socket)socket, (InetSocketAddress)remoteAddress, (int)connTimeout, (MonitoredOperation)MonitoredOperation.getCurrentOperation());
        return socket;
    }

    public boolean isSecure(Socket sock) throws IllegalArgumentException {
        return false;
    }
}

