/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.commons.sdk.util.ResourceTestUtil;
import org.eclipse.mylyn.commons.sdk.util.TestProject;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class ProjectRepositoryAssociationTest
extends TestCase {
    private static final String REPOSITORY_URL = "http://mylyn.eclipse.org/bugs222";
    private static final String REPOSITORY_KIND = "bugzilla";
    private TestProject projectWrapper;

    protected void setUp() throws Exception {
        super.setUp();
        this.projectWrapper = new TestProject(((Object)((Object)this)).getClass().getName());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ResourceTestUtil.deleteProject((IProject)this.projectWrapper.getProject());
        TasksUiPlugin.getRepositoryManager().clearRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
    }

    public void testRepositoryForProject() throws CoreException {
        ProjectRepositoryAssociationTest.assertNull((Object)TasksUiPlugin.getDefault().getRepositoryForResource((IResource)this.projectWrapper.getProject()));
        TaskRepository repository = new TaskRepository(REPOSITORY_KIND, REPOSITORY_URL);
        TasksUiPlugin.getRepositoryManager().addRepository(repository);
        TasksUiPlugin.getDefault().setRepositoryForResource((IResource)this.projectWrapper.getProject(), repository);
        TaskRepository returnedRepository = TasksUiPlugin.getDefault().getRepositoryForResource((IResource)this.projectWrapper.getProject());
        ProjectRepositoryAssociationTest.assertNotNull((Object)returnedRepository);
        ProjectRepositoryAssociationTest.assertEquals((String)REPOSITORY_KIND, (String)returnedRepository.getConnectorKind());
        ProjectRepositoryAssociationTest.assertEquals((String)REPOSITORY_URL, (String)returnedRepository.getRepositoryUrl());
        TasksUiPlugin.getRepositoryManager().removeRepository(repository, TasksUiPlugin.getDefault().getRepositoriesFilePath());
    }

    public void testRepositoryForFolder() throws CoreException {
        IFolder folder = this.projectWrapper.createFolder("testFolder");
        ProjectRepositoryAssociationTest.assertTrue((boolean)folder.exists());
        ProjectRepositoryAssociationTest.assertNull((Object)TasksUiPlugin.getDefault().getRepositoryForResource((IResource)folder));
        TaskRepository repository = new TaskRepository(REPOSITORY_KIND, REPOSITORY_URL);
        TasksUiPlugin.getRepositoryManager().addRepository(repository);
        TasksUiPlugin.getDefault().setRepositoryForResource((IResource)folder, repository);
        TaskRepository returnedRepository = TasksUiPlugin.getDefault().getRepositoryForResource((IResource)folder);
        ProjectRepositoryAssociationTest.assertNotNull((Object)returnedRepository);
        ProjectRepositoryAssociationTest.assertEquals((String)REPOSITORY_KIND, (String)returnedRepository.getConnectorKind());
        ProjectRepositoryAssociationTest.assertEquals((String)REPOSITORY_URL, (String)returnedRepository.getRepositoryUrl());
        TasksUiPlugin.getRepositoryManager().removeRepository(repository, TasksUiPlugin.getDefault().getRepositoriesFilePath());
    }
}

