/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;

public class TaskMapperTest
extends TestCase {
    private StubTaskAttributeMapper mapper;
    private TaskMapper source;
    private TaskMapper target;
    private TaskRepository taskRepository;

    protected void setUp() throws Exception {
        this.taskRepository = new TaskRepository("mock", "http://mockrepository.test");
        this.mapper = new StubTaskAttributeMapper(this.taskRepository);
        this.source = new TaskMapper(new TaskData((TaskAttributeMapper)this.mapper, "kind", "http://url", "1"), true);
        this.target = new TaskMapper(new TaskData((TaskAttributeMapper)this.mapper, "kind", "http://url", "2"), true);
    }

    public void testTaskSchema() {
        this.source.setReporter("reporter");
        TaskAttribute attribute = this.source.getTaskData().getRoot().getAttribute("task.common.user.reporter");
        TaskMapperTest.assertNotNull((Object)attribute);
        TaskMapperTest.assertEquals((String)"reporter", (String)attribute.getValue());
        TaskMapperTest.assertEquals((String)"Reporter", (String)attribute.getMetaData().getLabel());
        TaskMapperTest.assertEquals((String)"person", (String)attribute.getMetaData().getType());
    }

    public void testTaskAttachmentMapperSchema() {
        TaskAttribute attachmentAttribute = this.mapper.createTaskAttachment(this.source.getTaskData());
        TaskAttachmentMapper mapper = new TaskAttachmentMapper();
        mapper.setAuthor(this.taskRepository.createPerson("reporter"));
        mapper.applyTo(attachmentAttribute);
        TaskAttribute attribute = attachmentAttribute.getAttribute("task.common.attachment.author");
        TaskMapperTest.assertNotNull((Object)attribute);
        TaskMapperTest.assertEquals((String)"reporter", (String)attribute.getValue());
        TaskMapperTest.assertEquals((String)"Author", (String)attribute.getMetaData().getLabel());
        TaskMapperTest.assertEquals((String)"person", (String)attribute.getMetaData().getType());
    }

    public void testTaskCommentMapperSchema() {
        TaskAttribute attachmentAttribute = this.mapper.createTaskAttachment(this.source.getTaskData());
        TaskCommentMapper mapper = new TaskCommentMapper();
        mapper.setAuthor(this.taskRepository.createPerson("reporter"));
        mapper.applyTo(attachmentAttribute);
        TaskAttribute attribute = attachmentAttribute.getAttribute("task.common.comment.author");
        TaskMapperTest.assertNotNull((Object)attribute);
        TaskMapperTest.assertEquals((String)"reporter", (String)attribute.getValue());
        TaskMapperTest.assertEquals((String)"Author", (String)attribute.getMetaData().getLabel());
        TaskMapperTest.assertEquals((String)"person", (String)attribute.getMetaData().getType());
    }

    public void testCloneTaskCloneCommonAttributes() {
        this.source.setDescription("sourceDescription");
        this.target.setDescription("");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"sourceDescription", (String)this.target.getDescription());
        TaskMapperTest.assertEquals(null, (String)this.target.getSummary());
        this.source.setSummary("sourceSummary");
        this.target.setSummary("");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"sourceSummary", (String)this.target.getSummary());
    }

    public void testCloneTaskDataAttributeWithValues() {
        this.source.getTaskData().getRoot().createAttribute("key1").addValue("value1");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals(null, (Object)this.target.getTaskData().getRoot().getAttribute("key1"));
        this.target.getTaskData().getRoot().createAttribute("key1").addValue("value2");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"value1", (String)this.target.getTaskData().getRoot().getAttribute("key1").getValue());
        TaskAttribute attribute = this.source.getTaskData().getRoot().createAttribute("multi");
        attribute.addValue("v1");
        attribute.addValue("v2");
        this.target.getTaskData().getRoot().createAttribute("multi");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"value1", (String)this.target.getTaskData().getRoot().getAttribute("key1").getValue());
        List values = this.target.getTaskData().getRoot().getAttribute("multi").getValues();
        TaskMapperTest.assertEquals((int)2, (int)values.size());
        TaskMapperTest.assertEquals((String)"v1", (String)((String)values.get(0)));
        TaskMapperTest.assertEquals((String)"v2", (String)((String)values.get(1)));
    }

    public void testCloneTaskDataAttributeWithOptions() {
        TaskAttribute sourceAttribute = this.source.getTaskData().getRoot().createAttribute("key");
        sourceAttribute.setValue("o2");
        sourceAttribute.putOption("o1", "");
        sourceAttribute.putOption("o2", "");
        this.target.getTaskData().getRoot().createAttribute("key");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"o2", (String)this.target.getTaskData().getRoot().getAttribute("key").getValue());
        TaskAttribute targetAttribute = this.target.getTaskData().getRoot().getAttribute("key");
        targetAttribute.putOption("o3", "");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"", (String)this.target.getTaskData().getRoot().getAttribute("key").getValue());
        targetAttribute.putOption("o2", "");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"o2", (String)this.target.getTaskData().getRoot().getAttribute("key").getValue());
        sourceAttribute.addValue("o3");
        this.target.merge((ITaskMapping)this.source);
        List values = targetAttribute.getValues();
        TaskMapperTest.assertEquals((int)2, (int)values.size());
        TaskMapperTest.assertEquals((String)"o2", (String)((String)values.get(0)));
        TaskMapperTest.assertEquals((String)"o3", (String)((String)values.get(1)));
    }

    public void testCloneTaskDifferentRepositoryTypesCloneCommonAttributes() {
        this.target = new TaskMapper(new TaskData((TaskAttributeMapper)this.mapper, "otherkind", "http://url", "2"), true);
        this.source.setDescription("sourceDescription");
        this.target.setDescription("");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"sourceDescription", (String)this.target.getDescription());
        TaskMapperTest.assertEquals(null, (String)this.target.getSummary());
        this.source.setSummary("sourceSummary");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"sourceSummary", (String)this.target.getSummary());
    }

    public void testCloneTaskDifferentRepositoryTypesCloneMappedAttribues() {
        StubTaskAttributeMapper targetMapper = new StubTaskAttributeMapper(this.taskRepository);
        this.target = new TaskMapper(new TaskData((TaskAttributeMapper)targetMapper, "otherkind", "http://url", "2"), true);
        this.source.getTaskData().getRoot().createAttribute("key").setValue("source");
        this.target.getTaskData().getRoot().createAttribute("key").setValue("target");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"target", (String)this.target.getTaskData().getRoot().getAttribute("key").getValue());
        this.mapper.attributeMap.put("task.common.component", "key");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"target", (String)this.target.getTaskData().getRoot().getAttribute("key").getValue());
        targetMapper.attributeMap.put("task.common.product", "key");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"target", (String)this.target.getTaskData().getRoot().getAttribute("key").getValue());
        targetMapper.attributeMap.put("task.common.component", "key");
        this.target.merge((ITaskMapping)this.source);
        TaskMapperTest.assertEquals((String)"source", (String)this.target.getTaskData().getRoot().getAttribute("key").getValue());
    }

    public void testNoCreationOfAttributes() {
        this.target = new TaskMapper(new TaskData((TaskAttributeMapper)this.mapper, "otherkind", "http://url", "2"));
        this.target.setDescription("abc");
        TaskMapperTest.assertNull((Object)this.target.getTaskData().getRoot().getAttribute("task.common.description"));
        TaskMapperTest.assertEquals((int)0, (int)this.target.getTaskData().getRoot().getAttributes().size());
        this.target = new TaskMapper(new TaskData((TaskAttributeMapper)this.mapper, "otherkind", "http://url", "2"), false);
        this.target.setDescription("abc");
        TaskMapperTest.assertNull((Object)this.target.getTaskData().getRoot().getAttribute("task.common.description"));
        TaskMapperTest.assertEquals((int)0, (int)this.target.getTaskData().getRoot().getAttributes().size());
    }

    private class StubTaskAttributeMapper
    extends TaskAttributeMapper {
        private final Map<String, String> attributeMap;

        public StubTaskAttributeMapper(TaskRepository taskRepository) {
            super(taskRepository);
            this.attributeMap = new HashMap<String, String>();
        }

        public String mapToRepositoryKey(TaskAttribute parent, String key) {
            String mappedKey = this.attributeMap.get(key);
            return mappedKey != null ? mappedKey : key;
        }
    }
}

