/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import junit.framework.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.TasksTestsPlugin;
import org.eclipse.mylyn.tests.util.TestFixture;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ViewIntroAdapterPart;

public class TaskTestUtil {
    public static File getLocalFile(String path) {
        try {
            URL installURL = TasksTestsPlugin.getDefault().getBundle().getEntry(path);
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File getFile(String path) throws IOException {
        if (TasksTestsPlugin.getDefault() != null) {
            URL installURL = TasksTestsPlugin.getDefault().getBundle().getEntry(path);
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        URL localURL = TaskTestUtil.class.getResource("");
        return new File(String.valueOf(localURL.getFile()) + "../../../../../../" + path);
    }

    public static void resetTaskListAndRepositories() throws Exception {
        TestFixture.resetTaskListAndRepositories();
    }

    public static void resetTaskList() throws Exception {
        TestFixture.resetTaskList();
    }

    public static void saveAndReadTasklist() throws Exception {
        TestFixture.saveAndReadTasklist();
    }

    public static void saveNow() throws Exception {
        TestFixture.saveNow();
    }

    public static TaskRepository createMockRepository() {
        return new TaskRepository("mock", "http://mockrepository.test");
    }

    public static TaskTask createMockTask(String taskId) {
        return new TaskTask("mock", "http://mockrepository.test", taskId);
    }

    public static RepositoryQuery createMockQuery(String queryId) {
        return new RepositoryQuery("mock", queryId);
    }

    public static TaskListView openTasksViewInActivePerspective() throws Exception {
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (activePart instanceof ViewIntroAdapterPart) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)activePart);
        }
        TaskListView taskListView = (TaskListView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.mylyn.tasks.ui.views.tasks");
        Assert.assertSame((String)"Failed to make task list view active", (Object)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), (Object)taskListView);
        return taskListView;
    }

    public static void addAndSelectTask(ITask task) throws Exception {
        TasksUiPlugin.getTaskList().addTask(task);
        TaskListView taskListView = TaskTestUtil.openTasksViewInActivePerspective();
        taskListView.refresh();
        taskListView.getViewer().expandAll();
        taskListView.getViewer().setSelection((ISelection)new StructuredSelection((Object)task), true);
        Assert.assertSame((String)"Failed to select task", (Object)task, (Object)taskListView.getSelectedTask());
    }

    public static TaskData createTaskData(TaskRepository taskRepository, String taskId) {
        return new TaskData(new TaskAttributeMapper(taskRepository), taskRepository.getConnectorKind(), taskRepository.getRepositoryUrl(), taskId);
    }

    public static TaskData createMockTaskData(String taskId) {
        return TaskTestUtil.createTaskData(TaskTestUtil.createMockRepository(), taskId);
    }

    public static TaskAttachment createMockTaskAttachment(String taskId) {
        return new TaskAttachment(TaskTestUtil.createMockRepository(), (ITask)TaskTestUtil.createMockTask(taskId), TaskTestUtil.createMockTaskData(taskId).getRoot());
    }
}

