/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import junit.framework.TestCase;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskRepositoryTest
extends TestCase {
    private TaskRepository taskRepository;

    protected void setUp() throws Exception {
        this.taskRepository = new TaskRepository("kind", "url");
    }

    public void testSetTaskRepositoryProperty() {
        String key = "key";
        String value = "value";
        this.taskRepository.setProperty(key, value);
        TaskRepositoryTest.assertEquals((String)value, (String)this.taskRepository.getProperty(key));
    }

    public void testResetTaskRepositoryProperty() {
        String key = "key";
        String value = "value";
        this.taskRepository.setProperty(key, value);
        TaskRepositoryTest.assertEquals((String)value, (String)this.taskRepository.getProperty(key));
        value = "newValue";
        this.taskRepository.setProperty(key, value);
        TaskRepositoryTest.assertEquals((String)value, (String)this.taskRepository.getProperty(key));
    }

    public void testSetTaskRepositoryPropertyWithSpace() {
        String key = "key 1";
        String value = "value";
        boolean caughtException = false;
        try {
            this.taskRepository.setProperty(key, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            caughtException = true;
        }
        TaskRepositoryTest.assertTrue((boolean)caughtException);
    }

    public void testSetTaskRepositoryPropertyWithTab() {
        String key = "key\t1";
        String value = "value";
        boolean caughtException = false;
        try {
            this.taskRepository.setProperty(key, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            caughtException = true;
        }
        TaskRepositoryTest.assertTrue((boolean)caughtException);
    }

    public void testSetTaskRepositoryPropertyWithNewline() {
        String key = "key\n1";
        String value = "value";
        boolean caughtException = false;
        try {
            this.taskRepository.setProperty(key, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            caughtException = true;
        }
        TaskRepositoryTest.assertTrue((boolean)caughtException);
    }
}

