/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class MarkTaskHandlerTest
extends TestCase {
    private IHandlerService handlerService;

    protected void setUp() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        TaskRepository repository = TaskTestUtil.createMockRepository();
        TasksUiPlugin.getRepositoryManager().addRepository(repository);
        TaskWorkingSetUpdater.applyWorkingSetsToAllWindows(new HashSet(0));
        TaskTestUtil.openTasksViewInActivePerspective().clearFilters();
    }

    protected void tearDown() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
    }

    public void testMarkTaskCompleted() throws Exception {
        MockRepositoryConnector.getDefault().setHasLocalCompletionState(true);
        TaskTask task = TaskTestUtil.createMockTask("1");
        TaskTestUtil.addAndSelectTask((ITask)task);
        MarkTaskHandlerTest.assertFalse((boolean)task.isCompleted());
        this.handlerService.executeCommand("org.eclipse.mylyn.tasks.ui.command.markTaskComplete", null);
        MarkTaskHandlerTest.assertTrue((boolean)task.isCompleted());
        try {
            this.handlerService.executeCommand("org.eclipse.mylyn.tasks.ui.command.markTaskComplete", null);
            MarkTaskHandlerTest.fail((String)"Expected NotEnabledException");
        }
        catch (NotEnabledException notEnabledException) {}
    }

    public void testMarkLocalTaskCompleted() throws Exception {
        LocalTask localTask = new LocalTask("1", "");
        TaskTestUtil.addAndSelectTask((ITask)localTask);
        MarkTaskHandlerTest.assertFalse((boolean)localTask.isCompleted());
        this.handlerService.executeCommand("org.eclipse.mylyn.tasks.ui.command.markTaskComplete", null);
        MarkTaskHandlerTest.assertTrue((boolean)localTask.isCompleted());
        try {
            this.handlerService.executeCommand("org.eclipse.mylyn.tasks.ui.command.markTaskComplete", null);
            MarkTaskHandlerTest.fail((String)"Expected NotEnabledException");
        }
        catch (NotEnabledException notEnabledException) {}
    }
}

