/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.dnd;

import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.dnd.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.editor.operations.AbstractDocumentCommand;
import org.eclipse.mylyn.internal.wikitext.ui.editor.operations.CommandManager;
import org.eclipse.mylyn.internal.wikitext.ui.editor.operations.InsertLocation;
import org.eclipse.mylyn.internal.wikitext.ui.editor.operations.MoveSectionsCommand;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineDropTargetListener
implements TransferDropTargetListener {
    private static final double THRESHOLD_BEFORE = 0.25;
    private static final double THRESHOLD_AFTER = 0.75;
    private final CommandManager commandManager;

    public OutlineDropTargetListener(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 1;
        float relativeLocation = this.computeRelativeLocation(event);
        if ((double)relativeLocation > 0.75) {
            event.feedback = 4;
        } else if ((double)relativeLocation < 0.25) {
            event.feedback = 2;
        }
        event.feedback |= 0x18;
    }

    public void drop(DropTargetEvent event) {
        List<OutlineItem> dropItems = this.getDropItems(event);
        if (dropItems != null) {
            InsertLocation location = this.computeInsertLocation(event);
            Object targetData = event.item.getData();
            final AbstractDocumentCommand command = this.computeCommand(targetData, dropItems, location);
            if (command != null) {
                if (command.isEnabled()) {
                    SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            WikiTextUiPlugin.getDefault().log(exception);
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.OutlineDropTargetListener_0, (String)NLS.bind((String)Messages.OutlineDropTargetListener_1, (Object[])new Object[]{exception.getMessage()}));
                        }

                        public void run() throws Exception {
                            OutlineDropTargetListener.this.commandManager.perform(command);
                        }
                    });
                } else {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.OutlineDropTargetListener_2, (String)NLS.bind((String)Messages.OutlineDropTargetListener_3, (Object[])new Object[]{command.getProblemText()}));
                }
            }
        }
    }

    private AbstractDocumentCommand computeCommand(Object targetData, List<OutlineItem> dropItems, InsertLocation location) {
        return new MoveSectionsCommand((OutlineItem)targetData, dropItems, location);
    }

    private List<OutlineItem> getDropItems(DropTargetEvent event) {
        IStructuredSelection structuredSelection;
        List list;
        if (event.operations == 0 || event.item == null) {
            return null;
        }
        Object targetData = event.item.getData();
        if (!(targetData instanceof OutlineItem)) {
            return null;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && !(list = (structuredSelection = (IStructuredSelection)selection).toList()).isEmpty()) {
            for (Object i : list) {
                if (i instanceof OutlineItem) continue;
                return null;
            }
            return list;
        }
        return null;
    }

    private InsertLocation computeInsertLocation(DropTargetEvent event) {
        float relativeLocation = this.computeRelativeLocation(event);
        if ((double)relativeLocation < 0.25) {
            return InsertLocation.BEFORE;
        }
        if ((double)relativeLocation > 0.75) {
            return InsertLocation.AFTER;
        }
        return InsertLocation.WITHIN;
    }

    private float computeRelativeLocation(DropTargetEvent event) {
        if (event.item == null) {
            return 0.5f;
        }
        if (event.item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)event.item;
            Tree control = treeItem.getParent();
            Point controlRelativeEventLocation = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = treeItem.getBounds();
            return (float)(controlRelativeEventLocation.y - bounds.y) / (float)bounds.height;
        }
        return 0.0f;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getTransfer();
    }

    public boolean isEnabled(DropTargetEvent event) {
        return this.getTransfer().isSupportedType(event.currentDataType) && this.getDropItems(event) != null;
    }
}

