/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.PersonContentProposal;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonProposalProvider
implements IContentProposalProvider {
    private final AbstractTask currentTask;
    private String currentUser;
    private SortedSet<String> addressSet;
    private String repositoryUrl;
    private String connectorKind;
    private TaskData currentTaskData;
    private final Map<String, String> proposals;
    private Map<String, String> errorProposals;

    public PersonProposalProvider(AbstractTask task, TaskData taskData) {
        this(task, taskData, new HashMap<String, String>(0));
    }

    public PersonProposalProvider(AbstractTask task, TaskData taskData, Map<String, String> proposals) {
        this.currentTask = task;
        this.currentTaskData = taskData;
        if (task != null) {
            this.repositoryUrl = task.getRepositoryUrl();
            this.connectorKind = task.getConnectorKind();
        } else if (taskData != null) {
            this.repositoryUrl = taskData.getRepositoryUrl();
            this.connectorKind = taskData.getConnectorKind();
        }
        this.proposals = new HashMap<String, String>(proposals);
    }

    public PersonProposalProvider(String repositoryUrl, String repositoryKind) {
        this(repositoryUrl, repositoryKind, new HashMap<String, String>(0));
    }

    public PersonProposalProvider(String repositoryUrl, String repositoryKind, Map<String, String> proposals) {
        this.currentTask = null;
        this.repositoryUrl = repositoryUrl;
        this.connectorKind = repositoryKind;
        this.proposals = new HashMap<String, String>(proposals);
    }

    protected String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    protected String getConnectorKind() {
        return this.connectorKind;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (contents == null) {
            throw new IllegalArgumentException();
        }
        int leftSeparator = this.getIndexOfLeftSeparator(contents, position);
        int rightSeparator = this.getIndexOfRightSeparator(contents, position);
        assert (leftSeparator <= position);
        assert (position <= rightSeparator);
        String searchText = contents.substring(leftSeparator + 1, position);
        String resultPrefix = contents.substring(0, leftSeparator + 1);
        String resultPostfix = contents.substring(rightSeparator);
        SortedSet<String> addressSet = this.getAddressSet();
        if ((this.errorProposals == null || this.errorProposals.isEmpty()) && !searchText.equals("")) {
            searchText = searchText.toLowerCase();
            char[] nextWord = searchText.toCharArray();
            int n = searchText.length() - 1;
            nextWord[n] = (char)(nextWord[n] + '\u0001');
            addressSet = new TreeSet<String>(addressSet.subSet(searchText, new String(nextWord)));
            this.addMatchingProposalsByPrettyName(addressSet, searchText);
        }
        Object[] result = new IContentProposal[addressSet.size()];
        int i = 0;
        for (String address : addressSet) {
            result[i++] = this.createPersonProposal(address, address.equalsIgnoreCase(this.currentUser), String.valueOf(resultPrefix) + address + resultPostfix, resultPrefix.length() + address.length());
        }
        Arrays.sort(result);
        return result;
    }

    private void addMatchingProposalsByPrettyName(SortedSet<String> addressSet, String searchText) {
        if (this.proposals.size() > 0) {
            for (Map.Entry<String, String> entry : this.proposals.entrySet()) {
                if (!this.matchesSubstring(entry.getValue(), searchText)) continue;
                addressSet.add(entry.getKey());
            }
        }
    }

    private boolean matchesSubstring(String value, String searchText) {
        if (value != null) {
            String[] tokens;
            String[] stringArray = tokens = value.split("\\s");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (token.toLowerCase().startsWith(searchText)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected PersonContentProposal createPersonProposal(String address, boolean isCurrentUser, String replacementText, int cursorPosition) {
        return new PersonContentProposal(this.getPrettyName(address), isCurrentUser, replacementText, cursorPosition);
    }

    protected String getPrettyName(String address) {
        String value = this.proposals.get(address);
        if (value != null) {
            return NLS.bind((String)"{0} <{1}>", (Object)value, (Object)address);
        }
        return address;
    }

    private int getIndexOfLeftSeparator(String contents, int position) {
        int i = contents.lastIndexOf(32, position - 1);
        i = Math.max(contents.lastIndexOf(44, position - 1), i);
        return i;
    }

    private int getIndexOfRightSeparator(String contents, int position) {
        int index = contents.length();
        int i = contents.indexOf(32, position);
        if (i != -1) {
            index = Math.min(i, index);
        }
        if ((i = contents.indexOf(44, position)) != -1) {
            index = Math.min(i, index);
        }
        return index;
    }

    private SortedSet<String> getAddressSet() {
        if (this.addressSet != null) {
            return this.addressSet;
        }
        this.addressSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        if (this.errorProposals != null && !this.errorProposals.isEmpty()) {
            for (String proposal : this.errorProposals.keySet()) {
                this.addAddress(this.addressSet, proposal);
            }
            return this.addressSet;
        }
        if (this.proposals.size() > 0) {
            if (this.repositoryUrl != null && this.connectorKind != null) {
                this.currentUser = this.getCurrentUser(this.repositoryUrl, this.connectorKind);
            }
            for (String proposal : this.proposals.keySet()) {
                this.addAddress(this.addressSet, proposal);
            }
            return this.addressSet;
        }
        if (this.currentTask != null) {
            this.addAddress(this.addressSet, this.currentTask.getOwner());
        }
        if (this.currentTaskData != null) {
            this.addAddresses(this.currentTaskData, this.addressSet);
        }
        if (this.repositoryUrl != null && this.connectorKind != null) {
            HashSet<AbstractTask> tasks = new HashSet<AbstractTask>();
            if (this.currentTask != null) {
                tasks.add(this.currentTask);
            }
            this.currentUser = this.getCurrentUser(this.repositoryUrl, this.connectorKind);
            if (this.currentUser != null) {
                this.addressSet.add(this.currentUser);
            }
            Collection allTasks = TasksUiPlugin.getTaskList().getAllTasks();
            for (AbstractTask task : allTasks) {
                if (!this.repositoryUrl.equals(task.getRepositoryUrl())) continue;
                tasks.add(task);
            }
            for (AbstractTask task : tasks) {
                this.addAddresses((ITask)task, this.addressSet);
            }
        }
        return this.addressSet;
    }

    private String getCurrentUser(String repositoryUrl, String connectorKind) {
        AuthenticationCredentials credentials;
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(connectorKind, repositoryUrl);
        if (repository != null && (credentials = repository.getCredentials(AuthenticationType.REPOSITORY)) != null && credentials.getUserName().length() > 0) {
            return credentials.getUserName();
        }
        return null;
    }

    private void addAddresses(ITask task, Set<String> addressSet) {
        this.addAddress(addressSet, task.getOwner());
    }

    private void addAddresses(TaskData data, Set<String> addressSet) {
        this.addPerson(data, addressSet, "task.common.user.reporter");
        this.addPerson(data, addressSet, "task.common.user.assigned");
        this.addPerson(data, addressSet, "task.common.user.cc");
        List comments = data.getAttributeMapper().getAttributesByType(data, "comment");
        for (TaskAttribute commentAttribute : comments) {
            this.addPerson(data, addressSet, commentAttribute);
        }
        List attachments = data.getAttributeMapper().getAttributesByType(data, "attachment");
        for (TaskAttribute attachmentAttribute : attachments) {
            this.addPerson(data, addressSet, attachmentAttribute);
        }
    }

    private void addPerson(TaskData data, Set<String> addresses, String key) {
        TaskAttribute attribute = data.getRoot().getMappedAttribute(key);
        if (attribute != null) {
            this.addPerson(data, addresses, attribute);
        }
    }

    private void addPerson(TaskData data, Set<String> addresses, TaskAttribute attribute) {
        TaskAttributeMetaData metaData = attribute.getMetaData();
        if ("comment".equals(metaData.getType())) {
            TaskCommentMapper mapper = TaskCommentMapper.createFrom((TaskAttribute)attribute);
            this.addPerson(addresses, mapper.getAuthor());
        } else if ("attachment".equals(metaData.getType())) {
            TaskAttachmentMapper mapper = TaskAttachmentMapper.createFrom((TaskAttribute)attribute);
            this.addPerson(addresses, mapper.getAuthor());
        } else if ("person".equals(metaData.getType())) {
            this.addPerson(addresses, data.getAttributeMapper().getRepositoryPerson(attribute));
        } else {
            List values = attribute.getValues();
            for (String value : values) {
                this.addAddress(addresses, value);
            }
        }
    }

    private void addPerson(Set<String> addresses, IRepositoryPerson repositoryPerson) {
        if (repositoryPerson != null) {
            addresses.add(repositoryPerson.getPersonId());
            if (repositoryPerson.getName() != null) {
                this.proposals.put(repositoryPerson.getPersonId(), repositoryPerson.getName());
            }
        }
    }

    private void addAddress(Set<String> addresses, String address) {
        if (address != null && address.trim().length() > 0) {
            addresses.add(address.trim());
        }
    }

    public Map<String, String> getProposals() {
        return this.proposals;
    }

    public Map<String, String> getErrorProposals() {
        return this.errorProposals;
    }

    public void setErrorProposals(Map<String, String> errorProposals) {
        this.errorProposals = errorProposals;
        this.addressSet = null;
    }
}

