/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.commons.workbench.forms.DatePicker;
import org.eclipse.mylyn.commons.workbench.forms.DateSelectionDialog;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleTaskMenuContributor
implements IDynamicSubMenuContributor {
    private AbstractTask singleTaskSelection;
    private final List<IRepositoryElement> taskListElementsToSchedule = new ArrayList<IRepositoryElement>();

    @Override
    public MenuManager getSubMenuManager(List<IRepositoryElement> selectedElements) {
        IRepositoryElement selectedElement2;
        this.singleTaskSelection = null;
        this.taskListElementsToSchedule.clear();
        final MenuManager subMenuManager = new MenuManager(Messages.ScheduleTaskMenuContributor_Schedule_for);
        if (selectedElements.size() == 1 && (selectedElement2 = selectedElements.get(0)) instanceof ITask) {
            this.singleTaskSelection = (AbstractTask)selectedElement2;
        }
        for (IRepositoryElement selectedElement2 : selectedElements) {
            if (!(selectedElement2 instanceof ITask)) continue;
            this.taskListElementsToSchedule.add(selectedElement2);
        }
        if (this.selectionIncludesCompletedTasks()) {
            Action action = new Action(){

                public void run() {
                }
            };
            action.setText(Messages.ScheduleTaskMenuContributor_Cannot_schedule_completed_tasks);
            action.setEnabled(false);
            subMenuManager.add((IAction)action);
            return subMenuManager;
        }
        WeekDateRange week = TaskActivityUtil.getCurrentWeek();
        int days = 0;
        for (DateRange day : week.getDaysOfWeek()) {
            Action action;
            if (day.includes(TaskActivityUtil.getCalendar())) {
                ++days;
                action = this.createDateSelectionAction(day, CommonImages.SCHEDULE_DAY);
                subMenuManager.add((IAction)action);
                if (this.singleTaskSelection == null || !this.isPastReminder(this.singleTaskSelection)) continue;
                action.setChecked(true);
                continue;
            }
            if (!day.after(TaskActivityUtil.getCalendar())) continue;
            ++days;
            action = this.createDateSelectionAction(day, null);
            subMenuManager.add((IAction)action);
        }
        int toAdd = 7 - days;
        WeekDateRange nextWeek = TaskActivityUtil.getNextWeek();
        int x = 0;
        while (x < toAdd) {
            int next = TasksUiPlugin.getTaskActivityManager().getWeekStartDay() + x;
            if (next > 7) {
                next -= 7;
            }
            DateRange day = nextWeek.getDayOfWeek(next);
            Action action = this.createDateSelectionAction(day, null);
            subMenuManager.add((IAction)action);
            ++x;
        }
        subMenuManager.add((IContributionItem)new Separator());
        Action action = this.createDateSelectionAction((DateRange)week, CommonImages.SCHEDULE_WEEK);
        subMenuManager.add((IAction)action);
        if (this.isThisWeek(this.singleTaskSelection)) {
            action.setChecked(true);
        }
        action = this.createDateSelectionAction((DateRange)week.next(), null);
        subMenuManager.add((IAction)action);
        action = this.createDateSelectionAction((DateRange)week.next().next(), null);
        subMenuManager.add((IAction)action);
        if (this.singleTaskSelection != null && this.getScheduledForDate(this.singleTaskSelection) != null) {
            DateRange range = this.getScheduledForDate(this.singleTaskSelection);
            if (range.equals((Object)TaskActivityUtil.getNextWeek().next()) || TaskActivityUtil.getNextWeek().next().includes(range)) {
                action.setChecked(true);
            }
            if (this.getScheduledForDate(this.singleTaskSelection).after(week.next().next().getEndDate()) && !(this.getScheduledForDate(this.singleTaskSelection) instanceof WeekDateRange)) {
                action = new Action(){

                    public void run() {
                    }
                };
                action.setChecked(true);
                action.setText(Messages.ScheduleTaskMenuContributor_Future);
                subMenuManager.add((IAction)action);
            }
        }
        subMenuManager.add((IContributionItem)new Separator());
        action = new Action(){

            public void run() {
                DateSelectionDialog reminderDialog;
                int result;
                Calendar theCalendar = TaskActivityUtil.getCalendar();
                if (ScheduleTaskMenuContributor.this.getScheduledForDate(ScheduleTaskMenuContributor.this.singleTaskSelection) != null) {
                    theCalendar.setTime(ScheduleTaskMenuContributor.this.getScheduledForDate(ScheduleTaskMenuContributor.this.singleTaskSelection).getStartDate().getTime());
                }
                Shell shell = null;
                if (subMenuManager != null && subMenuManager.getMenu() != null && !subMenuManager.getMenu().isDisposed()) {
                    shell = subMenuManager.getMenu().getShell();
                }
                if (shell == null) {
                    shell = WorkbenchUtil.getShell();
                }
                if ((result = (reminderDialog = new DateSelectionDialog(shell, theCalendar, DatePicker.TITLE_DIALOG, false, TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"))).open()) == 0) {
                    DayDateRange range = null;
                    if (reminderDialog.getDate() != null) {
                        range = TaskActivityUtil.getDayOf((Date)reminderDialog.getDate());
                    }
                    ScheduleTaskMenuContributor.this.setScheduledDate((DateRange)range);
                }
            }
        };
        action.setText(Messages.ScheduleTaskMenuContributor_Choose_Date_);
        action.setEnabled(this.canSchedule());
        subMenuManager.add((IAction)action);
        action = new Action(){

            public void run() {
                ScheduleTaskMenuContributor.this.setScheduledDate(null);
            }
        };
        action.setText(Messages.ScheduleTaskMenuContributor_Not_Scheduled);
        action.setChecked(false);
        if (this.singleTaskSelection != null && this.getScheduledForDate(this.singleTaskSelection) == null) {
            action.setChecked(true);
        }
        subMenuManager.add((IAction)action);
        return subMenuManager;
    }

    private boolean isThisWeek(AbstractTask task) {
        return task != null && task.getScheduledForDate() != null && task.getScheduledForDate() instanceof WeekDateRange && task.getScheduledForDate().isBefore((DateRange)TaskActivityUtil.getCurrentWeek());
    }

    private boolean selectionIncludesCompletedTasks() {
        if (this.singleTaskSelection instanceof AbstractTask && this.singleTaskSelection.isCompleted()) {
            return true;
        }
        if (this.taskListElementsToSchedule.size() > 0) {
            for (IRepositoryElement task : this.taskListElementsToSchedule) {
                if (!(task instanceof AbstractTask) || !((AbstractTask)task).isCompleted()) continue;
                return true;
            }
        }
        return false;
    }

    private Action createDateSelectionAction(final DateRange dateContainer, ImageDescriptor imageDescriptor) {
        Action action = new Action(){

            public void run() {
                ScheduleTaskMenuContributor.this.setScheduledDate(dateContainer);
            }
        };
        action.setText(dateContainer.toString());
        action.setImageDescriptor(imageDescriptor);
        action.setEnabled(this.canSchedule());
        DateRange scheduledDate = this.getScheduledForDate(this.singleTaskSelection);
        if (scheduledDate != null) {
            action.setChecked(dateContainer.equals((Object)scheduledDate));
        }
        return action;
    }

    private boolean canSchedule() {
        if (this.taskListElementsToSchedule.size() == 0) {
            return true;
        }
        if (this.singleTaskSelection instanceof ITask) {
            return !this.singleTaskSelection.isCompleted() || this.taskListElementsToSchedule.size() > 0;
        }
        return this.taskListElementsToSchedule.size() > 0;
    }

    protected void setScheduledDate(DateRange dateContainer) {
        for (IRepositoryElement element : this.taskListElementsToSchedule) {
            if (!(element instanceof AbstractTask)) continue;
            AbstractTask task = (AbstractTask)element;
            TasksUiPlugin.getTaskList().addTaskIfAbsent((ITask)task);
            if (dateContainer != null) {
                TasksUiPlugin.getTaskActivityManager().setScheduledFor(task, dateContainer);
                continue;
            }
            TasksUiPlugin.getTaskActivityManager().setScheduledFor(task, null);
        }
    }

    protected DateRange getScheduledForDate(AbstractTask selectedTask) {
        if (selectedTask != null) {
            return selectedTask.getScheduledForDate();
        }
        return null;
    }

    private boolean isPastReminder(AbstractTask task) {
        return TasksUiPlugin.getTaskActivityManager().isPastReminder(task);
    }
}

