/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.File;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.DownloadAttachmentJob;
import org.eclipse.mylyn.internal.tasks.ui.util.Messages;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAttachmentsAction
extends Action {
    public SaveAttachmentsAction(String text) {
        super(text);
    }

    public void run() {
        List<ITaskAttachment> attachments = AttachmentUtil.getSelectedAttachments(null);
        if (attachments.isEmpty()) {
            return;
        }
        if (attachments.size() == 1) {
            this.saveSingleAttachment(attachments.get(0));
        } else {
            this.saveAllAttachments(attachments);
        }
    }

    private void saveSingleAttachment(ITaskAttachment attachment) {
        String filePath;
        FileDialog fileChooser = new FileDialog(WorkbenchUtil.getShell(), 8192);
        fileChooser.setFileName(AttachmentUtil.getAttachmentFilename(attachment));
        File initDirectory = this.getInitialDirectory();
        if (initDirectory != null) {
            fileChooser.setFilterPath(initDirectory.getAbsolutePath());
        }
        if ((filePath = fileChooser.open()) == null) {
            return;
        }
        File file = new File(filePath);
        if (file.exists() && !MessageDialog.openConfirm((Shell)WorkbenchUtil.getShell(), (String)Messages.TasksUiMenus_File_exists_, (String)(String.valueOf(Messages.TasksUiMenus_Overwrite_existing_file_) + file.getName()))) {
            return;
        }
        initDirectory = file.getParentFile();
        if (initDirectory != null) {
            this.saveInitialDirectory(initDirectory.getAbsolutePath());
        }
        DownloadAttachmentJob job = new DownloadAttachmentJob(attachment, file);
        job.setUser(true);
        job.schedule();
    }

    private void saveAllAttachments(List<ITaskAttachment> attachments) {
        String directoryPath;
        DirectoryDialog dialog = new DirectoryDialog(WorkbenchUtil.getShell());
        dialog.setText(Messages.SaveAttachmentsAction_selectDirectory);
        dialog.setMessage(Messages.SaveAttachmentsAction_selectDirectoryHint);
        File initDirectory = this.getInitialDirectory();
        if (initDirectory != null) {
            dialog.setFilterPath(initDirectory.getAbsolutePath());
        }
        if ((directoryPath = dialog.open()) == null) {
            return;
        }
        this.saveInitialDirectory(directoryPath);
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.SaveAttachmentsAction_directoryDoesntExist, (String)NLS.bind((String)Messages.SaveAttachmentsAction_directoryDoesntExist0, (Object)directoryPath));
            return;
        }
        for (ITaskAttachment attachment : attachments) {
            String filename = AttachmentUtil.getAttachmentFilename(attachment);
            File file = this.getTargetFile(WorkbenchUtil.getShell(), directory, filename);
            if (file == null) continue;
            DownloadAttachmentJob job = new DownloadAttachmentJob(attachment, file);
            job.setUser(true);
            job.schedule();
        }
    }

    private File getTargetFile(Shell shell, File directory, String filename) {
        File attachFile = new File(directory, filename);
        while (attachFile.exists()) {
            boolean overwrite = MessageDialog.openQuestion((Shell)shell, (String)NLS.bind((String)Messages.SaveAttachmentsAction_overwriteFile0, (Object)attachFile.getName()), (String)NLS.bind((String)Messages.SaveAttachmentsAction_fileExists_doYouWantToOverwrite0, (Object)attachFile.getAbsolutePath()));
            if (overwrite) {
                return attachFile;
            }
            FileDialog fileDialog = new FileDialog(shell, 8192);
            fileDialog.setFilterPath(directory.getAbsolutePath());
            fileDialog.setFileName(attachFile.getName());
            filename = fileDialog.open();
            if (filename == null) {
                return null;
            }
            attachFile = new File(filename);
        }
        return attachFile;
    }

    private File getInitialDirectory() {
        String dirName = TasksUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.attachments.defaultDirectory");
        if (dirName == null || dirName.trim().length() == 0) {
            return null;
        }
        File dirFile = new File(dirName).getAbsoluteFile();
        while (dirFile != null && !dirFile.exists()) {
            dirFile = dirFile.getParentFile();
        }
        return dirFile;
    }

    private void saveInitialDirectory(String directory) {
        TasksUiPlugin.getDefault().getPreferenceStore().putValue("org.eclipse.mylyn.tasks.ui.attachments.defaultDirectory", directory);
    }
}

