/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractTaskEditorSection
extends AbstractTaskEditorPart {
    private Section section;
    private final List<AbstractTaskEditorPart> subParts = new ArrayList<AbstractTaskEditorPart>();

    public void addSubPart(String path, AbstractTaskEditorPart part) {
        this.subParts.add(part);
    }

    protected abstract Control createContent(FormToolkit var1, Composite var2);

    public void createControl(Composite parent, final FormToolkit toolkit) {
        boolean expand = this.shouldExpandOnCreate();
        this.section = this.createSection(parent, toolkit, expand);
        if (expand) {
            this.createSectionClient(toolkit, this.section);
        } else {
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (AbstractTaskEditorSection.this.section.getClient() == null) {
                        AbstractTaskEditorSection.this.createSectionClient(toolkit, AbstractTaskEditorSection.this.section);
                        AbstractTaskEditorSection.this.getTaskEditorPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, this.section);
    }

    private void createInfoOverlay(Composite composite, Section section, FormToolkit toolkit) {
        String text = this.getInfoOverlayText();
        if (text == null) {
            return;
        }
        final Label label = toolkit.createLabel(composite, CommonUiUtil.toLabel((String)text));
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setBackground(null);
        label.setVisible(!section.isExpanded());
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                label.setVisible(!e.getState());
            }
        });
    }

    private void createSectionClient(final FormToolkit toolkit, Section section) {
        if (this.subParts.size() > 0) {
            final Composite sectionClient = toolkit.createComposite((Composite)section);
            GridLayout layout = EditorUtil.createSectionClientLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            sectionClient.setLayout((Layout)layout);
            Control content = this.createContent(toolkit, sectionClient);
            GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo(content);
            section.setClient((Control)sectionClient);
            for (final AbstractTaskEditorPart part : this.subParts) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error creating task editor part: \"" + part.getPartId() + "\"", e));
                    }

                    public void run() throws Exception {
                        part.createControl(sectionClient, toolkit);
                        if (part.getControl() != null) {
                            GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo(part.getControl());
                        }
                    }
                });
            }
        } else {
            Control content = this.createContent(toolkit, (Composite)section);
            section.setClient(content);
        }
    }

    protected String getInfoOverlayText() {
        return null;
    }

    public Section getSection() {
        return this.section;
    }

    public void removeSubPart(AbstractTaskEditorPart part) {
        this.subParts.remove((Object)part);
    }

    protected void setSection(FormToolkit toolkit, Section section) {
        if (section.getTextClient() == null) {
            ToolBarManager toolBarManager = new ToolBarManager(0x800000);
            this.fillToolBar(toolBarManager);
            if (toolBarManager.getSize() > 0) {
                Composite toolbarComposite = toolkit.createComposite((Composite)section);
                toolbarComposite.setBackground(null);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginLeft = 0;
                rowLayout.marginRight = 0;
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                rowLayout.center = true;
                toolbarComposite.setLayout((Layout)rowLayout);
                this.createInfoOverlay(toolbarComposite, section, toolkit);
                toolBarManager.createControl(toolbarComposite);
                section.clientVerticalSpacing = 0;
                section.descriptionVerticalSpacing = 0;
                section.setTextClient((Control)toolbarComposite);
            }
        }
        this.setControl((Control)section);
    }

    protected abstract boolean shouldExpandOnCreate();
}

