/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.ExtensionPointReader;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TaskDropListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDropHandler {
    private List<TaskDropListener> taskDropListeners;

    TaskDropHandler() {
    }

    public void loadTaskDropListeners() {
        if (this.taskDropListeners == null) {
            ExtensionPointReader reader = new ExtensionPointReader("org.eclipse.mylyn.tasks.ui", "taskDropListener", "listener", TaskDropListener.class);
            IStatus status = reader.read();
            if (!status.isOK()) {
                StatusHandler.log((IStatus)status);
            }
            this.taskDropListeners = reader.getItems();
        }
    }

    public void fireTaskDropped(List<ITask> tasksToMove, ITask currentTarget, TaskDropListener.Operation operation) {
        final TaskDropListener.TaskDropEvent event = new TaskDropListener.TaskDropEvent(tasksToMove, currentTarget, operation);
        for (final TaskDropListener listener : this.taskDropListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.tasksDropped(event);
                }

                public void handleException(Throwable exception) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", exception.getMessage(), exception));
                }
            });
        }
    }
}

